/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.BlockDev;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.Tools;

public final class Volume
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private static final String[] PARAMS = new String[]{"number", "device"};

    public Volume(WizardDialog previousDialog, DrbdVolumeInfo dvi) {
        super(previousDialog, dvi);
    }

    @Override
    public WizardDialog nextDialog() {
        Tools.waitForSwing();
        this.getDrbdVolumeInfo().apply(false);
        return new BlockDev(this, this.getDrbdVolumeInfo(), this.getDrbdVolumeInfo().getFirstBlockDevInfo());
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.Volume.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.Volume.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        boolean ch = this.getDrbdVolumeInfo().checkResourceFieldsChanged(null, PARAMS);
        boolean cor = this.getDrbdVolumeInfo().checkResourceFieldsCorrect(null, PARAMS);
        if (cor) {
            this.enableComponents();
        } else {
            this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Volume.this.makeDefaultButton(Volume.this.buttonClass(Volume.this.nextButton()));
            }
        });
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Volume.this.pressNextButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        DrbdResourceInfo dri = this.getDrbdVolumeInfo().getDrbdResourceInfo();
        DrbdInfo drbdInfo = dri.getDrbdInfo();
        this.getDrbdVolumeInfo().waitForInfoPanel();
        Tools.waitForSwing();
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentY(0.0f);
        this.getDrbdVolumeInfo().addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.DrbdConfig.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.DrbdConfig.Resource.FieldWidth"), null);
        inputPane.add(optionsPanel);
        JScrollPane sp = new JScrollPane(inputPane);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        return sp;
    }
}

