/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.Label;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.WidgetListener;
import org.apache.commons.collections15.map.MultiKeyMap;

public abstract class EditableInfo
extends Info {
    private final Map<String, Boolean> paramCorrectValueMap = new HashMap<String, Boolean>();
    private final MultiKeyMap<String, JPanel> sectionPanels = new MultiKeyMap();
    private MyButton oldApplyButton = null;
    private MyButton applyButton;
    private MyButton revertButton;
    private CountDownLatch infoPanelLatch = new CountDownLatch(1);
    private final List<JPanel> advancedPanelList = new ArrayList<JPanel>();
    private final List<String> advancedOnlySectionList = new ArrayList<String>();
    private final JPanel moreOptionsPanel = new JPanel();
    private boolean dialogStarted = false;
    private final Set<String> disabledSections = new HashSet<String>();
    public static final boolean WIZARD = true;

    protected abstract String getSection(String var1);

    protected abstract boolean isRequired(String var1);

    protected abstract boolean isAdvanced(String var1);

    protected abstract String isEnabled(String var1);

    protected abstract ConfigData.AccessType getAccessType(String var1);

    protected abstract boolean isEnabledOnlyInAdvancedMode(String var1);

    protected abstract boolean isLabel(String var1);

    protected abstract boolean isInteger(String var1);

    protected abstract boolean isTimeType(String var1);

    protected boolean hasUnitPrefix(String param) {
        return false;
    }

    protected abstract boolean isCheckBox(String var1);

    protected Widget.Type getFieldType(String param) {
        return null;
    }

    protected abstract String getParamType(String var1);

    protected String getParamRegexp(String param) {
        if (this.isInteger(param)) {
            return "^((-?\\d*|(-|\\+)?INFINITY|disabled))|@NOTHING_SELECTED@$";
        }
        return null;
    }

    protected abstract Object[] getParamPossibleChoices(String var1);

    public abstract String[] getParametersFromXML();

    public int getUsed() {
        return -1;
    }

    EditableInfo(String name, Browser browser) {
        super(name, browser);
    }

    final void initApplyButton(ButtonCallback buttonCallback) {
        this.initApplyButton(buttonCallback, Tools.getString("Browser.ApplyResource"));
    }

    final void initCommitButton(ButtonCallback buttonCallback) {
        this.initApplyButton(buttonCallback, Tools.getString("Browser.CommitResources"));
    }

    final void initApplyButton(ButtonCallback buttonCallback, String text) {
        if (this.oldApplyButton == null) {
            this.applyButton = new MyButton(text, Browser.APPLY_ICON);
            this.applyButton.miniButton();
            this.applyButton.setEnabled(false);
            this.oldApplyButton = this.applyButton;
            this.revertButton = new MyButton(Tools.getString("Browser.RevertResource"), Browser.REVERT_ICON);
            this.revertButton.setEnabled(false);
            this.revertButton.setToolTipText(Tools.getString("Browser.RevertResource.ToolTip"));
            this.revertButton.miniButton();
            this.revertButton.setPreferredSize(new Dimension(65, 50));
        } else {
            this.applyButton = this.oldApplyButton;
        }
        this.applyButton.setEnabled(false);
        if (buttonCallback != null) {
            this.addMouseOverListener(this.applyButton, buttonCallback);
        }
    }

    protected final void addApplyButton(JPanel panel) {
        panel.add((Component)this.applyButton, "West");
    }

    protected final void addRevertButton(JPanel panel) {
        JPanel p = new JPanel(new FlowLayout(2, 4, 0));
        p.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        p.add(this.revertButton);
        panel.add((Component)p, "Center");
    }

    public final void addLabelField(JPanel panel, String left, String right, int leftWidth, int rightWidth, int height) {
        JLabel leftLabel = new JLabel(left);
        leftLabel.setToolTipText(left);
        JLabel rightLabel = new JLabel(right);
        rightLabel.setToolTipText(right);
        this.addField(panel, leftLabel, rightLabel, leftWidth, rightWidth, height);
    }

    public final void addField(JPanel panel, JComponent left, JComponent right, int leftWidth, int rightWidth, int height) {
        if (height == 0) {
            height = Tools.getDefaultSize("Browser.FieldHeight");
        }
        Tools.setSize(left, leftWidth, height);
        panel.add(left);
        Tools.setSize(right, rightWidth, height);
        panel.add(right);
        right.setBackground(panel.getBackground());
    }

    public final void addWizardParams(JPanel optionsPanel, String[] params, MyButton wizardApplyButton, int leftWidth, int rightWidth, Map<String, Widget> sameAsFields) {
        this.addParams(optionsPanel, "widget", params, wizardApplyButton, leftWidth, rightWidth, sameAsFields);
    }

    public final void addParams(JPanel optionsPanel, String[] params, int leftWidth, int rightWidth, Map<String, Widget> sameAsFields) {
        this.addParams(optionsPanel, null, params, this.applyButton, leftWidth, rightWidth, sameAsFields);
    }

    private void addParams(JPanel optionsPanel, String prefix, String[] params, final MyButton thisApplyButton, int leftWidth, int rightWidth, Map<String, Widget> sameAsFields) {
        Widget rpwi;
        Widget paramWi;
        Boolean advanced;
        String advancedString;
        String accessTypeString;
        if (params == null) {
            return;
        }
        MultiKeyMap<String, JPanel> panelPartsMap = new MultiKeyMap<String, JPanel>();
        ArrayList<PanelPart> panelPartsList = new ArrayList<PanelPart>();
        MultiKeyMap<String, Integer> panelPartRowsMap = new MultiKeyMap<String, Integer>();
        for (final String param : params) {
            JPanel panel;
            ConfigData.AccessType accessType;
            final Widget paramWi2 = this.createWidget(param, prefix, rightWidth);
            String section = this.getSection(param);
            if (panelPartsMap.containsKey((K[])new String[]{section, accessTypeString = (accessType = this.getAccessType(param)).toString(), advancedString = (advanced = Boolean.valueOf(this.isAdvanced(param))).toString()})) {
                panel = (JPanel)panelPartsMap.get((K[])new String[]{section, accessTypeString, advancedString});
                panelPartRowsMap.put(section, accessTypeString, advancedString, (Integer)panelPartRowsMap.get((K[])new String[]{section, accessTypeString, advancedString}) + 1);
            } else {
                panel = new JPanel(new SpringLayout());
                panel.setBackground(this.getSectionColor(section));
                if (advanced.booleanValue()) {
                    this.advancedPanelList.add(panel);
                    final JPanel p = panel;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            p.setVisible(Tools.getConfigData().isAdvancedMode());
                        }
                    });
                }
                panelPartsMap.put(section, accessTypeString, advancedString, panel);
                panelPartsList.add(new PanelPart(section, accessType, advanced));
                panelPartRowsMap.put(section, accessTypeString, advancedString, 1);
            }
            final JLabel label = new JLabel(this.getParamShortDesc(param));
            final String longDesc = this.getParamLongDesc(param);
            paramWi2.setLabel(label, longDesc);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    paramWi2.setToolTipText(EditableInfo.this.getToolTipText(param, paramWi2));
                    label.setToolTipText(longDesc);
                }
            });
            int height = 0;
            if (paramWi2 instanceof Label) {
                height = Tools.getDefaultSize("Browser.LabelFieldHeight");
            }
            this.addField(panel, label, paramWi2, leftWidth, rightWidth, height);
        }
        boolean wizard = "widget".equals(prefix);
        for (final String param : params) {
            paramWi = this.getWidget(param, prefix);
            rpwi = null;
            if (!wizard) continue;
            rpwi = this.getWidget(param, null);
            if (rpwi == null) {
                Tools.appError("unkown param: " + param + ". Man pages not installed?");
                continue;
            }
            int height = 0;
            if (rpwi instanceof Label) {
                height = Tools.getDefaultSize("Browser.LabelFieldHeight");
            }
            final Widget rpwi0 = rpwi;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (paramWi.getValue() == null || paramWi.getValue() == Widget.NOTHING_SELECTED_DISPLAY) {
                        rpwi0.setValueAndWait(null);
                    } else {
                        String value = paramWi.getStringValue();
                        rpwi0.setValueAndWait(value);
                    }
                }
            });
        }
        for (final String param : params) {
            paramWi = this.getWidget(param, prefix);
            rpwi = null;
            if (wizard) {
                rpwi = this.getWidget(param, null);
            }
            final Widget realParamWi = rpwi;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    paramWi.addListeners(new WidgetListener(){

                        @Override
                        public void check(Object value) {
                            EditableInfo.this.checkParameterFields(paramWi, realParamWi, param, EditableInfo.this.getParametersFromXML(), thisApplyButton);
                        }
                    });
                }
            });
        }
        HashMap<String, JPanel> sectionMap = new HashMap<String, JPanel>();
        HashSet<JPanel> notAdvancedSections = new HashSet<JPanel>();
        HashSet<JPanel> advancedSections = new HashSet<JPanel>();
        for (PanelPart panelPart : panelPartsList) {
            JPanel sectionPanel;
            final String section = panelPart.getSection();
            ConfigData.AccessType accessType = panelPart.getAccessType();
            accessTypeString = accessType.toString();
            advanced = panelPart.isAdvanced();
            advancedString = advanced.toString();
            JPanel panel = (JPanel)panelPartsMap.get((K[])new String[]{section, accessTypeString, advancedString});
            int rows = (Integer)panelPartRowsMap.get((K[])new String[]{section, accessTypeString, advancedString});
            int columns = 2;
            SpringUtilities.makeCompactGrid(panel, rows, 2, 1, 1, 1, 1);
            if (sectionMap.containsKey(section)) {
                sectionPanel = (JPanel)sectionMap.get(section);
            } else {
                Widget sameAsCombo;
                sectionPanel = this.getParamPanel(this.getSectionDisplayName(section), this.getSectionColor(section));
                sectionMap.put(section, sectionPanel);
                this.addSectionPanel(section, wizard, sectionPanel);
                optionsPanel.add(sectionPanel);
                if (sameAsFields != null && (sameAsCombo = sameAsFields.get(section)) != null) {
                    JPanel saPanel = new JPanel(new SpringLayout());
                    saPanel.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
                    JLabel label = new JLabel("Same As");
                    sameAsCombo.setLabel(label, "");
                    this.addField(saPanel, label, sameAsCombo, leftWidth, rightWidth, 0);
                    SpringUtilities.makeCompactGrid(saPanel, 1, 2, 1, 1, 1, 1);
                    sectionPanel.add(saPanel);
                }
            }
            sectionPanel.setVisible(this.isSectionEnabled(section));
            sectionPanel.add(panel);
            if (advanced.booleanValue()) {
                advancedSections.add(sectionPanel);
                continue;
            }
            notAdvancedSections.add(sectionPanel);
        }
        boolean advanced2 = false;
        for (final String section : sectionMap.keySet()) {
            final JPanel sectionPanel = (JPanel)sectionMap.get(section);
            if (advancedSections.contains(sectionPanel)) {
                advanced2 = true;
            }
            if (notAdvancedSections.contains(sectionPanel)) continue;
            this.advancedOnlySectionList.add(section);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sectionPanel.setVisible(Tools.getConfigData().isAdvancedMode() && EditableInfo.this.isSectionEnabled(section));
                }
            });
        }
        final boolean a = advanced2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditableInfo.this.moreOptionsPanel.setVisible(a && !Tools.getConfigData().isAdvancedMode());
            }
        });
    }

    protected final JPanel getMoreOptionsPanel(int width) {
        JLabel l = new JLabel(Tools.getString("EditableInfo.MoreOptions"));
        Font font = l.getFont();
        String name = font.getFontName();
        int style = 2;
        int size = font.getSize();
        l.setFont(new Font(name, 2, size - 3));
        this.moreOptionsPanel.setBackground(Browser.PANEL_BACKGROUND);
        this.moreOptionsPanel.add(l);
        Dimension d = this.moreOptionsPanel.getPreferredSize();
        d.width = width;
        this.moreOptionsPanel.setMaximumSize(d);
        return this.moreOptionsPanel;
    }

    public void checkParameterFields(final Widget paramWi, final Widget realParamWi, final String param, final String[] params, final MyButton thisApplyButton) {
        EditableInfo thisClass = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean c;
                boolean ch = false;
                if (realParamWi == null) {
                    Tools.waitForSwing();
                    ch = EditableInfo.this.checkResourceFieldsChanged(param, params);
                    c = EditableInfo.this.checkResourceFieldsCorrect(param, params);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (paramWi.getValue() == null || paramWi.getValue() == Widget.NOTHING_SELECTED_DISPLAY) {
                                realParamWi.setValueAndWait(null);
                            } else {
                                String value = paramWi.getStringValue();
                                realParamWi.setValueAndWait(value);
                            }
                        }
                    });
                    Tools.waitForSwing();
                    c = EditableInfo.this.checkResourceFieldsCorrect(param, params);
                }
                final boolean check = c;
                final boolean changed = ch;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (thisApplyButton == EditableInfo.this.applyButton) {
                            thisApplyButton.setEnabled(!EditableInfo.this.isDialogStarted() && check && (changed || EditableInfo.this.getResource().isNew()));
                        } else {
                            thisApplyButton.setEnabled(check);
                        }
                        if (EditableInfo.this.revertButton != null) {
                            EditableInfo.this.revertButton.setEnabled(changed);
                        }
                        String toolTip = EditableInfo.this.getToolTipText(param, paramWi);
                        paramWi.setToolTipText(toolTip);
                        if (realParamWi != null) {
                            realParamWi.setToolTipText(toolTip);
                        }
                    }
                });
            }
        });
        thread.start();
    }

    public final String getComboBoxValue(String param) {
        String value;
        Widget wi = this.getWidget(param, null);
        if (wi == null) {
            return null;
        }
        Object o = wi.getValue();
        if (Tools.isStringClass(o)) {
            value = wi.getStringValue();
        } else if (o instanceof Object[]) {
            value = ((Object[])o)[0].toString();
            if (((Object[])o)[1] instanceof Unit) {
                value = value + ((Unit)((Object[])o)[1]).getShortName();
            }
        } else {
            value = ((Info)o).getInternalValue();
        }
        return value;
    }

    protected void storeComboBoxValues(String[] params) {
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            this.getResource().setValue(param, value);
            Widget wi = this.getWidget(param, null);
            if (wi == null) continue;
            wi.setToolTipText(this.getToolTipText(param, wi));
        }
    }

    protected Widget createWidget(String param, String prefix, int width) {
        this.getResource().setPossibleChoices(param, this.getParamPossibleChoices(param));
        String initValue = this.getPreviouslySelected(param, prefix);
        if (initValue == null) {
            String value = this.getParamSaved(param);
            if (value == null || "".equals(value)) {
                if (this.getResource().isNew() && (initValue = this.getResource().getPreferredValue(param)) == null) {
                    initValue = this.getParamPreferred(param);
                }
                if (initValue == null) {
                    initValue = this.getParamDefault(param);
                    this.getResource().setValue(param, initValue);
                }
            } else {
                initValue = value;
            }
        }
        String regexp = this.getParamRegexp(param);
        HashMap<String, String> abbreviations = new HashMap<String, String>();
        if (this.isInteger(param)) {
            abbreviations = new HashMap();
            abbreviations.put("i", "INFINITY");
            abbreviations.put("I", "INFINITY");
            abbreviations.put("+", "+INFINITY");
            abbreviations.put("d", "disabled");
            abbreviations.put("D", "disabled");
        }
        Widget.Type type = this.getFieldType(param);
        Unit[] units = null;
        if (type == Widget.Type.TEXTFIELDWITHUNIT) {
            units = this.getUnits();
        }
        if (this.isCheckBox(param)) {
            type = Widget.Type.CHECKBOX;
        } else if (this.isTimeType(param)) {
            type = Widget.Type.TEXTFIELDWITHUNIT;
            units = this.getTimeUnits();
        } else if (this.isLabel(param)) {
            type = Widget.Type.LABELFIELD;
        }
        Widget paramWi = WidgetFactory.createInstance(type, initValue, this.getPossibleChoices(param), units, regexp, width, abbreviations, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), null);
        this.widgetAdd(param, prefix, paramWi);
        paramWi.setEditable(true);
        return paramWi;
    }

    protected abstract boolean checkParam(String var1, String var2);

    protected final boolean checkRegexp(String param, String newValue) {
        Widget wi;
        String regexp = this.getParamRegexp(param);
        if (regexp == null && (wi = this.getWidget(param, null)) != null) {
            regexp = wi.getRegexp();
        }
        if (regexp != null) {
            Pattern p = Pattern.compile(regexp);
            Matcher m = p.matcher(newValue);
            return m.matches();
        }
        return true;
    }

    protected boolean checkParamCache(String param) {
        if (!this.paramCorrectValueMap.containsKey(param)) {
            return false;
        }
        Boolean ret = this.paramCorrectValueMap.get(param);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    protected final void setCheckParamCache(String param, boolean correctValue) {
        this.paramCorrectValueMap.put(param, correctValue);
    }

    protected abstract String getParamDefault(String var1);

    protected String getParamSaved(String param) {
        return this.getResource().getValue(param);
    }

    protected abstract String getParamPreferred(String var1);

    protected abstract String getParamShortDesc(String var1);

    protected abstract String getParamLongDesc(String var1);

    protected Object[] getPossibleChoices(String param) {
        return this.getResource().getPossibleChoices(param);
    }

    protected final JPanel getParamPanel(String title) {
        return this.getParamPanel(title, Browser.PANEL_BACKGROUND);
    }

    protected final JPanel getParamPanel(String title, Color background) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(background);
        TitledBorder titleBorder = Tools.getBorder(title);
        panel.setBorder(titleBorder);
        return panel;
    }

    protected final String getToolTipText(String param, Widget wi) {
        String defaultValue = this.getParamDefault(param);
        StringBuilder ret = new StringBuilder(120);
        if (wi != null) {
            String value = wi.getStringValue();
            ret.append("<b>");
            ret.append((Object)value);
            ret.append("</b>");
        }
        if (defaultValue != null && !defaultValue.equals("")) {
            ret.append("<table><tr><td><b>");
            ret.append(Tools.getString("Browser.ParamDefault"));
            ret.append("</b></td><td>");
            ret.append(defaultValue);
            ret.append("</td></tr></table>");
        }
        return ret.toString();
    }

    public final void setApplyButtons(String param, String[] params) {
        final boolean ch = this.checkResourceFieldsChanged(param, params);
        final boolean cor = this.checkResourceFieldsCorrect(param, params);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyButton rb;
                MyButton ab = EditableInfo.this.getApplyButton();
                Resource r = EditableInfo.this.getResource();
                if (ab != null) {
                    ab.setEnabled((ch || r != null && r.isNew()) && cor);
                }
                if ((rb = EditableInfo.this.getRevertButton()) != null) {
                    rb.setEnabled(ch);
                }
            }
        });
    }

    protected void checkOneParam(String param) {
        this.checkResourceFieldsCorrect(param, new String[]{param});
    }

    boolean checkResourceFieldsCorrect(String param, String[] params) {
        boolean correctValue = true;
        if (params != null) {
            for (String otherParam : params) {
                String newValue;
                Widget wi = this.getWidget(otherParam, null);
                if (wi == null) continue;
                Object o = wi.getValue();
                if (Tools.isStringClass(o)) {
                    newValue = wi.getStringValue();
                } else if (o instanceof Object[]) {
                    Object o0 = ((Object[])o)[0];
                    Object o1 = ((Object[])o)[1];
                    newValue = o0.toString();
                    if (o1 != null && o1 instanceof Unit) {
                        newValue = newValue + ((Unit)o1).getShortName();
                    }
                } else {
                    newValue = ((Info)o).getInternalValue();
                }
                if (param == null || otherParam.equals(param) || !this.paramCorrectValueMap.containsKey(param)) {
                    boolean check;
                    Widget wizardWi = this.getWidget(otherParam, "widget");
                    String enable = this.isEnabled(otherParam);
                    if (wizardWi != null) {
                        wizardWi.setDisabledReason(enable);
                        wizardWi.setEnabled(enable == null);
                        Object wo = wizardWi.getValue();
                        newValue = Tools.isStringClass(wo) ? wizardWi.getStringValue() : (wo instanceof Object[] ? ((Object[])wo)[0].toString() + ((Unit)((Object[])wo)[1]).getShortName() : ((Info)wo).getInternalValue());
                    }
                    wi.setDisabledReason(enable);
                    wi.setEnabled(enable == null);
                    boolean bl = check = this.checkParam(otherParam, newValue) && this.checkRegexp(otherParam, newValue);
                    if (check) {
                        if (this.isTimeType(otherParam) || this.hasUnitPrefix(otherParam)) {
                            wi.setBackground(Tools.extractUnit(this.getParamDefault(otherParam)), Tools.extractUnit(this.getParamSaved(otherParam)), this.isRequired(otherParam));
                            if (wizardWi != null) {
                                wizardWi.setBackground(Tools.extractUnit(this.getParamDefault(otherParam)), Tools.extractUnit(this.getParamSaved(otherParam)), this.isRequired(otherParam));
                            }
                        } else {
                            wi.setBackground(this.getParamDefault(otherParam), this.getParamSaved(otherParam), this.isRequired(otherParam));
                            if (wizardWi != null) {
                                wizardWi.setBackground(this.getParamDefault(otherParam), this.getParamSaved(otherParam), this.isRequired(otherParam));
                            }
                        }
                    } else {
                        wi.wrongValue();
                        if (wizardWi != null) {
                            wizardWi.wrongValue();
                        }
                        correctValue = false;
                    }
                    this.setCheckParamCache(otherParam, check);
                    continue;
                }
                correctValue = correctValue && this.checkParamCache(otherParam);
            }
        }
        return correctValue;
    }

    boolean checkResourceFieldsChanged(String param, String[] params) {
        boolean changedValue = false;
        if (params != null) {
            for (String otherParam : params) {
                Widget wi = this.getWidget(otherParam, null);
                if (wi == null) continue;
                Object newValue = wi.getValue();
                Object[] oldValue = this.getParamSaved(otherParam);
                if (oldValue == null) {
                    oldValue = this.getParamDefault(otherParam);
                }
                if (this.isTimeType(otherParam) || this.hasUnitPrefix(otherParam)) {
                    oldValue = Tools.extractUnit((String)oldValue);
                }
                if (!Tools.areEqual(newValue, oldValue)) {
                    changedValue = true;
                }
                wi.processAccessMode();
            }
        }
        return changedValue;
    }

    protected final JLabel getLabel(Widget wi) {
        return wi.getLabel();
    }

    public final void waitForInfoPanel() {
        try {
            boolean ret = this.infoPanelLatch.await(20L, TimeUnit.SECONDS);
            if (!ret) {
                Tools.printStackTrace("latch timeout detected");
            }
            this.infoPanelLatch.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    final void infoPanelDone() {
        this.infoPanelLatch.countDown();
    }

    public void resetInfoPanel() {
        this.infoPanelLatch = new CountDownLatch(1);
    }

    protected final void addToAdvancedList(JPanel p) {
        this.advancedPanelList.add(p);
    }

    @Override
    public void updateAdvancedPanels() {
        super.updateAdvancedPanels();
        final boolean advancedMode = Tools.getConfigData().isAdvancedMode();
        boolean advanced = false;
        for (final JPanel apl : this.advancedPanelList) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    apl.setVisible(advancedMode);
                }
            });
            advanced = true;
        }
        for (final String section : this.advancedOnlySectionList) {
            final JPanel p = this.sectionPanels.get((K[])new String[]{section, Boolean.toString(false)});
            final JPanel pw = this.sectionPanels.get((K[])new String[]{section, Boolean.toString(true)});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean v = advancedMode && EditableInfo.this.isSectionEnabled(section);
                    p.setVisible(v);
                    if (pw != null) {
                        pw.setVisible(v);
                    }
                }
            });
            advanced = true;
        }
        final boolean a = advanced;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditableInfo.this.moreOptionsPanel.setVisible(a && !advancedMode);
            }
        });
    }

    public void revert() {
        String[] params = this.getParametersFromXML();
        if (params == null) {
            return;
        }
        for (String param : params) {
            Widget wi;
            String v = this.getParamSaved(param);
            if (v == null) {
                v = this.getParamDefault(param);
            }
            if ((wi = this.getWidget(param, null)) == null || Tools.areEqual(wi.getStringValue(), v)) continue;
            wi.setValue(v);
            Widget wizardWi = this.getWidget(param, "widget");
            if (wizardWi == null) continue;
            wizardWi.setValue(v);
        }
    }

    final MyButton getApplyButton() {
        return this.applyButton;
    }

    final MyButton getRevertButton() {
        return this.revertButton;
    }

    final void setApplyButton(MyButton applyButton) {
        this.applyButton = applyButton;
    }

    final void setRevertButton(MyButton revertButton) {
        this.revertButton = revertButton;
    }

    private boolean isDialogStarted() {
        return this.dialogStarted;
    }

    public void setDialogStarted(boolean dialogStarted) {
        this.dialogStarted = dialogStarted;
    }

    protected void clearPanelLists() {
        this.advancedPanelList.clear();
        this.advancedOnlySectionList.clear();
        this.sectionPanels.clear();
        this.disabledSections.clear();
    }

    @Override
    final void cleanup() {
        super.cleanup();
        this.clearPanelLists();
    }

    public void reloadComboBoxes() {
    }

    protected final String getPreviouslySelected(String param, String prefix) {
        Widget prevParamWi = this.getWidget(param, prefix);
        if (prevParamWi != null) {
            return prevParamWi.getStringValue();
        }
        return null;
    }

    protected String getSectionDisplayName(String section) {
        return Tools.ucfirst(section);
    }

    protected Color getSectionColor(String section) {
        return Browser.PANEL_BACKGROUND;
    }

    private final JPanel getSectionPanel(String section, boolean wizard) {
        return this.sectionPanels.get((K[])new String[]{section, Boolean.toString(wizard)});
    }

    protected final void addSectionPanel(String section, boolean wizard, JPanel sectionPanel) {
        this.sectionPanels.put(section, Boolean.toString(wizard), sectionPanel);
    }

    protected final void enableSection(String section, boolean enable, boolean wizard) {
        if (enable) {
            this.disabledSections.remove(section);
        } else {
            this.disabledSections.add(section);
        }
        JPanel p = this.getSectionPanel(section, wizard);
        if (p != null) {
            p.setVisible(enable);
        }
    }

    protected final String[] getEnabledSectionParams(List<String> params) {
        ArrayList<String> newParams = new ArrayList<String>();
        for (String param : params) {
            if (!this.isSectionEnabled(this.getSection(param))) continue;
            newParams.add(param);
        }
        return newParams.toArray(new String[newParams.size()]);
    }

    protected final boolean isSectionEnabled(String section) {
        return !this.disabledSections.contains(section);
    }

    private static class PanelPart {
        private final String section;
        private final ConfigData.AccessType accessType;
        private final boolean advanced;

        public PanelPart(String section, ConfigData.AccessType accessType, boolean advanced) {
            this.section = section;
            this.accessType = accessType;
            this.advanced = advanced;
        }

        public final String getSection() {
            return this.section;
        }

        public final ConfigData.AccessType getAccessType() {
            return this.accessType;
        }

        public final boolean isAdvanced() {
            return this.advanced;
        }
    }
}

