/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import lcmc.Exceptions;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.Service;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.HbConstraintInterface;
import lcmc.gui.resources.PcmkRscSetsInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.CRM;
import lcmc.utilities.Tools;

final class HbOrderInfo
extends EditableInfo
implements HbConstraintInterface {
    private ServiceInfo serviceInfoParent;
    private ServiceInfo serviceInfoChild;
    private final HbConnectionInfo connectionInfo;
    public static final String NOT_AVAIL_FOR_PCMK_VERSION = Tools.getString("HbOrderInfo.NotAvailableForThisVersion");

    HbOrderInfo(HbConnectionInfo connectionInfo, ServiceInfo serviceInfoParent, ServiceInfo serviceInfoChild, Browser browser) {
        super("Order", browser);
        this.setResource(new Service("Order"));
        this.connectionInfo = connectionInfo;
        this.serviceInfoParent = serviceInfoParent;
        this.serviceInfoChild = serviceInfoChild;
    }

    void setServiceInfoParent(ServiceInfo serviceInfoParent) {
        this.serviceInfoParent = serviceInfoParent;
    }

    void setServiceInfoChild(ServiceInfo serviceInfoChild) {
        this.serviceInfoChild = serviceInfoChild;
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    void setParameters() {
        String score;
        CRMXML.OrderData orderData;
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        String ordId = this.getService().getHeartbeatId();
        HashMap<String, String> resourceNode = new HashMap<String, String>();
        if (this.serviceInfoParent == null || this.serviceInfoChild == null) {
            orderData = clStatus.getOrderData(ordId);
            score = orderData.getScore();
            resourceNode.put("score", score);
        } else if (this.serviceInfoParent.isConstraintPH() || this.serviceInfoChild.isConstraintPH()) {
            CRMXML.RscSet rscSet;
            ConstraintPHInfo cphi;
            if (this.serviceInfoParent.isConstraintPH()) {
                cphi = (ConstraintPHInfo)this.serviceInfoParent;
                rscSet = cphi.getRscSetConnectionDataOrd().getRscSet2();
            } else {
                cphi = (ConstraintPHInfo)this.serviceInfoChild;
                rscSet = cphi.getRscSetConnectionDataOrd().getRscSet1();
            }
            resourceNode.put("sequential", rscSet.getSequential());
            resourceNode.put("require-all", rscSet.getRequireAll());
            resourceNode.put("action", rscSet.getOrderAction());
        } else {
            orderData = clStatus.getOrderData(ordId);
            if (orderData != null) {
                score = orderData.getScore();
                String symmetrical = orderData.getSymmetrical();
                String firstAction = orderData.getFirstAction();
                String thenAction = orderData.getThenAction();
                resourceNode.put("score", score);
                resourceNode.put("symmetrical", symmetrical);
                resourceNode.put("first-action", firstAction);
                resourceNode.put("then-action", thenAction);
            }
        }
        String[] params = this.getParametersFromXML();
        if (params != null) {
            for (String param : params) {
                String value = (String)resourceNode.get(param);
                if (value == null) {
                    value = this.getParamDefault(param);
                }
                if ("".equals(value)) {
                    value = null;
                }
                String oldValue = this.getParamSaved(param);
                if ((value != null || value == oldValue) && (value == null || value.equals(oldValue))) continue;
                this.getResource().setValue(param, value);
                Widget wi = this.getWidget(param, null);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
    }

    @Override
    public boolean isOrder() {
        return true;
    }

    @Override
    protected String getParamLongDesc(String param) {
        String text = this.getBrowser().getCRMXML().getOrderParamLongDesc(param);
        if (this.serviceInfoParent != null && this.serviceInfoChild != null) {
            return text.replaceAll("@FIRST-RSC@", Matcher.quoteReplacement(this.serviceInfoParent.toString())).replaceAll("@THEN-RSC@", Matcher.quoteReplacement(this.serviceInfoChild.toString()));
        }
        return text;
    }

    @Override
    protected String getParamShortDesc(String param) {
        return this.getBrowser().getCRMXML().getOrderParamShortDesc(param);
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return this.getBrowser().getCRMXML().checkOrderParam(param, newValue);
    }

    @Override
    protected String getParamDefault(String param) {
        return this.getBrowser().getCRMXML().getOrderParamDefault(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        return this.getBrowser().getCRMXML().getOrderParamPreferred(param);
    }

    @Override
    public String[] getParametersFromXML() {
        if (this.serviceInfoParent == null || this.serviceInfoChild == null) {
            return this.getBrowser().getCRMXML().getRscSetOrderParameters();
        }
        if (this.serviceInfoParent.isConstraintPH() || this.serviceInfoChild.isConstraintPH()) {
            return this.getBrowser().getCRMXML().getRscSetOrdConnectionParameters();
        }
        return this.getBrowser().getCRMXML().getOrderParameters();
    }

    private boolean isRscSetMaster() {
        CRMXML.RscSet rscSet;
        if (this.serviceInfoParent.isConstraintPH()) {
            ConstraintPHInfo cphi = (ConstraintPHInfo)this.serviceInfoParent;
            rscSet = cphi.getRscSetConnectionDataOrd().getRscSet2();
        } else {
            ConstraintPHInfo cphi = (ConstraintPHInfo)this.serviceInfoChild;
            rscSet = cphi.getRscSetConnectionDataOrd().getRscSet1();
        }
        return this.getBrowser().isOneMaster(rscSet.getRscIds());
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("action".equals(param)) {
            return this.getBrowser().getCRMXML().getOrderParamPossibleChoices(param, this.isRscSetMaster());
        }
        if ("first-action".equals(param)) {
            return this.getBrowser().getCRMXML().getOrderParamPossibleChoices(param, this.serviceInfoParent.getService().isMaster());
        }
        if ("then-action".equals(param)) {
            return this.getBrowser().getCRMXML().getOrderParamPossibleChoices(param, this.serviceInfoChild.getService().isMaster());
        }
        return this.getBrowser().getCRMXML().getOrderParamPossibleChoices(param, false);
    }

    @Override
    protected String getParamType(String param) {
        return this.getBrowser().getCRMXML().getOrderParamType(param);
    }

    @Override
    protected String getSection(String param) {
        return this.getBrowser().getCRMXML().getOrderSection(param);
    }

    @Override
    protected boolean isCheckBox(String param) {
        return this.getBrowser().getCRMXML().isOrderBoolean(param);
    }

    @Override
    protected boolean isTimeType(String param) {
        return this.getBrowser().getCRMXML().isOrderTimeType(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return this.getBrowser().getCRMXML().isOrderInteger(param);
    }

    @Override
    protected boolean isLabel(String param) {
        return this.getBrowser().getCRMXML().isOrderLabel(param);
    }

    @Override
    protected boolean isRequired(String param) {
        return this.getBrowser().getCRMXML().isOrderRequired(param);
    }

    protected Map<String, String> getAttributes() {
        String[] params = this.getParametersFromXML();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (Tools.areEqual(value, this.getParamDefault(param))) continue;
            attrs.put(param, value);
        }
        return attrs;
    }

    @Override
    public void apply(Host dcHost, boolean testOnly) {
        String[] params = this.getParametersFromXML();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        boolean changed = false;
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (!value.equals(this.getParamSaved(param))) {
                changed = true;
            }
            if (value.equals(this.getParamDefault(param))) continue;
            attrs.put(param, value);
        }
        if (changed) {
            String ordId = this.getService().getHeartbeatId();
            if (this.serviceInfoParent == null || this.serviceInfoChild == null) {
                ClusterStatus clStatus = this.getBrowser().getClusterStatus();
                PcmkRscSetsInfo prsi = (PcmkRscSetsInfo)this.connectionInfo;
                CRM.setRscSet(dcHost, null, false, ordId, false, null, prsi.getAllAttributes(dcHost, null, null, false, testOnly), attrs, testOnly);
            } else if (this.serviceInfoParent.isConstraintPH() || this.serviceInfoChild.isConstraintPH()) {
                CRMXML.RscSet rscSet;
                ConstraintPHInfo cphi;
                if (this.serviceInfoParent.isConstraintPH()) {
                    cphi = (ConstraintPHInfo)this.serviceInfoParent;
                    rscSet = cphi.getRscSetConnectionDataOrd().getRscSet2();
                } else {
                    cphi = (ConstraintPHInfo)this.serviceInfoChild;
                    rscSet = cphi.getRscSetConnectionDataOrd().getRscSet1();
                }
                PcmkRscSetsInfo prsi = cphi.getPcmkRscSetsInfo();
                CRM.setRscSet(dcHost, null, false, ordId, false, null, prsi.getAllAttributes(dcHost, rscSet, attrs, false, testOnly), prsi.getOrderAttributes(ordId), testOnly);
            } else {
                CRM.addOrder(dcHost, ordId, this.serviceInfoParent.getHeartbeatId(testOnly), this.serviceInfoChild.getHeartbeatId(testOnly), attrs, testOnly);
            }
            if (!testOnly) {
                this.storeComboBoxValues(params);
            }
        }
    }

    @Override
    public Service getService() {
        return (Service)this.getResource();
    }

    @Override
    public String getRsc1Name() {
        return "first";
    }

    @Override
    public String getRsc2Name() {
        return "then";
    }

    @Override
    public String getRsc1() {
        return this.serviceInfoParent.toString();
    }

    @Override
    public String getRsc2() {
        return this.serviceInfoChild.toString();
    }

    @Override
    public ServiceInfo getRscInfo1() {
        return this.serviceInfoParent;
    }

    @Override
    public ServiceInfo getRscInfo2() {
        return this.serviceInfoChild;
    }

    @Override
    protected boolean isAdvanced(String param) {
        return !"score".equals(param);
    }

    @Override
    protected String isEnabled(String param) {
        if ("require-all".equals(param)) {
            String pmV = this.getBrowser().getDCHost().getPacemakerVersion();
            try {
                if (pmV == null || Tools.compareVersions(pmV, "1.1.7") <= 0) {
                    return NOT_AVAIL_FOR_PCMK_VERSION;
                }
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning("unkonwn version: " + pmV);
            }
        }
        return null;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    int getScore() {
        String ordId;
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        CRMXML.OrderData data = clStatus.getOrderData(ordId = this.getService().getHeartbeatId());
        if (data == null) {
            return 0;
        }
        String score = data.getScore();
        if (score == null) {
            return 0;
        }
        if ("INFINITY".equals(score) || "+INFINITY".equals(score)) {
            return 1000000;
        }
        if ("-INFINITY".equals(score)) {
            return -1000000;
        }
        return Integer.parseInt(score);
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromUp) {
        if (fromUp) {
            return super.checkResourceFieldsCorrect(param, params);
        }
        return this.connectionInfo.checkResourceFieldsCorrect(param, null);
    }

    @Override
    boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params, boolean fromUp) {
        if (fromUp) {
            return super.checkResourceFieldsChanged(param, params);
        }
        return this.connectionInfo.checkResourceFieldsChanged(param, null);
    }
}

