/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.FunctorException;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

public final class TransformerPredicate<T>
implements Predicate<T>,
Serializable {
    static final long serialVersionUID = -2407966402920578741L;
    private final Transformer<T, Boolean> iTransformer;

    public static <T> Predicate<T> getInstance(Transformer<T, Boolean> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("The transformer to call must not be null");
        }
        return new TransformerPredicate<T>(transformer);
    }

    public TransformerPredicate(Transformer<T, Boolean> transformer) {
        this.iTransformer = transformer;
    }

    @Override
    public boolean evaluate(T object) {
        Boolean result = this.iTransformer.transform(object);
        if (result == null) {
            throw new FunctorException("Transformer must return an instanceof Boolean, it was a " + (result == null ? "null object" : result.getClass().getName()));
        }
        return result;
    }

    public Transformer<T, Boolean> getTransformer() {
        return this.iTransformer;
    }
}

