/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap<K, V>
extends HashMap<K, V> {
    protected HashMap<K, V> map = null;
    protected boolean fast = false;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public FastHashMap(int capacity, float factor) {
        this.map = new HashMap(capacity, factor);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                V result = temp.put(key, value);
                this.map = temp;
                return result;
            }
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> in) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                temp.putAll(in);
                this.map = temp;
            }
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                Object result = temp.remove(key);
                this.map = temp;
                return result;
            }
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                this.map = new HashMap();
            }
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    return false;
                }
                if (value.equals(mo.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.fast) {
            int h = 0;
            Iterator<Map.Entry<K, V>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        HashMap<K, V> hashMap = this.map;
        synchronized (hashMap) {
            int h = 0;
            Iterator<Map.Entry<K, V>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastHashMap<K, V> clone() {
        FastHashMap<K, V> results = null;
        if (this.fast) {
            results = new FastHashMap<K, V>((Map)this.map);
        } else {
            HashMap<K, V> hashMap = this.map;
            synchronized (hashMap) {
                results = new FastHashMap<K, V>((Map)this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    private class EntrySet
    extends CollectionView<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        protected Collection get(Map<K, V> map) {
            return map.entrySet();
        }

        @Override
        protected Map.Entry<K, V> iteratorNext(Map.Entry<K, V> entry) {
            return entry;
        }
    }

    private class Values
    extends CollectionView<V> {
        private Values() {
        }

        @Override
        protected Collection get(Map<K, V> map) {
            return map.values();
        }

        @Override
        protected V iteratorNext(Map.Entry<K, V> entry) {
            return entry.getValue();
        }
    }

    private class KeySet
    extends CollectionView<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        protected Collection get(Map<K, V> map) {
            return map.keySet();
        }

        @Override
        protected K iteratorNext(Map.Entry<K, V> entry) {
            return entry.getKey();
        }
    }

    private abstract class CollectionView<E>
    implements Collection<E> {
        protected abstract Collection<E> get(Map<K, V> var1);

        protected abstract E iteratorNext(Map.Entry<K, V> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    FastHashMap.this.map = new HashMap();
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                this.get(FastHashMap.this.map).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).remove(o);
                    FastHashMap.this.map = temp;
                    return r;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).removeAll(o);
                    FastHashMap.this.map = temp;
                    return r;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).removeAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).retainAll(o);
                    FastHashMap.this.map = temp;
                    return r;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).retainAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).size();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).isEmpty();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).contains(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).containsAll(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).containsAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).toArray(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).equals(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).hashCode();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                return this.get(FastHashMap.this.map).hashCode();
            }
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return new CollectionViewIterator();
        }

        private class CollectionViewIterator
        implements Iterator<E> {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = FastHashMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.expected != FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                if (this.expected != FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (FastHashMap.this.fast) {
                    FastHashMap fastHashMap = FastHashMap.this;
                    synchronized (fastHashMap) {
                        if (this.expected != FastHashMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastHashMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = FastHashMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

