/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolveDependencies
implements EnforcerRule {
    private transient DependencyTreeBuilder treeBuilder;
    private transient ArtifactResolver resolver;
    private transient ArtifactRepository localRepository;
    private transient List<ArtifactRepository> remoteRepositories;
    private transient EnforcerRuleHelper helper;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project;
        this.helper = helper;
        try {
            this.resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            this.treeBuilder = (DependencyTreeBuilder)helper.getComponent(DependencyTreeBuilder.class);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup DependencyTreeBuilder: ", (Exception)((Object)e));
        }
        try {
            project = (MavenProject)helper.evaluate("${project}");
            this.localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            this.remoteRepositories = (List)helper.evaluate("${project.remoteArtifactRepositories}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        Set<Artifact> artifacts = this.getDependenciesToCheck(project, this.localRepository);
        this.handleArtifacts(artifacts);
    }

    protected abstract void handleArtifacts(Set<Artifact> var1) throws EnforcerRuleException;

    protected boolean isSearchTransitive() {
        return true;
    }

    private Set<Artifact> getDependenciesToCheck(MavenProject project, ArtifactRepository localRepository) {
        Set<Artifact> dependencies = null;
        try {
            DependencyNode node = this.treeBuilder.buildDependencyTree(project, localRepository, null);
            if (this.isSearchTransitive()) {
                dependencies = this.getAllDescendants(node);
            } else if (node.getChildren() != null) {
                dependencies = new HashSet<Artifact>();
                for (DependencyNode depNode : node.getChildren()) {
                    dependencies.add(depNode.getArtifact());
                }
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                try {
                    Artifact artifact = depNode.getArtifact();
                    this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                    children.add(artifact);
                    Set<Artifact> subNodes = this.getAllDescendants(depNode);
                    if (subNodes == null) continue;
                    children.addAll(subNodes);
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().warn((CharSequence)e.getMessage());
                }
                catch (ArtifactNotFoundException e) {
                    this.getLog().warn((CharSequence)e.getMessage());
                }
            }
        }
        return children;
    }

    protected Log getLog() {
        return this.helper.getLog();
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }

    protected static String asRegex(String wildcard) {
        StringBuilder result = new StringBuilder(wildcard.length());
        result.append('^');
        block5: for (int index = 0; index < wildcard.length(); ++index) {
            char character = wildcard.charAt(index);
            switch (character) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                }
                default: {
                    result.append(character);
                }
            }
        }
        result.append("(\\.class)?");
        result.append('$');
        return result.toString();
    }

    protected class IgnorableDependency {
        public Pattern groupId;
        public Pattern artifactId;
        public Pattern classifier;
        public Pattern type;
        public List<Pattern> ignores = new ArrayList<Pattern>();

        protected IgnorableDependency() {
        }

        public IgnorableDependency applyIgnoreClasses(String[] ignores, boolean indent) {
            String prefix = indent ? "  " : "";
            for (String ignore : ignores) {
                AbstractResolveDependencies.this.getLog().info((CharSequence)(prefix + "Adding ignore: " + ignore));
                ignore = ignore.replace('.', '/');
                String pattern = AbstractResolveDependencies.asRegex(ignore);
                AbstractResolveDependencies.this.getLog().debug((CharSequence)(prefix + "Ignore: " + ignore + " maps to regex " + pattern));
                this.ignores.add(Pattern.compile(pattern));
            }
            return this;
        }

        public boolean matchesArtifact(Artifact dup) {
            return !(this.artifactId != null && !this.artifactId.matcher(dup.getArtifactId()).matches() || this.groupId != null && !this.groupId.matcher(dup.getGroupId()).matches() || this.classifier != null && !this.classifier.matcher(dup.getClassifier()).matches() || this.type != null && !this.type.matcher(dup.getType()).matches());
        }

        public boolean matches(String className) {
            for (Pattern p : this.ignores) {
                if (!p.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

