/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class HeaderCheck
extends AbstractHeaderCheck {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] mIgnoreLines = EMPTY_INT_ARRAY;

    private boolean isIgnoreLine(int aLineNo) {
        return Arrays.binarySearch(this.mIgnoreLines, aLineNo) >= 0;
    }

    protected boolean isMatch(int aLineNumber, String aLine) {
        return this.isIgnoreLine(aLineNumber + 1) || ((String)this.getHeaderLines().get(aLineNumber)).equals(aLine);
    }

    public void setIgnoreLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mIgnoreLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mIgnoreLines, 0, aList.length);
        Arrays.sort(this.mIgnoreLines);
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        if (this.getHeaderLines().size() > aLines.size()) {
            this.log(1, "header.missing", new Object[0]);
        } else {
            for (int i = 0; i < this.getHeaderLines().size(); ++i) {
                if (this.isMatch(i, aLines.get(i))) continue;
                this.log(i + 1, "header.mismatch", this.getHeaderLines().get(i));
                break;
            }
        }
    }
}

