/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.CompareEqual;
import org.mockito.internal.matchers.EqualsWithDelta;
import org.mockito.internal.matchers.Find;
import org.mockito.internal.matchers.GreaterOrEqual;
import org.mockito.internal.matchers.GreaterThan;
import org.mockito.internal.matchers.LessOrEqual;
import org.mockito.internal.matchers.LessThan;
import org.mockito.internal.progress.HandyReturnValues;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;

public class AdditionalMatchers {
    private static final MockingProgress MOCKING_PROGRESS = new ThreadSafeMockingProgress();

    public static <T extends Comparable<T>> T geq(Comparable<T> comparable) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new GreaterOrEqual<T>(comparable)).returnNull());
    }

    public static byte geq(byte by) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Byte>(Byte.valueOf(by))).returnZero();
    }

    public static double geq(double d) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Double>(Double.valueOf(d))).returnZero();
    }

    public static float geq(float f) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Float>(Float.valueOf(f))).returnZero();
    }

    public static int geq(int n) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Integer>(Integer.valueOf(n))).returnZero();
    }

    public static long geq(long l) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Long>(Long.valueOf(l))).returnZero();
    }

    public static short geq(short s) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Short>(Short.valueOf(s))).returnZero();
    }

    public static <T extends Comparable<T>> T leq(Comparable<T> comparable) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new LessOrEqual<T>(comparable)).returnNull());
    }

    public static byte leq(byte by) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Byte>(Byte.valueOf(by))).returnZero();
    }

    public static double leq(double d) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Double>(Double.valueOf(d))).returnZero();
    }

    public static float leq(float f) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Float>(Float.valueOf(f))).returnZero();
    }

    public static int leq(int n) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Integer>(Integer.valueOf(n))).returnZero();
    }

    public static long leq(long l) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Long>(Long.valueOf(l))).returnZero();
    }

    public static short leq(short s) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Short>(Short.valueOf(s))).returnZero();
    }

    public static <T extends Comparable<T>> T gt(Comparable<T> comparable) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new GreaterThan<T>(comparable)).returnNull());
    }

    public static byte gt(byte by) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Byte>(Byte.valueOf(by))).returnZero();
    }

    public static double gt(double d) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Double>(Double.valueOf(d))).returnZero();
    }

    public static float gt(float f) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Float>(Float.valueOf(f))).returnZero();
    }

    public static int gt(int n) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Integer>(Integer.valueOf(n))).returnZero();
    }

    public static long gt(long l) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Long>(Long.valueOf(l))).returnZero();
    }

    public static short gt(short s) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Short>(Short.valueOf(s))).returnZero();
    }

    public static <T extends Comparable<T>> T lt(Comparable<T> comparable) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new LessThan<T>(comparable)).returnNull());
    }

    public static byte lt(byte by) {
        return AdditionalMatchers.reportMatcher(new LessThan<Byte>(Byte.valueOf(by))).returnZero();
    }

    public static double lt(double d) {
        return AdditionalMatchers.reportMatcher(new LessThan<Double>(Double.valueOf(d))).returnZero();
    }

    public static float lt(float f) {
        return AdditionalMatchers.reportMatcher(new LessThan<Float>(Float.valueOf(f))).returnZero();
    }

    public static int lt(int n) {
        return AdditionalMatchers.reportMatcher(new LessThan<Integer>(Integer.valueOf(n))).returnZero();
    }

    public static long lt(long l) {
        return AdditionalMatchers.reportMatcher(new LessThan<Long>(Long.valueOf(l))).returnZero();
    }

    public static short lt(short s) {
        return AdditionalMatchers.reportMatcher(new LessThan<Short>(Short.valueOf(s))).returnZero();
    }

    public static <T extends Comparable<T>> T cmpEq(Comparable<T> comparable) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new CompareEqual<T>(comparable)).returnNull());
    }

    public static String find(String string) {
        return (String)AdditionalMatchers.reportMatcher(new Find(string)).returnNull();
    }

    public static <T> T[] aryEq(T[] TArray) {
        return (Object[])AdditionalMatchers.reportMatcher(new ArrayEquals(TArray)).returnNull();
    }

    public static short[] aryEq(short[] sArray) {
        return (short[])AdditionalMatchers.reportMatcher(new ArrayEquals(sArray)).returnNull();
    }

    public static long[] aryEq(long[] lArray) {
        return (long[])AdditionalMatchers.reportMatcher(new ArrayEquals(lArray)).returnNull();
    }

    public static int[] aryEq(int[] nArray) {
        return (int[])AdditionalMatchers.reportMatcher(new ArrayEquals(nArray)).returnNull();
    }

    public static float[] aryEq(float[] fArray) {
        return (float[])AdditionalMatchers.reportMatcher(new ArrayEquals(fArray)).returnNull();
    }

    public static double[] aryEq(double[] dArray) {
        return (double[])AdditionalMatchers.reportMatcher(new ArrayEquals(dArray)).returnNull();
    }

    public static char[] aryEq(char[] cArray) {
        return (char[])AdditionalMatchers.reportMatcher(new ArrayEquals(cArray)).returnNull();
    }

    public static byte[] aryEq(byte[] byArray) {
        return (byte[])AdditionalMatchers.reportMatcher(new ArrayEquals(byArray)).returnNull();
    }

    public static boolean[] aryEq(boolean[] blArray) {
        return (boolean[])AdditionalMatchers.reportMatcher(new ArrayEquals(blArray)).returnNull();
    }

    public static boolean and(boolean bl, boolean bl2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnFalse();
    }

    public static byte and(byte by, byte by2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static char and(char c, char c2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnChar();
    }

    public static double and(double d, double d2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static float and(float f, float f2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static int and(int n, int n2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static long and(long l, long l2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static short and(short s, short s2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static <T> T and(T t, T t2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportAnd().returnNull();
    }

    public static boolean or(boolean bl, boolean bl2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnFalse();
    }

    public static <T> T or(T t, T t2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnNull();
    }

    public static short or(short s, short s2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static long or(long l, long l2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static int or(int n, int n2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static float or(float f, float f2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static double or(double d, double d2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static char or(char c, char c2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnChar();
    }

    public static byte or(byte by, byte by2) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static <T> T not(T t) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnNull();
    }

    public static short not(short s) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static int not(int n) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static long not(long l) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static float not(float f) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static double not(double d) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static char not(char c) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnChar();
    }

    public static boolean not(boolean bl) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnFalse();
    }

    public static byte not(byte by) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static double eq(double d, double d2) {
        return AdditionalMatchers.reportMatcher(new EqualsWithDelta(d, d2)).returnZero();
    }

    public static float eq(float f, float f2) {
        return AdditionalMatchers.reportMatcher(new EqualsWithDelta(Float.valueOf(f), Float.valueOf(f2))).returnZero();
    }

    private static HandyReturnValues reportMatcher(ArgumentMatcher<?> argumentMatcher) {
        return MOCKING_PROGRESS.getArgumentMatcherStorage().reportMatcher((Matcher)argumentMatcher);
    }
}

