/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.lang.reflect.Method;
import org.mockito.internal.invocation.AbstractAwareMethod;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.Invocation;

public class MethodInfo
implements AbstractAwareMethod {
    private final Method method;

    public MethodInfo(Invocation invocation) {
        this.method = invocation.getMethod();
    }

    public boolean isValidException(Throwable throwable) {
        Class<?>[] classArray = this.method.getExceptionTypes();
        Class<?> clazz = throwable.getClass();
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidReturnType(Class clazz) {
        if (this.method.getReturnType().isPrimitive() || clazz.isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == Primitives.primitiveTypeOf(this.method.getReturnType());
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        return this.method.getReturnType() == Void.TYPE;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isDeclaredOnInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return (this.method.getModifiers() & 0x400) != 0;
    }
}

