/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2023 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 30 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 501 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 35 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 38 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 41 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 44 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 47 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
#line 34 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
// This is needed by __hash__().
#include <qhash.h>


// Convenience function for converting a QByteArray to a Python str object.
static PyObject *QByteArrayToPyStr(QByteArray *ba)
{
    char *data = ba->data();

    if (data)
        // QByteArrays may have embedded '\0's so set the size explicitly.    
        return SIPBytes_FromStringAndSize(data, ba->size());

    return SIPBytes_FromString("");
}
#line 64 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"


PyDoc_STRVAR(doc_QByteArray_resize, "resize(self, size: int)");

extern "C" {static PyObject *meth_QByteArray_resize(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_resize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->resize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_resize, doc_QByteArray_resize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fill, "fill(self, ch: str, size: int = -1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char a0;
        int a1 = -1;
        ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BaA|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->fill(a0, a1);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fill, doc_QByteArray_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_clear, "clear(self)");

extern "C" {static PyObject *meth_QByteArray_clear(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_clear, doc_QByteArray_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_indexOf, "indexOf(self, ba: Union[QByteArray, bytes, bytearray], from_: int = 0) -> int\n"
"indexOf(self, str: Optional[str], from_: int = 0) -> int");

extern "C" {static PyObject *meth_QByteArray_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        int a1 = 0;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->indexOf(*a0, a1);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        int a1 = 0;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->indexOf(*a0, a1);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_indexOf, doc_QByteArray_indexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_lastIndexOf, "lastIndexOf(self, ba: Union[QByteArray, bytes, bytearray], from_: int = -1) -> int\n"
"lastIndexOf(self, str: Optional[str], from_: int = -1) -> int");

extern "C" {static PyObject *meth_QByteArray_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        int a1 = -1;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->lastIndexOf(*a0, a1);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        int a1 = -1;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->lastIndexOf(*a0, a1);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_lastIndexOf, doc_QByteArray_lastIndexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_count, "count(self, a: Union[QByteArray, bytes, bytearray]) -> int\n"
"count(self) -> int");

extern "C" {static PyObject *meth_QByteArray_count(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->count(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_count, doc_QByteArray_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_left, "left(self, len: int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_left(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->left(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_left, doc_QByteArray_left);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_right, "right(self, len: int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_right(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->right(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_right, doc_QByteArray_right);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_mid, "mid(self, pos: int, length: int = -1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1 = -1;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->mid(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_mid, doc_QByteArray_mid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_startsWith, "startsWith(self, a: Union[QByteArray, bytes, bytearray]) -> bool");

extern "C" {static PyObject *meth_QByteArray_startsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_startsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->startsWith(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_startsWith, doc_QByteArray_startsWith);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_endsWith, "endsWith(self, a: Union[QByteArray, bytes, bytearray]) -> bool");

extern "C" {static PyObject *meth_QByteArray_endsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_endsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->endsWith(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_endsWith, doc_QByteArray_endsWith);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_truncate, "truncate(self, pos: int)");

extern "C" {static PyObject *meth_QByteArray_truncate(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_truncate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->truncate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_truncate, doc_QByteArray_truncate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_chop, "chop(self, n: int)");

extern "C" {static PyObject *meth_QByteArray_chop(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_chop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->chop(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_chop, doc_QByteArray_chop);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLower, "toLower(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toLower(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLower(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toLower());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLower, doc_QByteArray_toLower);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUpper, "toUpper(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toUpper(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUpper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toUpper());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUpper, doc_QByteArray_toUpper);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_trimmed, "trimmed(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_trimmed(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_trimmed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->trimmed());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_trimmed, doc_QByteArray_trimmed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_simplified, "simplified(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_simplified(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_simplified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->simplified());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_simplified, doc_QByteArray_simplified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_leftJustified, "leftJustified(self, width: int, fill: str = ' ', truncate: bool = False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_leftJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_leftJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        char a1 = ' ';
        bool a2 = 0;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|aAb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->leftJustified(a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_leftJustified, doc_QByteArray_leftJustified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_rightJustified, "rightJustified(self, width: int, fill: str = ' ', truncate: bool = False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_rightJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_rightJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        char a1 = ' ';
        bool a2 = 0;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|aAb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->rightJustified(a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_rightJustified, doc_QByteArray_rightJustified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_prepend, "prepend(self, a: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"prepend(self, count: int, c: bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_prepend(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->prepend(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        int a0;
        char a1;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bic", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->prepend(a0, a1);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_prepend, doc_QByteArray_prepend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_append, "append(self, a: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"append(self, s: Optional[str]) -> QByteArray\n"
"append(self, count: int, c: bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_append(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->append(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->append(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        int a0;
        char a1;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bic", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->append(a0, a1);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_append, doc_QByteArray_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_insert, "insert(self, i: int, a: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"insert(self, i: int, s: Optional[str]) -> QByteArray\n"
"insert(self, i: int, count: int, c: bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_insert(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, sipType_QByteArray, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->insert(a0, *a1);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        int a0;
        const ::QString* a1;
        int a1State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, sipType_QString, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->insert(a0, *a1);
            sipReleaseType(const_cast<::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        int a0;
        int a1;
        char a2;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biic", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->insert(a0, a1, a2);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_insert, doc_QByteArray_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_remove, "remove(self, index: int, len: int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_remove(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->remove(a0, a1);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_remove, doc_QByteArray_remove);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_replace, "replace(self, index: int, len: int, s: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"replace(self, before: Union[QByteArray, bytes, bytearray], after: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"replace(self, before: Optional[str], after: Union[QByteArray, bytes, bytearray]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_replace(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        const ::QByteArray* a2;
        int a2State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiiJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, sipType_QByteArray, &a2, &a2State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->replace(a0, a1, *a2);
            sipReleaseType(const_cast<::QByteArray *>(a2), sipType_QByteArray, a2State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->replace(*a0, *a1);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QString, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->replace(*a0, *a1);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_replace, doc_QByteArray_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_split, "split(self, sep: str) -> List[QByteArray]");

extern "C" {static PyObject *meth_QByteArray_split(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_split(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BaA", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QList<::QByteArray>*sipRes;

            sipRes = new QList<::QByteArray>(sipCpp->split(a0));

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_split, doc_QByteArray_split);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toShort, "toShort(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            short sipRes;

            sipRes = sipCpp->toShort(&a0, a1);

            return sipBuildResult(0, "(hb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toShort, doc_QByteArray_toShort);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUShort, "toUShort(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toUShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ::ushort sipRes;

            sipRes = sipCpp->toUShort(&a0, a1);

            return sipBuildResult(0, "(tb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUShort, doc_QByteArray_toUShort);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toInt, "toInt(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            int sipRes;

            sipRes = sipCpp->toInt(&a0, a1);

            return sipBuildResult(0, "(ib)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toInt, doc_QByteArray_toInt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUInt, "toUInt(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toUInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ::uint sipRes;

            sipRes = sipCpp->toUInt(&a0, a1);

            return sipBuildResult(0, "(ub)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUInt, doc_QByteArray_toUInt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLong, "toLong(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            long sipRes;

            sipRes = sipCpp->toLong(&a0, a1);

            return sipBuildResult(0, "(lb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLong, doc_QByteArray_toLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toULong, "toULong(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toULong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ::ulong sipRes;

            sipRes = sipCpp->toULong(&a0, a1);

            return sipBuildResult(0, "(mb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULong, doc_QByteArray_toULong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLongLong, "toLongLong(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toLongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ::qlonglong sipRes;

            sipRes = sipCpp->toLongLong(&a0, a1);

            return sipBuildResult(0, "(nb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLongLong, doc_QByteArray_toLongLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toULongLong, "toULongLong(self, base: int = 10) -> (int, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toULongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            ::qulonglong sipRes;

            sipRes = sipCpp->toULongLong(&a0, a1);

            return sipBuildResult(0, "(ob)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULongLong, doc_QByteArray_toULongLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toFloat, "toFloat(self) -> (float, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toFloat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toFloat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QByteArray *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->toFloat(&a0);

            return sipBuildResult(0, "(fb)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toFloat, doc_QByteArray_toFloat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toDouble, "toDouble(self) -> (float, Optional[bool])");

extern "C" {static PyObject *meth_QByteArray_toDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const ::QByteArray *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->toDouble(&a0);

            return sipBuildResult(0, "(db)", sipRes, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toDouble, doc_QByteArray_toDouble);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toBase64, "toBase64(self) -> QByteArray\n"
"toBase64(self, options: Union[QByteArray.Base64Options, QByteArray.Base64Option]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toBase64(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toBase64(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toBase64());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        ::QByteArray::Base64Options* a0;
        int a0State = 0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray_Base64Options, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toBase64(*a0));
            sipReleaseType(a0, sipType_QByteArray_Base64Options, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toBase64, doc_QByteArray_toBase64);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_setNum, "setNum(self, n: float, format: str = 'g', precision: int = 6) -> QByteArray\n"
"setNum(self, n: int, base: int = 10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_setNum(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_setNum(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;
        ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BXd|aAi", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = &sipCpp->setNum(a0, a1, a2);

            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;
        int a1 = 10;
        ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
            ::QByteArray*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 217 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        #if PY_MAJOR_VERSION < 3
        if (PyInt_Check(a0))
        {
            qlonglong val = PyInt_AsLong(a0);
        
            sipRes = &sipCpp->setNum(val, a1);
        }
        else
        #endif
        {
            qlonglong val = sipLong_AsLongLong(a0);
        
            if (!PyErr_Occurred())
            {
                sipRes = &sipCpp->setNum(val, a1);
            }
            else
            {
                // If it is positive then it might fit an unsigned long long.
        
                qulonglong uval = sipLong_AsUnsignedLongLong(a0);
        
                if (!PyErr_Occurred())
                {
                    sipRes = &sipCpp->setNum(uval, a1);
                }
                else
                {
                    sipError = (PyErr_ExceptionMatches(PyExc_OverflowError)
                            ? sipErrorFail : sipErrorContinue);
                }
            }
        }
#line 1411 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes, sipType_QByteArray, SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_setNum, doc_QByteArray_setNum);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_number, "number(n: float, format: str = 'g', precision: int = 6) -> QByteArray\n"
"number(n: int, base: int = 10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_number(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_number(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Xd|aAi", &a0, &a1, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::number(a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;
        int a1 = 10;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "P0|i", &a0, &a1))
        {
            ::QByteArray*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 255 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        #if PY_MAJOR_VERSION < 3
        if (PyInt_Check(a0))
        {
            qlonglong val = PyInt_AsLong(a0);
        
            sipRes = new QByteArray(QByteArray::number(val, a1));
        }
        else
        #endif
        {
            qlonglong val = sipLong_AsLongLong(a0);
        
            if (!PyErr_Occurred())
            {
                sipRes = new QByteArray(QByteArray::number(val, a1));
            }
            else
            {
                // If it is positive then it might fit an unsigned long long.
        
                qulonglong uval = sipLong_AsUnsignedLongLong(a0);
        
                if (!PyErr_Occurred())
                {
                    sipRes = new QByteArray(QByteArray::number(uval, a1));
                }
                else
                {
                    sipError = (PyErr_ExceptionMatches(PyExc_OverflowError)
                            ? sipErrorFail : sipErrorContinue);
                }
            }
        }
#line 1508 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_number, doc_QByteArray_number);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromBase64, "fromBase64(base64: Union[QByteArray, bytes, bytearray]) -> QByteArray\n"
"fromBase64(base64: Union[QByteArray, bytes, bytearray], options: Union[QByteArray.Base64Options, QByteArray.Base64Option]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromBase64(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromBase64(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::fromBase64(*a0));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray::Base64Options* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J1", sipType_QByteArray, &a0, &a0State, sipType_QByteArray_Base64Options, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::fromBase64(*a0, *a1));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(a1, sipType_QByteArray_Base64Options, a1State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromBase64, doc_QByteArray_fromBase64);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromRawData, "fromRawData(a0: Optional[PyQt5.sip.array[bytes]]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromRawData(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromRawData(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* a0;
        Py_ssize_t a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "k", &a0, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::fromRawData(a0, (int)a1));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromRawData, doc_QByteArray_fromRawData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromHex, "fromHex(hexEncoded: Union[QByteArray, bytes, bytearray]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromHex(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromHex(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::fromHex(*a0));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromHex, doc_QByteArray_fromHex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_length, "length(self) -> int");

extern "C" {static PyObject *meth_QByteArray_length(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->length();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_length, doc_QByteArray_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isNull(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isNull, doc_QByteArray_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_size, "size(self) -> int");

extern "C" {static PyObject *meth_QByteArray_size(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_size, doc_QByteArray_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_at, "at(self, i: int) -> bytes");

extern "C" {static PyObject *meth_QByteArray_at(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            char sipRes;

            sipRes = sipCpp->at(a0);

            return PyBytes_FromStringAndSize(&sipRes, 1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_at, doc_QByteArray_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isEmpty, doc_QByteArray_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_data, "data(self) -> bytes");

extern "C" {static PyObject *meth_QByteArray_data(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 404 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        // QByteArrays may contain embedded '\0's so set the size explicitly.
        
        char *res = sipCpp->data();
        int len = sipCpp->size();
        
        if (res)
        {
            if ((sipRes = SIPBytes_FromStringAndSize(res, len)) == NULL)
                sipIsErr = 1;
        }
        else
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
#line 1792 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_data, doc_QByteArray_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_capacity, "capacity(self) -> int");

extern "C" {static PyObject *meth_QByteArray_capacity(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_capacity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->capacity();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_capacity, doc_QByteArray_capacity);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_reserve, "reserve(self, size: int)");

extern "C" {static PyObject *meth_QByteArray_reserve(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_reserve(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->reserve(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_reserve, doc_QByteArray_reserve);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_squeeze, "squeeze(self)");

extern "C" {static PyObject *meth_QByteArray_squeeze(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_squeeze(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            sipCpp->squeeze();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_squeeze, doc_QByteArray_squeeze);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_push_back, "push_back(self, a: Union[QByteArray, bytes, bytearray])");

extern "C" {static PyObject *meth_QByteArray_push_back(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_back(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->push_back(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_back, doc_QByteArray_push_back);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_push_front, "push_front(self, a: Union[QByteArray, bytes, bytearray])");

extern "C" {static PyObject *meth_QByteArray_push_front(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_front(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->push_front(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_front, doc_QByteArray_push_front);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_contains, "contains(self, a: Union[QByteArray, bytes, bytearray]) -> bool");

extern "C" {static PyObject *meth_QByteArray_contains(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_contains, doc_QByteArray_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toHex, "toHex(self) -> QByteArray\n"
"toHex(self, separator: str) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toHex(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toHex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toHex());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        char a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BaA", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toHex(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toHex, doc_QByteArray_toHex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toPercentEncoding, "toPercentEncoding(self, exclude: Union[QByteArray, bytes, bytearray] = QByteArray(), include: Union[QByteArray, bytes, bytearray] = QByteArray(), percent: str = '%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toPercentEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray& a0def = QByteArray();
        const ::QByteArray* a0 = &a0def;
        int a0State = 0;
        const ::QByteArray& a1def = QByteArray();
        const ::QByteArray* a1 = &a1def;
        int a1State = 0;
        char a2 = '%';
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_exclude,
            sipName_include,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1J1aA", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->toPercentEncoding(*a0, *a1, a2));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toPercentEncoding, doc_QByteArray_toPercentEncoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromPercentEncoding, "fromPercentEncoding(input: Union[QByteArray, bytes, bytearray], percent: str = '%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        char a1 = '%';

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1|aA", sipType_QByteArray, &a0, &a0State, &a1))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QByteArray::fromPercentEncoding(*a0, a1));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromPercentEncoding, doc_QByteArray_fromPercentEncoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_repeated, "repeated(self, times: int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_repeated(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_repeated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->repeated(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_repeated, doc_QByteArray_repeated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_swap, "swap(self, other: QByteArray)");

extern "C" {static PyObject *meth_QByteArray_swap(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArray* a0;
        ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_swap, doc_QByteArray_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_chopped, "chopped(self, len: int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_chopped(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_chopped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->chopped(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_chopped, doc_QByteArray_chopped);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_compare, "compare(self, a: Union[QByteArray, bytes, bytearray], cs: Qt.CaseSensitivity = Qt.CaseSensitive) -> int");

extern "C" {static PyObject *meth_QByteArray_compare(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_compare(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        const ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_cs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_Qt_CaseSensitivity, &a1))
        {
            int sipRes;

            sipRes = sipCpp->compare(*a0, a1);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_compare, doc_QByteArray_compare);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isUpper, "isUpper(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isUpper(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isUpper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isUpper();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isUpper, doc_QByteArray_isUpper);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isLower, "isLower(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isLower(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isLower(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isLower();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isLower, doc_QByteArray_isLower);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromBase64Encoding, "fromBase64Encoding(base64: Union[QByteArray, bytes, bytearray], options: Union[QByteArray.Base64Options, QByteArray.Base64Option] = QByteArray.Base64Encoding) -> QByteArray.FromBase64Result");

extern "C" {static PyObject *meth_QByteArray_fromBase64Encoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromBase64Encoding(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        ::QByteArray::Base64Options a1def = QByteArray::Base64Encoding;
        ::QByteArray::Base64Options* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1|J1", sipType_QByteArray, &a0, &a0State, sipType_QByteArray_Base64Options, &a1, &a1State))
        {
            ::QByteArray::FromBase64Result*sipRes;

            sipRes = new ::QByteArray::FromBase64Result(::QByteArray::fromBase64Encoding(*a0, *a1));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(a1, sipType_QByteArray_Base64Options, a1State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray_FromBase64Result, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromBase64Encoding, doc_QByteArray_fromBase64Encoding);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QByteArray___add__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray((*a0 + *a1));
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast<::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QByteArray___imul__(PyObject *, int);}
static PyObject *slot_QByteArray___imul__(PyObject *sipSelf, int a0)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
#line 393 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        QByteArray orig(*sipCpp);
        
        sipCpp->clear();
        
        while (a0-- > 0)
            *sipCpp += orig;
#line 2339 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___mul__(PyObject *, int);}
static PyObject *slot_QByteArray___mul__(PyObject *sipSelf, int a0)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::QByteArray*sipRes = 0;

#line 385 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        sipRes = new QByteArray();
        
        while (a0-- > 0)
            *sipRes += *sipCpp;
#line 2368 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___repr__(PyObject *);}
static PyObject *slot_QByteArray___repr__(PyObject *sipSelf)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 356 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        if (sipCpp->isNull())
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromString("PyQt5.QtCore.QByteArray()");
        #else
            sipRes = PyString_FromString("PyQt5.QtCore.QByteArray()");
        #endif
        }
        else
        {
            PyObject *str = QByteArrayToPyStr(sipCpp);
        
            if (str)
            {
        #if PY_MAJOR_VERSION >= 3
                sipRes = PyUnicode_FromFormat("PyQt5.QtCore.QByteArray(%R)", str);
        #else
                sipRes = PyString_FromString("PyQt5.QtCore.QByteArray(");
                PyString_ConcatAndDel(&sipRes, PyObject_Repr(str));
                PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        
                Py_DECREF(str);
            }
        }
#line 2417 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___str__(PyObject *);}
static PyObject *slot_QByteArray___str__(PyObject *sipSelf)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 341 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        sipRes = QByteArrayToPyStr(sipCpp);
        
        #if PY_MAJOR_VERSION >= 3
        PyObject *repr = PyObject_Repr(sipRes);
        
        if (repr)
        {
            Py_DECREF(sipRes);
            sipRes = repr;
        }
        #endif
#line 2452 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static long slot_QByteArray___hash__(PyObject *);}
static long slot_QByteArray___hash__(PyObject *sipSelf)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return 0L;


    {
        {
            long sipRes = 0;

#line 336 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        sipRes = qHash(*sipCpp);
#line 2477 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static int slot_QByteArray___contains__(PyObject *, PyObject *);}
static int slot_QByteArray___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            int sipRes = 0;

#line 330 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        // It looks like you can't assign QBool to int.
        sipRes = bool(sipCpp->contains(*a0));
#line 2508 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QByteArray___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            char sipRes = 0;
            int sipIsErr = 0;

#line 300 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        Py_ssize_t idx = sipConvertFromSequenceIndex(a0, sipCpp->count());
        
        if (idx < 0)
            sipIsErr = 1;
        else
            sipRes = sipCpp->operator[]((int)idx);
#line 2546 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return PyBytes_FromStringAndSize(&sipRes, 1);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            ::QByteArray*sipRes = 0;
            int sipIsErr = 0;

#line 310 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
        Py_ssize_t start, stop, step, slicelength;
        
        if (sipConvertFromSliceObject(a0, sipCpp->length(), &start, &stop, &step, &slicelength) < 0)
        {
            sipIsErr = 1;
        }
        else
        {
            sipRes = new QByteArray();
        
            for (Py_ssize_t i = 0; i < slicelength; ++i)
            {
                sipRes -> append(sipCpp->at(start));
                start += step;
            }
        }
#line 2580 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QByteArray___len__(PyObject *);}
static Py_ssize_t slot_QByteArray___len__(PyObject *sipSelf)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 2610 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___ge__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___ge__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator>=(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>=((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ge_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___le__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___le__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator<=(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<=((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, le_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___gt__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___gt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator>(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, gt_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___lt__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___lt__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator<(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, lt_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___ne__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator!=(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___eq__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QByteArray::operator==(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QByteArray___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            sipCpp->::QByteArray::operator+=(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            sipCpp->::QByteArray::operator+=(*a0);
            sipReleaseType(const_cast<::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf, sipArg, iconcat_slot);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QByteArray(void *, int);}
static void release_QByteArray(void *sipCppV, int)
{
    delete reinterpret_cast<::QByteArray *>(sipCppV);
}


extern "C" {static int getbuffer_QByteArray(PyObject *, void *, sipBufferDef *);}
static int getbuffer_QByteArray(PyObject *sipSelf, void *sipCppV, sipBufferDef *sipBuffer)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipCppV);
    int sipRes;

#line 105 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
    #if defined(Py_LIMITED_API)
        Q_UNUSED(sipSelf);
    
        sipBuffer->bd_buffer = sipCpp->data();
        sipBuffer->bd_length = sipCpp->size();
        sipBuffer->bd_readonly = 0;
        sipRes = 0;
    #else
        sipRes = PyBuffer_FillInfo(sipBuffer, sipSelf, sipCpp->data(),
                sipCpp->size(), 0, sipFlags);
    #endif
#line 2967 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

    return sipRes;
}


extern "C" {static PyObject *pickle_QByteArray(void *);}
static PyObject *pickle_QByteArray(void *sipCppV)
{
    ::QByteArray *sipCpp = reinterpret_cast<::QByteArray *>(sipCppV);
    PyObject *sipRes;

#line 152 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
    #if PY_MAJOR_VERSION >= 3
    sipRes = Py_BuildValue((char *)"(y#)", sipCpp->data(), static_cast<Py_ssize_t>(sipCpp->size()));
    #else
    sipRes = Py_BuildValue((char *)"(s#)", sipCpp->data(), static_cast<Py_ssize_t>(sipCpp->size()));
    #endif
#line 2985 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"

    return sipRes;
}


extern "C" {static void *array_QByteArray(Py_ssize_t);}
static void *array_QByteArray(Py_ssize_t sipNrElem)
{
    return new ::QByteArray[sipNrElem];
}


extern "C" {static void array_delete_QByteArray(void *);}
static void array_delete_QByteArray(void *sipCpp)
{
    delete[] reinterpret_cast<::QByteArray *>(sipCpp);
}


extern "C" {static void assign_QByteArray(void *, Py_ssize_t, void *);}
static void assign_QByteArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::QByteArray *>(sipDst)[sipDstIdx] = *reinterpret_cast<::QByteArray *>(sipSrc);
}


extern "C" {static void *copy_QByteArray(const void *, Py_ssize_t);}
static void *copy_QByteArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QByteArray(reinterpret_cast<const ::QByteArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QByteArray(sipSimpleWrapper *);}
static void dealloc_QByteArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QByteArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QByteArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QByteArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QByteArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QByteArray();

            return sipCpp;
        }
    }

    {
        int a0;
        char a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "iaA", &a0, &a1))
        {
            sipCpp = new ::QByteArray(a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QByteArray, &a0, &a0State))
        {
            sipCpp = new ::QByteArray(*a0);
            sipReleaseType(const_cast<::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QByteArray(PyObject *, void **, int *, PyObject *);}
static int convertTo_QByteArray(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QByteArray **sipCppPtr = reinterpret_cast<::QByteArray **>(sipCppPtrV);

#line 52 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qbytearray.sip"
// We have to be very careful about what we allow to be converted to a
// QByteArray and to a QString as we need to take into account the v1 and v2
// APIs and Python v2.x and v3.x.
//
// QSvgRenderer() is a good example of what needs to work "naturally".  This
// has a ctor that takes a QString argument that is the name of the SVG file.
// It has another ctor that takes a QByteArray argument that is the SVG data.
//
// In Python v2.x we want a str object to be interpreted as the name of the
// file (as that is the historical behaviour).  This has the following
// implications.
//
// - The QString version of the ctor must appear before the QByteArray version
//   in the .sip file.  This rule should be applied wherever a similar
//   situation arises.
// - A QString must not automatically convert a QByteArray.
// - QByteArray must also exist in the v2 API.
//
// In Python v3.x we want a bytes object to be used wherever a QByteArray is
// expected.  This means that a QString must not automatically convert a bytes
// object.
//
// In PyQt v5.4 and earlier a QByteArray could be created from a Latin-1
// encoded string.  This was a mistaken attempt to ease the porting of Python2
// code to Python3.

if (sipIsErr == NULL)
    return (PyByteArray_Check(sipPy) || SIPBytes_Check(sipPy) ||
            sipCanConvertToType(sipPy, sipType_QByteArray, SIP_NO_CONVERTORS));

if (PyByteArray_Check(sipPy))
{
    *sipCppPtr = new QByteArray(PyByteArray_AsString(sipPy),
            PyByteArray_Size(sipPy));

    return sipGetState(sipTransferObj);
}

if (SIPBytes_Check(sipPy))
{
    *sipCppPtr = new QByteArray(SIPBytes_AsString(sipPy),
            SIPBytes_Size(sipPy));

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QByteArray *>(sipConvertToType(sipPy,
        sipType_QByteArray, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 3128 "/build/pyqt5/src/PyQt5-5.15.10/build/QtCore/sipQtCoreQByteArray.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QByteArray[] = {
    {(void *)slot_QByteArray___add__, add_slot},
    {(void *)slot_QByteArray___imul__, irepeat_slot},
    {(void *)slot_QByteArray___mul__, repeat_slot},
    {(void *)slot_QByteArray___repr__, repr_slot},
    {(void *)slot_QByteArray___str__, str_slot},
    {(void *)slot_QByteArray___hash__, hash_slot},
    {(void *)slot_QByteArray___contains__, contains_slot},
    {(void *)slot_QByteArray___getitem__, getitem_slot},
    {(void *)slot_QByteArray___len__, len_slot},
    {(void *)slot_QByteArray___ge__, ge_slot},
    {(void *)slot_QByteArray___le__, le_slot},
    {(void *)slot_QByteArray___gt__, gt_slot},
    {(void *)slot_QByteArray___lt__, lt_slot},
    {(void *)slot_QByteArray___ne__, ne_slot},
    {(void *)slot_QByteArray___eq__, eq_slot},
    {(void *)slot_QByteArray___iadd__, iconcat_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QByteArray[] = {
    {sipName_append, meth_QByteArray_append, METH_VARARGS, doc_QByteArray_append},
    {sipName_at, meth_QByteArray_at, METH_VARARGS, doc_QByteArray_at},
    {sipName_capacity, meth_QByteArray_capacity, METH_VARARGS, doc_QByteArray_capacity},
    {sipName_chop, meth_QByteArray_chop, METH_VARARGS, doc_QByteArray_chop},
    {sipName_chopped, meth_QByteArray_chopped, METH_VARARGS, doc_QByteArray_chopped},
    {sipName_clear, meth_QByteArray_clear, METH_VARARGS, doc_QByteArray_clear},
    {sipName_compare, SIP_MLMETH_CAST(meth_QByteArray_compare), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_compare},
    {sipName_contains, meth_QByteArray_contains, METH_VARARGS, doc_QByteArray_contains},
    {sipName_count, meth_QByteArray_count, METH_VARARGS, doc_QByteArray_count},
    {sipName_data, meth_QByteArray_data, METH_VARARGS, doc_QByteArray_data},
    {sipName_endsWith, meth_QByteArray_endsWith, METH_VARARGS, doc_QByteArray_endsWith},
    {sipName_fill, SIP_MLMETH_CAST(meth_QByteArray_fill), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fill},
    {sipName_fromBase64, meth_QByteArray_fromBase64, METH_VARARGS, doc_QByteArray_fromBase64},
    {sipName_fromBase64Encoding, SIP_MLMETH_CAST(meth_QByteArray_fromBase64Encoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fromBase64Encoding},
    {sipName_fromHex, meth_QByteArray_fromHex, METH_VARARGS, doc_QByteArray_fromHex},
    {sipName_fromPercentEncoding, SIP_MLMETH_CAST(meth_QByteArray_fromPercentEncoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fromPercentEncoding},
    {sipName_fromRawData, meth_QByteArray_fromRawData, METH_VARARGS, doc_QByteArray_fromRawData},
    {sipName_indexOf, SIP_MLMETH_CAST(meth_QByteArray_indexOf), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_indexOf},
    {sipName_insert, meth_QByteArray_insert, METH_VARARGS, doc_QByteArray_insert},
    {sipName_isEmpty, meth_QByteArray_isEmpty, METH_VARARGS, doc_QByteArray_isEmpty},
    {sipName_isLower, meth_QByteArray_isLower, METH_VARARGS, doc_QByteArray_isLower},
    {sipName_isNull, meth_QByteArray_isNull, METH_VARARGS, doc_QByteArray_isNull},
    {sipName_isUpper, meth_QByteArray_isUpper, METH_VARARGS, doc_QByteArray_isUpper},
    {sipName_lastIndexOf, SIP_MLMETH_CAST(meth_QByteArray_lastIndexOf), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_lastIndexOf},
    {sipName_left, meth_QByteArray_left, METH_VARARGS, doc_QByteArray_left},
    {sipName_leftJustified, SIP_MLMETH_CAST(meth_QByteArray_leftJustified), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_leftJustified},
    {sipName_length, meth_QByteArray_length, METH_VARARGS, doc_QByteArray_length},
    {sipName_mid, SIP_MLMETH_CAST(meth_QByteArray_mid), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_mid},
    {sipName_number, SIP_MLMETH_CAST(meth_QByteArray_number), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_number},
    {sipName_prepend, meth_QByteArray_prepend, METH_VARARGS, doc_QByteArray_prepend},
    {sipName_push_back, meth_QByteArray_push_back, METH_VARARGS, doc_QByteArray_push_back},
    {sipName_push_front, meth_QByteArray_push_front, METH_VARARGS, doc_QByteArray_push_front},
    {sipName_remove, meth_QByteArray_remove, METH_VARARGS, doc_QByteArray_remove},
    {sipName_repeated, meth_QByteArray_repeated, METH_VARARGS, doc_QByteArray_repeated},
    {sipName_replace, meth_QByteArray_replace, METH_VARARGS, doc_QByteArray_replace},
    {sipName_reserve, meth_QByteArray_reserve, METH_VARARGS, doc_QByteArray_reserve},
    {sipName_resize, meth_QByteArray_resize, METH_VARARGS, doc_QByteArray_resize},
    {sipName_right, meth_QByteArray_right, METH_VARARGS, doc_QByteArray_right},
    {sipName_rightJustified, SIP_MLMETH_CAST(meth_QByteArray_rightJustified), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_rightJustified},
    {sipName_setNum, SIP_MLMETH_CAST(meth_QByteArray_setNum), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_setNum},
    {sipName_simplified, meth_QByteArray_simplified, METH_VARARGS, doc_QByteArray_simplified},
    {sipName_size, meth_QByteArray_size, METH_VARARGS, doc_QByteArray_size},
    {sipName_split, meth_QByteArray_split, METH_VARARGS, doc_QByteArray_split},
    {sipName_squeeze, meth_QByteArray_squeeze, METH_VARARGS, doc_QByteArray_squeeze},
    {sipName_startsWith, meth_QByteArray_startsWith, METH_VARARGS, doc_QByteArray_startsWith},
    {sipName_swap, meth_QByteArray_swap, METH_VARARGS, doc_QByteArray_swap},
    {sipName_toBase64, meth_QByteArray_toBase64, METH_VARARGS, doc_QByteArray_toBase64},
    {sipName_toDouble, SIP_MLMETH_CAST(meth_QByteArray_toDouble), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toDouble},
    {sipName_toFloat, SIP_MLMETH_CAST(meth_QByteArray_toFloat), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toFloat},
    {sipName_toHex, meth_QByteArray_toHex, METH_VARARGS, doc_QByteArray_toHex},
    {sipName_toInt, SIP_MLMETH_CAST(meth_QByteArray_toInt), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toInt},
    {sipName_toLong, SIP_MLMETH_CAST(meth_QByteArray_toLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toLong},
    {sipName_toLongLong, SIP_MLMETH_CAST(meth_QByteArray_toLongLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toLongLong},
    {sipName_toLower, meth_QByteArray_toLower, METH_VARARGS, doc_QByteArray_toLower},
    {sipName_toPercentEncoding, SIP_MLMETH_CAST(meth_QByteArray_toPercentEncoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toPercentEncoding},
    {sipName_toShort, SIP_MLMETH_CAST(meth_QByteArray_toShort), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toShort},
    {sipName_toUInt, SIP_MLMETH_CAST(meth_QByteArray_toUInt), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toUInt},
    {sipName_toULong, SIP_MLMETH_CAST(meth_QByteArray_toULong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toULong},
    {sipName_toULongLong, SIP_MLMETH_CAST(meth_QByteArray_toULongLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toULongLong},
    {sipName_toUShort, SIP_MLMETH_CAST(meth_QByteArray_toUShort), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toUShort},
    {sipName_toUpper, meth_QByteArray_toUpper, METH_VARARGS, doc_QByteArray_toUpper},
    {sipName_trimmed, meth_QByteArray_trimmed, METH_VARARGS, doc_QByteArray_trimmed},
    {sipName_truncate, meth_QByteArray_truncate, METH_VARARGS, doc_QByteArray_truncate}
};

static sipEnumMemberDef enummembers_QByteArray[] = {
    {sipName_AbortOnBase64DecodingErrors, static_cast<int>(::QByteArray::AbortOnBase64DecodingErrors), 23},
    {sipName_Base64Encoding, static_cast<int>(::QByteArray::Base64Encoding), 23},
    {sipName_Base64UrlEncoding, static_cast<int>(::QByteArray::Base64UrlEncoding), 23},
    {sipName_IgnoreBase64DecodingErrors, static_cast<int>(::QByteArray::IgnoreBase64DecodingErrors), 23},
    {sipName_IllegalCharacter, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalCharacter), 22},
    {sipName_IllegalInputLength, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalInputLength), 22},
    {sipName_IllegalPadding, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalPadding), 22},
    {sipName_KeepTrailingEquals, static_cast<int>(::QByteArray::KeepTrailingEquals), 23},
    {sipName_Ok, static_cast<int>(::QByteArray::Base64DecodingStatus::Ok), 22},
    {sipName_OmitTrailingEquals, static_cast<int>(::QByteArray::OmitTrailingEquals), 23},
};

PyDoc_STRVAR(doc_QByteArray, "\1QByteArray()\n"
"QByteArray(size: int, c: str)\n"
"QByteArray(a: Union[QByteArray, bytes, bytearray])");


static pyqt5ClassPluginDef plugin_QByteArray = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QByteArray = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QByteArray,
        SIP_NULLPTR,
        &plugin_QByteArray,
    },
    {
        sipNameNr_QByteArray,
        {0, 0, 1},
        63, methods_QByteArray,
        10, enummembers_QByteArray,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QByteArray,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QByteArray,
    init_type_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    getbuffer_QByteArray,
    SIP_NULLPTR,
    dealloc_QByteArray,
    assign_QByteArray,
    array_QByteArray,
    copy_QByteArray,
    release_QByteArray,
    SIP_NULLPTR,
    convertTo_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QByteArray,
    sizeof (::QByteArray),
};
