/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.TypeInfo;

final class TinyAttributeImpl
extends TinyNodeImpl
implements Attr {
    public TinyAttributeImpl(TinyDocumentImpl tinyDocumentImpl, int n) {
        this.document = tinyDocumentImpl;
        this.nodeNr = n;
    }

    @Override
    public NodeInfo getParent() {
        return this.document.getNode(this.document.attParent[this.nodeNr]);
    }

    @Override
    protected long getSequenceNumber() {
        long l = ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.document.offset[this.document.attParent[this.nodeNr]]);
        return l;
    }

    @Override
    public final short getNodeType() {
        return 2;
    }

    @Override
    public String getStringValue() {
        return this.document.attValue[this.nodeNr];
    }

    @Override
    public int getFingerprint() {
        return this.document.attCode[this.nodeNr] & 0xFFFFF;
    }

    @Override
    public int getNameCode() {
        return this.document.attCode[this.nodeNr];
    }

    @Override
    public String getPrefix() {
        int n = this.document.attCode[this.nodeNr];
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.document.getNamePool().getPrefix(n);
    }

    @Override
    public String getDisplayName() {
        return this.document.getNamePool().getDisplayName(this.document.attCode[this.nodeNr]);
    }

    @Override
    public String getLocalName() {
        return this.document.getNamePool().getLocalName(this.document.attCode[this.nodeNr]);
    }

    @Override
    public final String getURI() {
        return this.document.getNamePool().getURI(this.document.attCode[this.nodeNr]);
    }

    @Override
    public String generateId() {
        return this.getParent().generateId() + "_a" + this.nodeNr;
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        int n = this.document.attCode[this.nodeNr];
        if ((n >> 20 & 0xFF) != 0) {
            n = outputter.checkAttributePrefix(n);
        }
        outputter.writeAttribute(n, this.getStringValue());
    }

    @Override
    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }
}

