/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NamespaceImpl;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.TreeEnumeration;
import java.util.Vector;

final class NamespaceEnumeration
extends TreeEnumeration {
    private ElementImpl element;
    private Vector nslist;
    private int index;
    private int length;

    public NamespaceEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        super(nodeImpl, nodeTest);
        if (nodeImpl instanceof ElementImpl) {
            this.element = (ElementImpl)nodeImpl;
            this.nslist = new Vector(10);
            this.element.addNamespaceNodes(this.element, this.nslist, true);
            this.index = -1;
            this.length = this.nslist.size();
            this.advance();
        } else {
            this.next = null;
        }
    }

    @Override
    public void step() {
        ++this.index;
        this.next = this.index < this.length ? (NamespaceImpl)this.nslist.elementAt(this.index) : null;
    }

    protected boolean conforms(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return true;
        }
        NamespaceImpl namespaceImpl = (NamespaceImpl)nodeInfo;
        if (namespaceImpl.getLocalName().equals("") && namespaceImpl.getStringValue().equals("")) {
            return false;
        }
        return this.nodeTest.matches(nodeInfo);
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isPeer() {
        return true;
    }

    @Override
    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        NamespaceEnumeration namespaceEnumeration = new NamespaceEnumeration(this.start, this.nodeTest);
        return namespaceEnumeration.count();
    }
}

