/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.peer2peer.RoomManager;
import VASSAL.chat.peer2peer.RoomTracker;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import VASSAL.tools.PropertiesEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Properties;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class P2PClient
implements ChatServerConnection,
ChatControlsInitializer,
UserDialog,
PlayerEncoder {
    private SimplePlayer me;
    private PendingPeerManager ppm;
    protected ActivePeerManager peerMgr;
    private PeerPool pool;
    private MessageBoard msgSvr;
    private WelcomeMessageServer welcomeMessageServer;
    private RoomManager roomMgr;
    private RoomTracker tracker;
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private CommandEncoder encoder;
    private boolean connected = false;
    private ServerStatus svrStatus;
    private RoomInteractionControlsInitializer roomControls;
    private SimpleStatusControlsInitializer playerStatusControls;
    private SoundEncoder soundEncoder;
    private SynchEncoder synchEncoder;
    private PropertyChangeListener nameChangeListener;
    private Properties params;

    public P2PClient(CommandEncoder commandEncoder, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, PeerPool peerPool) {
        this(commandEncoder, messageBoard, welcomeMessageServer, peerPool, new Properties());
    }

    public P2PClient(CommandEncoder commandEncoder, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, PeerPool peerPool, Properties properties) {
        this.encoder = commandEncoder;
        this.msgSvr = messageBoard;
        this.welcomeMessageServer = welcomeMessageServer;
        this.pool = peerPool;
        this.params = properties;
        this.ppm = new PendingPeerManager(this);
        this.ppm.setName("Pending Peer Manager");
        this.roomMgr = new RoomManager();
        this.tracker = new RoomTracker();
        this.me = new SimplePlayer("???");
        this.me.updateStatus();
        this.playerStatusControls = new SimpleStatusControlsInitializer(this, false);
        this.roomControls = new RoomInteractionControlsInitializer(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        this.synchEncoder = new SynchEncoder(this, this);
        this.soundEncoder = new SoundEncoder(this);
        this.nameChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SimplePlayer simplePlayer = (SimplePlayer)P2PClient.this.getUserInfo();
                simplePlayer.setName((String)propertyChangeEvent.getNewValue());
                P2PClient.this.setUserInfo(simplePlayer);
            }
        };
    }

    public RoomManager getRoomMgr() {
        return this.roomMgr;
    }

    public void sendToOthers(Command command) {
        this.sendToOthers(this.encoder.encode(command));
    }

    public void sendToAll(String string) {
        if (this.isConnected()) {
            this.sendToOthers(string);
            this.showCHAT(((P2PPlayer)this.me).getInfo(), string);
        }
    }

    public void sendToOthers(String string) {
        if (this.isConnected()) {
            Player[] playerArray;
            Room room = this.getRoom();
            for (Player player : playerArray = room.getPlayerList().toArray(new Player[room.getPlayerList().size()])) {
                ActivePeer activePeer;
                if (player.equals(this.me) || (activePeer = this.peerMgr.getPeerListenerByID(((P2PPlayer)player).getInfo().getID())) == null) continue;
                activePeer.sendCHAT(string);
            }
        }
    }

    public void sendTo(Player player, Command command) {
        if (this.peerMgr != null) {
            this.peerMgr.getPeerListenerByInfo(((P2PPlayer)player).getInfo()).sendCHAT(this.encoder.encode(command));
        }
    }

    public Room getRoom() {
        return this.roomMgr.getRoomContaining(this.me);
    }

    public void setRoom(Room room) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setRoom(room.getName());
            if (this.isConnected()) {
                this.peerMgr.sendToAllNAME();
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                Room room2 = this.getRoom();
                this.propSupport.firePropertyChange("Room", null, room2);
            }
        }
    }

    public Room[] getAvailableRooms() {
        return this.roomMgr.getRooms();
    }

    public Player getUserInfo() {
        return this.me;
    }

    public void setUserInfo(Player player) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setStats(player);
            if (this.isConnected()) {
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.peerMgr.sendToAllNAME();
            }
        } else {
            this.me = (SimplePlayer)player;
            this.me.updateStatus();
        }
        this.propSupport.firePropertyChange("Player", null, this.me);
    }

    public void setConnected(boolean bl) {
        if (bl) {
            try {
                Integer n;
                try {
                    n = Integer.valueOf(this.params.getProperty("listenPort"));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 5050;
                }
                MyInfo myInfo = new MyInfo(null, n);
                myInfo.setNetworkPw(this.params.getProperty("serverPw"));
                P2PPlayer p2PPlayer = new P2PPlayer(myInfo);
                p2PPlayer.updateStatus();
                p2PPlayer.setName(this.me.getName());
                p2PPlayer.setRoom(this.roomMgr.getDefaultRoom().getName());
                p2PPlayer.setId(GameModule.getUserId() + "." + System.currentTimeMillis());
                this.setUserInfo(p2PPlayer);
                this.pool.initialize(p2PPlayer, this.ppm);
                if (this.peerMgr == null) {
                    this.peerMgr = new ActivePeerManager(myInfo, this, this.ppm);
                }
                this.roomMgr.update(((P2PPlayer)this.me).getInfo());
                this.fireStatus(Resources.getString("Peer2Peer.server_connection_established", this.params.getProperty("listenPort")));
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.getRooms());
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.welcomeMessageServer.getWelcomeMessage().execute();
                this.connected = true;
                this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
            }
            catch (IOException iOException) {
                this.fireStatus(Resources.getString("Peer2Peer.connection_error", iOException.getMessage()));
                this.fireStatus(Resources.getString("Peer2Peer.disconnected"));
                this.connected = false;
                this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
            }
        } else if (this.isConnected()) {
            if (this.peerMgr != null) {
                this.peerMgr.clear();
            }
            this.roomMgr.clear();
            this.pool.disconnect();
            this.propSupport.firePropertyChange("AvailableRooms", null, new Room[0]);
            this.propSupport.firePropertyChange("Room", new SimpleRoom(), null);
            this.connected = false;
            this.propSupport.firePropertyChange("Connected", Boolean.TRUE, Boolean.FALSE);
            this.fireStatus(Resources.getString("Peer2Peer.disconnected"));
            this.ppm.finish();
        }
    }

    protected void fireStatus(String string) {
        this.propSupport.firePropertyChange("Status", null, string);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Message[] getMessages() {
        return this.msgSvr.getMessages();
    }

    public void postMessage(String string) {
        this.msgSvr.postMessage(string);
    }

    public MessageBoard getMessageServer() {
        return this.msgSvr;
    }

    public ServerStatus getStatusServer() {
        return this.svrStatus;
    }

    public Player stringToPlayer(String string) {
        return this.roomMgr.getPlayerById(string);
    }

    public String playerToString(Player player) {
        return player.getId();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void setActivePeerManager(ActivePeerManager activePeerManager) {
        this.peerMgr = activePeerManager;
    }

    public void setPendingPeerManager(PendingPeerManager pendingPeerManager) {
        this.ppm = pendingPeerManager;
    }

    public synchronized void showUnrecognized(PeerInfo peerInfo, String string) {
    }

    public synchronized void showStreamsFailed(PeerInfo peerInfo) {
        P2PPlayer p2PPlayer = new P2PPlayer(peerInfo);
        this.propSupport.firePropertyChange("Status", null, Resources.getString("Peer2Peer.connection_lost", p2PPlayer.getName()));
    }

    public synchronized void showConnectFailed(PeerInfo peerInfo) {
        this.pool.connectFailed(peerInfo);
    }

    public synchronized void showConnect(PeerInfo peerInfo) {
    }

    public synchronized void showDisconnect(PeerInfo peerInfo) {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.remove(peerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    public synchronized void showCHAT(PeerInfo peerInfo, String string) {
        this.propSupport.firePropertyChange("Msg", null, string);
    }

    public synchronized void showPMSG(PeerInfo peerInfo, String string) {
        this.showCHAT(peerInfo, string);
    }

    public synchronized void showNAME(PeerInfo peerInfo) {
        this.tracker.init(this.getRoom());
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(peerInfo));
        Room room = this.getRoom();
        this.propSupport.firePropertyChange("Room", null, room);
        this.tracker.finalize(room);
    }

    public synchronized void showHELO(PeerInfo peerInfo) {
        String string;
        Chatter chatter = GameModule.getGameModule().getChatter();
        ActivePeer activePeer = this.peerMgr.getPeerListenerByInfo(peerInfo);
        try {
            Properties properties = new PropertiesEncoder(peerInfo.getChatName()).getProperties();
            String string2 = properties.getProperty("name");
            String string3 = properties.getProperty("ip");
            string = string2 + " (" + string3 + ":" + peerInfo.getPort() + ")";
        }
        catch (IOException iOException) {
            string = "";
        }
        if (!peerInfo.getNetworkPw().equals(this.params.getProperty("serverPw"))) {
            new Chatter.DisplayText(chatter, Resources.getString("Peer2Peer.bad_password", string)).execute();
            activePeer.finish();
            return;
        }
        this.fireStatus(Resources.getString("Peer2Peer.connected", string));
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(peerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        this.playerStatusControls.initializeControls(chatServerControls);
        this.roomControls.initializeControls(chatServerControls);
        chatServerControls.setRoomControlsVisible(false);
        GameModule gameModule = GameModule.getGameModule();
        this.me.setName((String)gameModule.getPrefs().getValue("RealName"));
        gameModule.getPrefs().getOption("RealName").addPropertyChangeListener(this.nameChangeListener);
        gameModule.addCommandEncoder(this.synchEncoder);
        gameModule.addCommandEncoder(this.soundEncoder);
        if (this.pool instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.pool)).initializeControls(chatServerControls);
        }
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        this.playerStatusControls.uninitializeControls(chatServerControls);
        this.roomControls.uninitializeControls(chatServerControls);
        GameModule gameModule = GameModule.getGameModule();
        gameModule.getPrefs().getOption("RealName").removePropertyChangeListener(this.nameChangeListener);
        gameModule.removeCommandEncoder(this.synchEncoder);
        gameModule.removeCommandEncoder(this.soundEncoder);
        if (this.pool instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.pool)).uninitializeControls(chatServerControls);
        }
    }
}

