/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Clone
extends Decorator
implements TranslatablePiece {
    public static final String ID = "clone;";
    protected KeyCommand[] command;
    protected String commandName;
    protected NamedKeyStroke key;
    protected KeyCommand cloneCommand;

    public Clone() {
        this("clone;Clone;C", null);
    }

    public Clone(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.commandName = decoder.nextToken();
        this.key = decoder.nextNamedKeyStroke('C');
        this.command = null;
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.key);
        return ID + sequenceEncoder.getValue();
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.cloneCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.cloneCommand} : new KeyCommand[0];
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    public String myGetState() {
        return "";
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        AddPiece addPiece = null;
        this.myGetKeyCommands();
        if (this.cloneCommand.matches(keyStroke)) {
            GamePiece gamePiece = Decorator.getOutermost(this);
            GamePiece gamePiece2 = ((AddPiece)GameModule.getGameModule().decode(GameModule.getGameModule().encode(new AddPiece(gamePiece)))).getTarget();
            gamePiece2.setId(null);
            GameModule.getGameModule().getGameState().addPiece(gamePiece2);
            gamePiece2.setState(gamePiece.getState());
            addPiece = new AddPiece(gamePiece2);
            if (this.getMap() != null) {
                addPiece.append(this.getMap().placeOrMerge(gamePiece2, gamePiece.getPosition()));
                KeyBuffer.getBuffer().remove(gamePiece);
                KeyBuffer.getBuffer().add(gamePiece2);
            }
        }
        return addPiece;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public String getDescription() {
        return "Clone";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.htm", "Clone");
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, "Clone command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer nameInput;
        private NamedHotKeyConfigurer keyInput;
        private JPanel controls = new JPanel();

        public Ed(Clone clone) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.nameInput = new StringConfigurer(null, "Command name:  ", clone.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", clone.key);
            this.controls.add(this.keyInput.getControls());
        }

        public Component getControls() {
            return this.controls;
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameInput.getValueString()).append(this.keyInput.getValueString());
            return Clone.ID + sequenceEncoder.getValue();
        }

        public String getState() {
            return "";
        }
    }
}

