/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LoopControl;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerAction
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "macro;";
    protected String name = "";
    protected String command = "";
    protected NamedKeyStroke key = NamedKeyStroke.NULL_KEYSTROKE;
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];
    protected NamedKeyStroke[] actionKeys = new NamedKeyStroke[0];
    protected boolean loop = false;
    protected NamedKeyStroke preLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected NamedKeyStroke postLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected String loopType = "counted";
    protected PropertyExpression whileExpression = new PropertyExpression();
    protected PropertyExpression untilExpression = new PropertyExpression();
    protected FormattedString loopCount = new FormattedString("1");
    protected boolean index = false;
    protected String indexProperty = "";
    protected FormattedString indexStart = new FormattedString("1");
    protected FormattedString indexStep = new FormattedString("1");
    protected int indexValue = 0;
    protected GamePiece outer;

    public TriggerAction() {
        this(ID, null);
    }

    public TriggerAction(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command.length() > 0 && this.key != null) {
            KeyCommand keyCommand = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this.matchesFilter());
            if (this.getMap() == null) {
                keyCommand.setEnabled(false);
            }
            return new KeyCommand[]{keyCommand};
        }
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.name).append(this.command).append(this.key).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys)).append(NamedKeyStrokeArrayConfigurer.encode(this.actionKeys)).append(this.loop).append(this.preLoopKey).append(this.postLoopKey).append(this.loopType).append(this.whileExpression.getExpression()).append(this.untilExpression.getExpression()).append(this.loopCount.getFormat()).append(this.index).append(this.indexProperty).append(this.indexStart.getFormat()).append(this.indexStep.getFormat());
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke keyStroke) {
        Command command = this.piece.keyEvent(keyStroke);
        return command == null ? this.myKeyEvent(keyStroke) : command.append(this.myKeyEvent(keyStroke));
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        boolean bl = false;
        if (this.key.equals(keyStroke)) {
            bl = true;
        }
        for (int i = 0; i < this.watchKeys.length && !bl; ++i) {
            if (!this.watchKeys[i].equals(keyStroke)) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (!this.matchesFilter()) {
            return null;
        }
        this.outer = Decorator.getOutermost(this);
        NullCommand nullCommand = new NullCommand();
        if (!this.loop) {
            try {
                this.doLoopOnce(nullCommand);
            }
            catch (RecursionLimitException recursionLimitException) {
                RecursionLimiter.infiniteLoop(recursionLimitException);
            }
            return nullCommand;
        }
        this.indexValue = this.parse("Index Property Start Value", this.indexStart, this.outer);
        int n = this.parse("Index Property increment value", this.indexStep, this.outer);
        this.executeKey(nullCommand, this.preLoopKey);
        int n2 = 0;
        int n3 = 0;
        if ("counted".equals(this.loopType)) {
            n3 = this.loopCount.getTextAsInt((PropertySource)this.outer, Resources.getString("Editor.LoopControl.loop_count"), this);
        }
        RecursionLimitException recursionLimitException = null;
        while (!"while".equals(this.loopType) || this.whileExpression.accept(this.outer)) {
            try {
                this.doLoopOnce(nullCommand);
            }
            catch (RecursionLimitException recursionLimitException2) {
                recursionLimitException = recursionLimitException2;
                break;
            }
            if ("until".equals(this.loopType) && this.untilExpression.accept(this.outer)) break;
            if (n2++ >= 500) {
                recursionLimitException = new RecursionLimitException(this);
                break;
            }
            if ("counted".equals(this.loopType) && n2 >= n3) break;
            this.indexValue += n;
        }
        this.executeKey(nullCommand, this.postLoopKey);
        if (recursionLimitException != null) {
            RecursionLimiter.infiniteLoop(recursionLimitException);
        }
        return nullCommand;
    }

    private int parse(String string, FormattedString formattedString, GamePiece gamePiece) {
        int n = 0;
        String string2 = formattedString.getText((PropertySource)gamePiece, "0");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            TriggerAction.reportDataError(this, Resources.getString("Error.non_number_error"), formattedString.debugInfo(string2, string), numberFormatException);
        }
        return n;
    }

    protected boolean isIndex() {
        return this.loop && this.index && this.indexProperty != null && this.indexProperty.length() > 0;
    }

    @Override
    public Object getProperty(Object object) {
        if (this.isIndex() && this.indexProperty.equals(object)) {
            return String.valueOf(this.indexValue);
        }
        return super.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (this.isIndex() && this.indexProperty.equals(object)) {
            return String.valueOf(this.indexValue);
        }
        return super.getLocalizedProperty(object);
    }

    protected void doLoopOnce(Command command) throws RecursionLimitException {
        try {
            RecursionLimiter.startExecution(this);
            for (int i = 0; i < this.actionKeys.length && this.getMap() != null; ++i) {
                command.append(this.outer.keyEvent(this.actionKeys[i].getKeyStroke()));
            }
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeKey(Command command, NamedKeyStroke namedKeyStroke) {
        if (namedKeyStroke.isNull() || this.getMap() == null) {
            return;
        }
        try {
            RecursionLimiter.startExecution(this);
            command.append(this.outer.keyEvent(namedKeyStroke.getKeyStroke()));
        }
        catch (RecursionLimitException recursionLimitException) {
            RecursionLimiter.infiniteLoop(recursionLimitException);
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    protected boolean matchesFilter() {
        GamePiece gamePiece = Decorator.getOutermost(this);
        return this.propertyMatch.isNull() || this.propertyMatch.accept(gamePiece);
    }

    @Override
    public void mySetState(String string) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        String string = Resources.getString("Editor.TriggerAction.component_type");
        if (this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TriggerAction.htm");
    }

    @Override
    public void mySetType(String string) {
        int n;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.name = decoder.nextToken("");
        this.command = decoder.nextToken("Trigger");
        this.key = decoder.nextNamedKeyStroke('T');
        this.propertyMatch.setExpression(decoder.nextToken(""));
        String string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.watchKeys = new NamedKeyStroke[string2.length()];
            for (n = 0; n < this.watchKeys.length; ++n) {
                this.watchKeys[n] = NamedKeyStroke.getNamedKeyStroke(string2.charAt(n), 2);
            }
        }
        string2 = decoder.nextToken("");
        if (string2.indexOf(44) > 0) {
            this.actionKeys = NamedKeyStrokeArrayConfigurer.decode(string2);
        } else {
            this.actionKeys = new NamedKeyStroke[string2.length()];
            for (n = 0; n < this.actionKeys.length; ++n) {
                this.actionKeys[n] = NamedKeyStroke.getNamedKeyStroke(string2.charAt(n), 2);
            }
        }
        this.loop = decoder.nextBoolean(false);
        this.preLoopKey = decoder.nextNamedKeyStroke();
        this.postLoopKey = decoder.nextNamedKeyStroke();
        this.loopType = decoder.nextToken("counted");
        this.whileExpression.setExpression(decoder.nextToken(""));
        this.untilExpression.setExpression(decoder.nextToken(""));
        this.loopCount.setFormat(decoder.nextToken(""));
        this.index = decoder.nextBoolean(false);
        this.indexProperty = decoder.nextToken("");
        this.indexStart.setFormat(decoder.nextToken("1"));
        this.indexStep.setFormat(decoder.nextToken("1"));
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isIndex()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.indexProperty);
            return arrayList;
        }
        return super.getPropertyNames();
    }

    public void setPropertyMatch(String string) {
        this.propertyMatch.setExpression(string);
    }

    public void setCommandName(String string) {
        this.command = string;
    }

    public void setKey(NamedKeyStroke namedKeyStroke) {
        this.key = namedKeyStroke;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, this.getCommandDescription(this.name, "Trigger command"));
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer name;
        private StringConfigurer command;
        private NamedHotKeyConfigurer key;
        private PropertyExpressionConfigurer propertyMatch;
        private NamedKeyStrokeArrayConfigurer watchKeys;
        private NamedKeyStrokeArrayConfigurer actionKeys;
        private JPanel box;
        private BooleanConfigurer loopConfig;
        private NamedHotKeyConfigurer preLoopKeyConfig;
        private NamedHotKeyConfigurer postLoopKeyConfig;
        private StringEnumConfigurer loopTypeConfig;
        private PropertyExpressionConfigurer whileExpressionConfig;
        private PropertyExpressionConfigurer untilExpressionConfig;
        private FormattedStringConfigurer loopCountConfig;
        private BooleanConfigurer indexConfig;
        private StringConfigurer indexPropertyConfig;
        private FormattedStringConfigurer indexStartConfig;
        private FormattedStringConfigurer indexStepConfig;

        public Ed(TriggerAction triggerAction) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Ed.this.updateVisibility();
                }
            };
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, Resources.getString("Editor.description_label"), triggerAction.name);
            this.box.add(this.name.getControls());
            this.propertyMatch = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.trigger_when_properties"), triggerAction.propertyMatch, Decorator.getOutermost(triggerAction));
            this.box.add(this.propertyMatch.getControls());
            Box box = Box.createHorizontalBox();
            this.command = new StringConfigurer(null, Resources.getString("Editor.menu_command"), triggerAction.command);
            box.add(this.command.getControls());
            this.key = new NamedHotKeyConfigurer(null, Resources.getString("Editor.keyboard_command"), triggerAction.key);
            box.add(this.key.getControls());
            this.box.add(box);
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(null, Resources.getString("Editor.TriggerAction.watch_for"), triggerAction.watchKeys);
            this.box.add(this.watchKeys.getControls());
            this.actionKeys = new NamedKeyStrokeArrayConfigurer(null, Resources.getString("Editor.TriggerAction.perform_keystrokes"), triggerAction.actionKeys);
            this.box.add(this.actionKeys.getControls());
            this.loopConfig = new BooleanConfigurer(null, Resources.getString("Editor.TriggerAction.repeat_this"), triggerAction.loop);
            this.loopConfig.addPropertyChangeListener(propertyChangeListener);
            this.box.add(this.loopConfig.getControls());
            this.loopTypeConfig = new StringEnumConfigurer(null, Resources.getString("Editor.LoopControl.type_of_loop"), LoopControl.LOOP_TYPE_DESCS);
            this.loopTypeConfig.setValue(LoopControl.loopTypeToDesc(triggerAction.loopType));
            this.loopTypeConfig.addPropertyChangeListener(propertyChangeListener);
            this.box.add(this.loopTypeConfig.getControls());
            this.loopCountConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.loop_how_many"), triggerAction.loopCount.getFormat(), triggerAction);
            this.box.add(this.loopCountConfig.getControls());
            this.whileExpressionConfig = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.looping_continues"), triggerAction.whileExpression);
            this.box.add(this.whileExpressionConfig.getControls());
            this.untilExpressionConfig = new PropertyExpressionConfigurer(null, Resources.getString("Editor.TriggerAction.looping_ends"), triggerAction.untilExpression);
            this.box.add(this.untilExpressionConfig.getControls());
            this.preLoopKeyConfig = new NamedHotKeyConfigurer(null, Resources.getString("Editor.TriggerAction.keystroke_before"), triggerAction.preLoopKey);
            this.box.add(this.preLoopKeyConfig.getControls());
            this.postLoopKeyConfig = new NamedHotKeyConfigurer(null, Resources.getString("Editor.TriggerAction.keystroke_after"), triggerAction.postLoopKey);
            this.box.add(this.postLoopKeyConfig.getControls());
            this.indexConfig = new BooleanConfigurer(null, Resources.getString("Editor.LoopControl.loop_index"), triggerAction.index);
            this.indexConfig.addPropertyChangeListener(propertyChangeListener);
            this.box.add(this.indexConfig.getControls());
            this.indexPropertyConfig = new StringConfigurer(null, Resources.getString("Editor.LoopControl.index_name"), triggerAction.indexProperty);
            this.box.add(this.indexPropertyConfig.getControls());
            this.indexStartConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.index_start"), triggerAction.indexStart.getFormat(), triggerAction);
            this.box.add(this.indexStartConfig.getControls());
            this.indexStepConfig = new FormattedExpressionConfigurer(null, Resources.getString("Editor.LoopControl.index_step"), triggerAction.indexStep.getFormat(), triggerAction);
            this.box.add(this.indexStepConfig.getControls());
            this.updateVisibility();
        }

        private void updateVisibility() {
            boolean bl = this.loopConfig.booleanValue();
            boolean bl2 = this.indexConfig.booleanValue();
            String string = LoopControl.loopDescToType(this.loopTypeConfig.getValueString());
            this.loopTypeConfig.getControls().setVisible(bl);
            this.loopCountConfig.getControls().setVisible(bl && string.equals("counted"));
            this.whileExpressionConfig.getControls().setVisible(bl && string.equals("while"));
            this.untilExpressionConfig.getControls().setVisible(bl && string.equals("until"));
            this.preLoopKeyConfig.getControls().setVisible(bl);
            this.postLoopKeyConfig.getControls().setVisible(bl);
            this.indexConfig.getControls().setVisible(bl);
            this.indexPropertyConfig.getControls().setVisible(bl && bl2);
            this.indexStartConfig.getControls().setVisible(bl && bl2);
            this.indexStepConfig.getControls().setVisible(bl && bl2);
            Window window = SwingUtilities.getWindowAncestor(this.box);
            if (window != null) {
                window.pack();
            }
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.name.getValueString()).append(this.command.getValueString()).append(this.key.getValueString()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString()).append(this.actionKeys.getValueString()).append(this.loopConfig.getValueString()).append(this.preLoopKeyConfig.getValueString()).append(this.postLoopKeyConfig.getValueString()).append(LoopControl.loopDescToType(this.loopTypeConfig.getValueString())).append(this.whileExpressionConfig.getValueString()).append(this.untilExpressionConfig.getValueString()).append(this.loopCountConfig.getValueString()).append(this.indexConfig.getValueString()).append(this.indexPropertyConfig.getValueString()).append(this.indexStartConfig.getValueString()).append(this.indexStepConfig.getValueString());
            return TriggerAction.ID + sequenceEncoder.getValue();
        }
    }
}

