/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.configure.ConfigureTree;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPathBuilder {
    private static ComponentPathBuilder instance;

    public static ComponentPathBuilder getInstance() {
        if (instance == null) {
            instance = new ComponentPathBuilder();
        }
        return instance;
    }

    public String getId(Configurable[] configurableArray) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('/');
        for (int i = 0; i < configurableArray.length; ++i) {
            String string = configurableArray[i].getConfigureName();
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(configurableArray[i].getClass().getName(), ':');
            if (string != null) {
                sequenceEncoder2.append(string);
            }
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue() == null ? "" : sequenceEncoder.getValue();
    }

    public Configurable[] getPath(String string) throws PathFormatException {
        ArrayList<Configurable> arrayList = new ArrayList<Configurable>();
        if (string.length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
            this.addToPath(GameModule.getGameModule(), decoder, arrayList);
        }
        return arrayList.toArray(new Configurable[arrayList.size()]);
    }

    private void addToPath(Configurable configurable, SequenceEncoder.Decoder decoder, List<Configurable> list) throws PathFormatException {
        if (decoder.hasMoreTokens()) {
            String string = decoder.nextToken();
            String string2 = null;
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string, ':');
            String string3 = decoder2.nextToken();
            if (decoder2.hasMoreTokens()) {
                string2 = decoder2.nextToken();
            }
            Configurable[] configurableArray = configurable.getConfigureComponents();
            Configurable configurable2 = null;
            ArrayList<Configurable> arrayList = new ArrayList<Configurable>();
            int n = -1;
            while (++n < configurableArray.length) {
                if (!string3.equals(configurableArray[n].getClass().getName())) continue;
                arrayList.add(configurableArray[n]);
                if (!(string2 == null ? configurableArray[n].getConfigureName() == null : string2.equals(configurableArray[n].getConfigureName()))) continue;
                configurable2 = configurableArray[n];
                break;
            }
            if (configurable2 != null) {
                list.add(configurable2);
                this.addToPath(configurable2, decoder, list);
            } else if (!arrayList.isEmpty()) {
                if (!decoder.hasMoreTokens()) {
                    list.add((Configurable)arrayList.get(0));
                } else {
                    ArrayList<Configurable> arrayList2 = null;
                    for (Configurable configurable3 : arrayList) {
                        ArrayList<Configurable> arrayList3 = new ArrayList<Configurable>();
                        try {
                            this.addToPath(configurable3, decoder.copy(), arrayList3);
                            arrayList2 = arrayList3;
                            arrayList2.add(0, configurable3);
                            break;
                        }
                        catch (PathFormatException pathFormatException) {
                        }
                    }
                    if (arrayList2 != null) {
                        list.addAll(arrayList2);
                    } else {
                        this.findFailed(string3, string2, configurable);
                    }
                }
            } else {
                this.findFailed(string3, string2, configurable);
            }
        }
    }

    private void findFailed(String string, String string2, Configurable configurable) throws PathFormatException {
        String string3 = string2;
        if (string3 == null) {
            string3 = string.substring(string.lastIndexOf(46) + 1);
        }
        throw new PathFormatException("Could not find " + string3 + " in " + ConfigureTree.getConfigureName(configurable.getClass()));
    }

    public static class PathFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PathFormatException(String string) {
            super(string);
        }
    }
}

