/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent;

import VASSAL.tools.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFuture<V>
implements SettableFuture<V> {
    protected V result = null;
    protected Throwable exception = null;
    protected volatile boolean cancelled = false;
    protected final CountDownLatch done = new CountDownLatch(1);

    @Override
    public boolean cancel(boolean bl) {
        if (this.cancelled) {
            return false;
        }
        if (this.done.getCount() != 0L) {
            this.cancelled = true;
            this.done.countDown();
        }
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.done.getCount() == 0L;
    }

    @Override
    public void setException(Throwable throwable) {
        this.exception = throwable;
        this.done.countDown();
    }

    @Override
    public void set(V v) {
        this.result = v;
        this.done.countDown();
    }

    @Override
    public V get() throws CancellationException, ExecutionException, InterruptedException {
        this.done.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (!this.done.await(l, timeUnit)) {
            throw new TimeoutException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }
}

