/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.io.IOUtils;
import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.IPCMessage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCMessageDispatcher
implements Runnable {
    protected final BlockingQueue<IPCMessage> queue;
    protected final ObjectOutput out;

    public IPCMessageDispatcher(BlockingQueue<IPCMessage> blockingQueue, ObjectOutput objectOutput) {
        this.queue = blockingQueue;
        this.out = objectOutput;
    }

    @Override
    public void run() {
        try {
            IPCMessage iPCMessage;
            do {
                iPCMessage = this.queue.take();
                this.out.writeObject(iPCMessage);
                this.out.flush();
            } while (!(iPCMessage instanceof Fin));
            this.out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(this.out);
        }
    }
}

