/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Immobilized
extends Decorator
implements EditablePiece {
    public static final String ID = "immob;";
    protected boolean shiftToSelect = false;
    protected boolean altToSelect = false;
    protected boolean ignoreGrid = false;
    protected boolean neverSelect = false;
    protected boolean neverMove = false;
    protected boolean moveIfSelected = false;
    protected EventFilter selectFilter;
    protected EventFilter moveFilter;
    protected static final char MOVE_SELECTED = 'I';
    protected static final char MOVE_NORMAL = 'N';
    protected static final char NEVER_MOVE = 'V';
    protected static final char IGNORE_GRID = 'g';
    protected static final char SHIFT_SELECT = 'i';
    protected static final char ALT_SELECT = 'c';
    protected static final char NEVER_SELECT = 'n';
    protected static EventFilter NEVER = new EventFilter(){

        public boolean rejectEvent(InputEvent inputEvent) {
            return true;
        }
    };

    public Immobilized() {
        this(null, ID);
    }

    public Immobilized(GamePiece gamePiece, String string) {
        this.setInner(gamePiece);
        this.mySetType(string);
    }

    @Override
    public void mySetType(String string) {
        this.shiftToSelect = false;
        this.altToSelect = false;
        this.neverSelect = false;
        this.ignoreGrid = false;
        this.neverMove = false;
        this.moveIfSelected = false;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        String string2 = decoder.nextToken("");
        String string3 = decoder.nextToken("");
        if (string2.indexOf(105) >= 0) {
            this.shiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (string2.indexOf(99) >= 0) {
            this.altToSelect = true;
            this.moveIfSelected = true;
        }
        if (string2.indexOf(110) >= 0) {
            this.neverSelect = true;
            this.neverMove = true;
        }
        if (string2.indexOf(103) >= 0) {
            this.ignoreGrid = true;
        }
        if (string3.length() > 0) {
            switch (string3.charAt(0)) {
                case 'V': {
                    this.neverMove = true;
                    this.moveIfSelected = false;
                    break;
                }
                case 'I': {
                    this.neverMove = false;
                    this.moveIfSelected = true;
                    break;
                }
                default: {
                    this.neverMove = false;
                    this.moveIfSelected = false;
                }
            }
        }
        this.selectFilter = this.neverSelect ? NEVER : (this.shiftToSelect ? new UseShift() : (this.altToSelect ? new UseAlt() : null));
        this.moveFilter = this.neverMove ? NEVER : (this.moveIfSelected ? new MoveIfSelected() : null);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if ("NoStack".equals(object)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(object)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(object)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(object)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(object)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(object)) {
            return this.neverMove;
        }
        return super.getLocalizedProperty(object);
    }

    @Override
    public Object getProperty(Object object) {
        if ("NoStack".equals(object)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(object)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(object)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(object)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(object)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(object)) {
            return this.neverMove;
        }
        return super.getProperty(object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetType() {
        StringBuilder stringBuilder = new StringBuilder(ID);
        if (this.neverSelect) {
            stringBuilder.append('n');
        } else if (this.shiftToSelect) {
            stringBuilder.append('i');
        } else if (this.altToSelect) {
            stringBuilder.append('c');
        }
        if (this.ignoreGrid) {
            stringBuilder.append('g');
        }
        stringBuilder.append(';');
        if (this.neverMove) {
            stringBuilder.append('V');
        } else if (this.moveIfSelected) {
            stringBuilder.append('I');
        } else {
            stringBuilder.append('N');
        }
        return stringBuilder.toString();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String string) {
    }

    @Override
    public String getDescription() {
        return "Does not stack";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonStacking.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Immobile");
        arrayList.add("IgnoreGrid");
        arrayList.add("cannotMove");
        return arrayList;
    }

    private static class Ed
    implements PieceEditor {
        private JComboBox selectionOption = new JComboBox();
        private JComboBox movementOption;
        private JCheckBox ignoreGridBox;
        private Box controls;

        public Ed(Immobilized immobilized) {
            this.selectionOption.addItem("normally");
            this.selectionOption.addItem("when shift-key down");
            this.selectionOption.addItem("when alt-key down");
            this.selectionOption.addItem("never");
            if (immobilized.neverSelect) {
                this.selectionOption.setSelectedIndex(3);
            } else if (immobilized.altToSelect) {
                this.selectionOption.setSelectedIndex(2);
            } else if (immobilized.shiftToSelect) {
                this.selectionOption.setSelectedIndex(1);
            } else {
                this.selectionOption.setSelectedIndex(0);
            }
            this.ignoreGridBox = new JCheckBox("Ignore map grid when moving?");
            this.ignoreGridBox.setSelected(immobilized.ignoreGrid);
            this.controls = Box.createVerticalBox();
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Select piece:  "));
            box.add(this.selectionOption);
            this.controls.add(box);
            this.movementOption = new JComboBox();
            this.movementOption.addItem("normally");
            this.movementOption.addItem("only if selected");
            this.movementOption.addItem("never");
            if (immobilized.neverMove) {
                this.movementOption.setSelectedIndex(2);
            } else if (immobilized.moveIfSelected) {
                this.movementOption.setSelectedIndex(1);
            } else {
                this.movementOption.setSelectedIndex(0);
            }
            box = Box.createHorizontalBox();
            box.add(new JLabel("Move piece:  "));
            box.add(this.movementOption);
            this.controls.add(box);
            this.controls.add(this.ignoreGridBox);
        }

        public String getState() {
            return "";
        }

        public String getType() {
            String string = Immobilized.ID;
            switch (this.selectionOption.getSelectedIndex()) {
                case 1: {
                    string = string + 'i';
                    break;
                }
                case 2: {
                    string = string + 'c';
                    break;
                }
                case 3: {
                    string = string + 'n';
                }
            }
            if (this.ignoreGridBox.isSelected()) {
                string = string + 'g';
            }
            string = string + ';';
            switch (this.movementOption.getSelectedIndex()) {
                case 0: {
                    string = string + 'N';
                    break;
                }
                case 1: {
                    string = string + 'I';
                    break;
                }
                case 2: {
                    string = string + 'V';
                }
            }
            return string;
        }

        public Component getControls() {
            return this.controls;
        }
    }

    protected class MoveIfSelected
    implements EventFilter {
        protected MoveIfSelected() {
        }

        public boolean rejectEvent(InputEvent inputEvent) {
            return !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseAlt
    implements EventFilter {
        public boolean rejectEvent(InputEvent inputEvent) {
            return !inputEvent.isAltDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseShift
    implements EventFilter {
        public boolean rejectEvent(InputEvent inputEvent) {
            return !inputEvent.isShiftDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }
}

