/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.TilingHandler;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.ReadOnlyPrefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.concurrent.FutureUtils;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleFileFilter;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.ipc.IPCMessage;
import VASSAL.tools.ipc.IPCMessenger;
import VASSAL.tools.ipc.SimpleIPCMessage;
import VASSAL.tools.lang.MemoryUtils;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLaunchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractLaunchAction.class);
    protected static final int PHYS_MEMORY;
    protected static final int DEFAULT_INITIAL_HEAP = 256;
    protected static final int DEFAULT_MAXIMUM_HEAP = 512;
    protected static final int FAILSAFE_INITIAL_HEAP = 64;
    protected static final int FAILSAFE_MAXIMUM_HEAP = 128;
    protected final Window window;
    protected final String entryPoint;
    protected final LaunchRequest lr;
    protected static final Set<File> editing;
    protected static final Map<File, Integer> using;
    protected static final List<IPCMessenger> children;
    protected static final AtomicInteger nextId;

    public AbstractLaunchAction(String string, Window window, String string2, LaunchRequest launchRequest) {
        super(string);
        this.window = window;
        this.entryPoint = string2;
        this.lr = launchRequest;
    }

    public static boolean isInUse(File file) {
        return using.containsKey(file);
    }

    public static boolean isEditing(File file) {
        return editing.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutDown() {
        ModuleManagerWindow.getInstance().toBack();
        ArrayList<Future<IPCMessage>> arrayList = new ArrayList<Future<IPCMessage>>();
        List<IPCMessenger> list = children;
        synchronized (list) {
            for (IPCMessenger interruptedException : children) {
                try {
                    arrayList.add(interruptedException.send(new Launcher.CloseRequest()));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        for (Future future : arrayList) {
            try {
                if (!(future.get() instanceof Launcher.CloseReject)) continue;
                System.out.println("rejected!");
                return false;
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ModuleManagerWindow.getInstance().setWaitCursor(true);
        this.getLaunchTask().execute();
    }

    protected abstract LaunchTask getLaunchTask();

    protected File promptForFile() {
        FileChooser fileChooser = FileChooser.createFileChooser(this.window, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        this.addFileFilters(fileChooser);
        if (fileChooser.showOpenDialog() == 0) {
            this.lr.module = fileChooser.getSelectedFile();
            if (this.lr.module != null) {
                if (this.lr.module.exists()) {
                    AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.module);
                    if (abstractMetaData == null || !(abstractMetaData instanceof ModuleMetaData)) {
                        ErrorDialog.show("Error.invalid_vassal_module", this.lr.module.getAbsolutePath());
                        logger.error("-- Load of {} failed: Not a Vassal module", (Object)this.lr.module.getAbsolutePath());
                        this.lr.module = null;
                    }
                } else {
                    this.lr.module = null;
                }
            }
        }
        return this.lr.module;
    }

    protected void addFileFilters(FileChooser fileChooser) {
        fileChooser.addChoosableFileFilter(new ModuleFileFilter());
    }

    static {
        long l = MemoryUtils.getPhysicalMemory();
        PHYS_MEMORY = l < 0L ? 4096 : (int)(l >> 20);
        editing = Collections.synchronizedSet(new HashSet());
        using = Collections.synchronizedMap(new HashMap());
        children = Collections.synchronizedList(new ArrayList());
        nextId = new AtomicInteger(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifySaveFileOkListener
    implements EventListener<NotifySaveFileOk> {
        protected NotifySaveFileOkListener() {
        }

        @Override
        public void receive(Object object, final NotifySaveFileOk notifySaveFileOk) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().update(notifySaveFileOk.file);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifyOpenModuleFailedListener
    implements EventListener<NotifyOpenModuleFailed> {
        protected NotifyOpenModuleFailedListener() {
        }

        @Override
        public void receive(Object object, NotifyOpenModuleFailed notifyOpenModuleFailed) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
            ErrorDialog.showDetails(notifyOpenModuleFailed.thrown, ThrowableUtils.getStackTrace(notifyOpenModuleFailed.thrown), "Error.module_load_failed", notifyOpenModuleFailed.thrown.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifyImportModuleOkListener
    implements EventListener<NotifyImportModuleOk> {
        protected NotifyImportModuleOkListener() {
        }

        @Override
        public void receive(Object object, NotifyImportModuleOk notifyImportModuleOk) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifyNewModuleOkListener
    implements EventListener<NotifyNewModuleOk> {
        protected NotifyNewModuleOkListener() {
        }

        @Override
        public void receive(Object object, NotifyNewModuleOk notifyNewModuleOk) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifyOpenModuleOkListener
    implements EventListener<NotifyOpenModuleOk> {
        protected NotifyOpenModuleOkListener() {
        }

        @Override
        public void receive(Object object, final NotifyOpenModuleOk notifyOpenModuleOk) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow moduleManagerWindow = ModuleManagerWindow.getInstance();
                    moduleManagerWindow.addModule(notifyOpenModuleOk.lr.module);
                    moduleManagerWindow.setWaitCursor(false);
                }
            });
        }
    }

    public static class NotifySaveFileOk
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final File file;

        public NotifySaveFileOk(File file) {
            this.file = file;
        }
    }

    public static class NotifyOpenModuleFailed
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;
        public final Throwable thrown;

        public NotifyOpenModuleFailed(LaunchRequest launchRequest, Throwable throwable) {
            super(launchRequest);
            this.thrown = throwable;
        }
    }

    public static class NotifyImportModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyImportModuleOk(LaunchRequest launchRequest) {
            super(launchRequest);
        }
    }

    public static class NotifyNewModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyNewModuleOk(LaunchRequest launchRequest) {
            super(launchRequest);
        }
    }

    public static class NotifyOpenModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyOpenModuleOk(LaunchRequest launchRequest) {
            super(launchRequest);
        }
    }

    protected static abstract class LaunchRequestMessage
    extends SimpleIPCMessage {
        protected final LaunchRequest lr;

        public LaunchRequestMessage(LaunchRequest launchRequest) {
            this.lr = launchRequest;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LaunchTask
    extends SwingWorker<Void, Void> {
        protected final int id = nextId.getAndIncrement();
        protected final LaunchRequest lr;
        protected ServerSocket serverSocket;
        protected Socket clientSocket;
        protected IPCMessenger ipc;

        protected LaunchTask() {
            this.lr = new LaunchRequest(AbstractLaunchAction.this.lr);
            this.serverSocket = null;
            this.clientSocket = null;
            this.ipc = null;
        }

        public Void doInBackground() throws InterruptedException, IOException {
            Object object;
            String[] stringArray;
            String string;
            Object object2;
            Object object4;
            Object object5;
            Object object6;
            String string2;
            if (this.lr.module != null) {
                logger.info("Loading module file {}", (Object)this.lr.module.getAbsolutePath());
                String string22 = this.lr.module.getAbsolutePath();
                ModuleMetaData moduleMetaData = new ModuleMetaData(new ZipFile(string22));
                string2 = DigestUtils.shaHex((String)(moduleMetaData.getName() + "_" + moduleMetaData.getVersion()));
                object6 = new File(Info.getConfDir(), "tiles/" + string2);
                object5 = new TilingHandler(string22, (File)object6, new Dimension(256, 256), PHYS_MEMORY, nextId.getAndIncrement());
                try {
                    ((TilingHandler)object5).sliceTiles();
                }
                catch (CancellationException cancellationException) {
                    this.cancel(true);
                    return null;
                }
                object4 = new ExtensionsManager(this.lr.module);
                for (File object32 : ((ExtensionsManager)object4).getActiveExtensions()) {
                    object2 = new TilingHandler(object32.getAbsolutePath(), (File)object6, new Dimension(256, 256), PHYS_MEMORY, nextId.getAndIncrement());
                    try {
                        ((TilingHandler)object2).sliceTiles();
                    }
                    catch (CancellationException stringArray2) {
                        this.cancel(true);
                        return null;
                    }
                }
            }
            if (this.lr.game != null) {
                logger.info("Loading game file {}", (Object)this.lr.game.getAbsolutePath());
            }
            if (this.lr.importFile != null) {
                logger.info("Importing module file {}", (Object)this.lr.importFile.getAbsolutePath());
            }
            int n = 256;
            int n2 = 512;
            string2 = null;
            if (this.lr.module != null) {
                object6 = MetaDataFactory.buildMetaData(this.lr.module);
                if (object6 == null) {
                    ErrorDialog.show("Error.invalid_vassal_file", this.lr.module.getAbsolutePath());
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                    return null;
                }
                if (object6 instanceof ModuleMetaData) {
                    string2 = ((ModuleMetaData)object6).getName();
                    logger.info("Loading module {}", (Object)string2);
                    object5 = new ReadOnlyPrefs(string2);
                    n = this.getHeapSize((ReadOnlyPrefs)object5, "initialHeap", 256);
                    n2 = this.getHeapSize((ReadOnlyPrefs)object5, "maximumHeap", 512);
                }
            } else if (this.lr.importFile != null) {
                object6 = Prefs.getGlobalPrefs();
                n = this.getHeapSize((Prefs)object6, "initialHeap", 256);
                n2 = this.getHeapSize((Prefs)object6, "maximumHeap", 512);
            }
            if (n2 > PHYS_MEMORY) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            } else if (n2 < 128) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_small", 128));
            } else if (n < 64) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_small", 64));
            } else if (n > n2) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_large", 64));
            }
            object6 = InetAddress.getByName(null);
            this.serverSocket = new ServerSocket(0, 0, (InetAddress)object6);
            int n3 = this.serverSocket.getLocalPort();
            object4 = new ArrayList<String>();
            ((ArrayList)object4).add(Info.javaBinPath);
            ((ArrayList)object4).add("");
            ((ArrayList)object4).add("");
            ((ArrayList)object4).add("-DVASSAL.id=" + this.id);
            ((ArrayList)object4).add("-DVASSAL.port=" + n3);
            String string3 = System.getProperty("user.home");
            if (string3 != null) {
                ((ArrayList)object4).add("-Duser.home=" + (String)string3);
            }
            if ((string = System.getProperty("user.dir")) != null) {
                ((ArrayList)object4).add("-Duser.dir=" + string);
            }
            if ((object2 = System.getProperty("VASSAL.home")) != null) {
                ((ArrayList)object4).add("-DVASSAL.home=" + (String)object2);
            }
            ((ArrayList)object4).add("-cp");
            ((ArrayList)object4).add(System.getProperty("java.class.path"));
            if (SystemUtils.IS_OS_MAC_OSX) {
                stringArray = string2 != null && string2.length() > 0 ? string2 : "Unnamed module";
                object = new File(Info.getBaseDir(), "Contents/Resources/VASSAL.icns").getAbsolutePath();
                ((ArrayList)object4).add("-Xdock:name=" + (String)stringArray);
                ((ArrayList)object4).add("-Xdock:icon=" + (String)object);
                ((ArrayList)object4).add("-Dapple.awt.graphics.UseQuartz=false");
            } else if (SystemUtils.IS_OS_WINDOWS && Boolean.TRUE.equals(stringArray = (Boolean)Prefs.getGlobalPrefs().getValue("disableD3d"))) {
                ((ArrayList)object4).add("-Dsun.java2d.d3d=false");
            }
            ((ArrayList)object4).add(AbstractLaunchAction.this.entryPoint);
            ((ArrayList)object4).addAll(Arrays.asList(this.lr.toArgs()));
            stringArray = ((ArrayList)object4).toArray(new String[((ArrayList)object4).size()]);
            stringArray[1] = "-Xms" + n + "M";
            stringArray[2] = "-Xmx" + n2 + "M";
            object = new ProcessLauncher().launch(stringArray);
            try {
                ((ProcessWrapper)object).future.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException executionException) {
                this.cancel(true);
                return null;
            }
            catch (ExecutionException timeoutException) {
                logger.error("", (Throwable)timeoutException);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            if (((ProcessWrapper)object).future.isDone()) {
                stringArray[1] = "-Xms64M";
                stringArray[2] = "-Xmx128M";
                object = new ProcessLauncher().launch(stringArray);
                try {
                    ((ProcessWrapper)object).future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException timeoutException) {
                    logger.error("", (Throwable)timeoutException);
                }
                catch (TimeoutException executionException) {
                    // empty catch block
                }
                if (((ProcessWrapper)object).future.isDone()) {
                    throw new IOException("failed to start child process");
                }
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            }
            this.clientSocket = this.serverSocket.accept();
            this.ipc = new IPCMessenger(this.clientSocket);
            this.ipc.addEventListener(NotifyOpenModuleOk.class, new NotifyOpenModuleOkListener());
            this.ipc.addEventListener(NotifyNewModuleOk.class, new NotifyNewModuleOkListener());
            this.ipc.addEventListener(NotifyImportModuleOk.class, new NotifyImportModuleOkListener());
            this.ipc.addEventListener(NotifyOpenModuleFailed.class, new NotifyOpenModuleFailedListener());
            this.ipc.addEventListener(NotifySaveFileOk.class, new NotifySaveFileOkListener());
            this.ipc.start();
            children.add(this.ipc);
            try {
                ((ProcessWrapper)object).future.get();
            }
            catch (ExecutionException executionException) {
                logger.error("", (Throwable)executionException);
            }
            return null;
        }

        protected int getHeapSize(ReadOnlyPrefs readOnlyPrefs, String string, int n) {
            String string2 = readOnlyPrefs.getStoredValue(string);
            if (string2 == null) {
                return n;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        protected int getHeapSize(Prefs prefs, String string, int n) {
            Object object = prefs.getValue(string);
            if (object == null) {
                return n;
            }
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException cancellationException) {
                ModuleManagerWindow.getInstance().setWaitCursor(false);
            }
            catch (InterruptedException interruptedException) {
                ErrorDialog.bug(interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof IOException) {
                    ErrorDialog.showDetails(executionException, ThrowableUtils.getStackTrace(executionException), "Error.socket_error", new Object[0]);
                } else {
                    ErrorDialog.bug(executionException);
                }
            }
            finally {
                IOUtils.closeQuietly((Socket)this.clientSocket);
                IOUtils.closeQuietly((ServerSocket)this.serverSocket);
                children.remove(this.ipc);
            }
        }
    }
}

