/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogUtils {
    private static final Set<Object> disabled = Collections.synchronizedSet(new HashSet());
    private static final ExecutorService ex = Executors.newSingleThreadExecutor();

    private DialogUtils() {
    }

    public static boolean isDisabled(Object object) {
        return disabled.contains(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDisabled(Object object, boolean bl) {
        Set<Object> set = disabled;
        synchronized (set) {
            boolean bl2 = DialogUtils.isDisabled(object);
            if (bl2) {
                if (!bl) {
                    disabled.remove(object);
                }
            } else if (bl) {
                disabled.add(object);
            }
            return bl2;
        }
    }

    public static Future<?> enqueue(final Runnable runnable) {
        return ex.submit(new Runnable(){

            public void run() {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    ErrorDialog.bug(interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorDialog.bug(invocationTargetException);
                }
            }
        });
    }
}

