/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ImportMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.launch.EditModuleAction;
import VASSAL.launch.ModuleEditorWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.FileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Module;
import VASSAL.tools.imports.adc2.MapBoard;
import VASSAL.tools.imports.adc2.SymbolSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportAction
extends EditModuleAction {
    private static final long serialVersionUID = 1L;
    private static final String[] EXTENSIONS = new String[]{".ops", ".map", ".set"};
    private static final String[] DESCRIPTIONS = new String[]{"ADC2 Game Module", "ADC2 Map Board", "ADC2 Symbol Set"};
    private static final Class<?>[] IMPORTERS = new Class[]{ADC2Module.class, MapBoard.class, SymbolSet.class};

    public ImportAction(Component component) {
        super(component);
        this.putValue("Name", Resources.getString("Editor.import_module"));
    }

    public static FileChooser getFileChooser(Component component) {
        FileChooser fileChooser = FileChooser.createFileChooser(component, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        fileChooser.resetChoosableFileFilters();
        for (int i = IMPORTERS.length - 1; i >= 0; --i) {
            fileChooser.addChoosableFileFilter(new ExtensionFileFilter(DESCRIPTIONS[i] + " (*" + EXTENSIONS[i].toLowerCase() + ";*" + EXTENSIONS[i].toUpperCase() + ")", new String[]{EXTENSIONS[i]}));
        }
        return fileChooser;
    }

    public static Class<?> getImporterClass(File file) throws IOException {
        int n;
        int[] nArray = new int[IMPORTERS.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        String string = '.' + Importer.getExtension(file.getName());
        for (n = 0; n < EXTENSIONS.length; ++n) {
            if (EXTENSIONS[n].compareToIgnoreCase(string) != 0) continue;
            nArray[0] = n;
            nArray[n] = 0;
            break;
        }
        for (n = 0; n < nArray.length; ++n) {
            try {
                if (!((Importer)IMPORTERS[nArray[n]].newInstance()).isValidImportFile(file)) continue;
                return IMPORTERS[nArray[n]];
            }
            catch (InstantiationException instantiationException) {
                ErrorDialog.bug(instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorDialog.bug(illegalAccessException);
            }
        }
        return null;
    }

    @Override
    public void performAction(ActionEvent actionEvent) throws IOException {
        File file;
        this.actionCancelled = true;
        this.fc.resetChoosableFileFilters();
        for (int i = IMPORTERS.length - 1; i >= 0; --i) {
            this.fc.addChoosableFileFilter(new ExtensionFileFilter(DESCRIPTIONS[i] + " (*" + EXTENSIONS[i].toLowerCase() + ";*" + EXTENSIONS[i].toUpperCase() + ")", new String[]{EXTENSIONS[i]}));
        }
        if (this.fc.showOpenDialog() == 0 && (file = this.fc.getSelectedFile()) != null && file.exists()) {
            this.loadModule(file);
            this.actionCancelled = false;
        }
    }

    @Override
    public void loadModule(File file) throws IOException {
        Class<?> clazz = ImportAction.getImporterClass(file);
        if (clazz == null) {
            throw new FileFormatException("Unrecognized file format");
        }
        BasicModule basicModule = new BasicModule(new ArchiveWriter((String)null));
        GameModule.init(basicModule);
        try {
            Importer importer = (Importer)clazz.newInstance();
            importer.importFile(this, file);
            importer.writeToArchive();
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorDialog.bug(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            ErrorDialog.bug(instantiationException);
        }
        basicModule.getFrame().setVisible(true);
        new ModuleEditorWindow(basicModule).setVisible(true);
    }

    public File getCaseInsensitiveFile(File file, File file2, boolean bl, FileFilter fileFilter) {
        Object object;
        if (file.exists()) {
            return file;
        }
        String string = Importer.getFileName(file.getName());
        File file3 = file.getParentFile();
        if (file3 != null && (object = file3.listFiles()) != null) {
            for (File file4 : object) {
                if (!file4.getName().equalsIgnoreCase(string)) continue;
                return file4;
            }
        }
        if (file2 != null && (object = file2.getParentFile().listFiles()) != null) {
            for (File file4 : object) {
                if (!file4.getName().equalsIgnoreCase(string)) continue;
                return file4;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this.comp, "Unable to locate file:\n" + file.getPath() + "\nPlease locate it in the following dialog.", "File Warning", 2);
            if (this.fc == null) {
                this.fc = ImportAction.getFileChooser(this.comp);
            }
            this.fc.resetChoosableFileFilters();
            if (fileFilter != null) {
                this.fc.setFileFilter(fileFilter);
            }
            this.fc.setSelectedFile(new File(file.getName()));
            if (this.fc.showOpenDialog() == 0 && ((File)(object = this.fc.getSelectedFile())).exists()) {
                return object;
            }
        }
        return null;
    }

    public static AbstractMetaData buildMetaData(File file) {
        try {
            if (ImportAction.getImporterClass(file) == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return new ImportMetaData();
    }
}

