/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CRYPTO)

#include "JSCryptoKeyPair.h"

#include "JSCryptoKey.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CRYPTO)

template<> CryptoKeyPair convertDictionary<CryptoKeyPair>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CryptoKeyPair result;
    JSValue privateKeyValue;
    if (isNullOrUndefined)
        privateKeyValue = jsUndefined();
    else {
        privateKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "privateKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!privateKeyValue.isUndefined()) {
        result.privateKey = convert<IDLInterface<CryptoKey>>(lexicalGlobalObject, privateKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue publicKeyValue;
    if (isNullOrUndefined)
        publicKeyValue = jsUndefined();
    else {
        publicKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!publicKeyValue.isUndefined()) {
        result.publicKey = convert<IDLInterface<CryptoKey>>(lexicalGlobalObject, publicKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CryptoKeyPair& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLInterface<CryptoKey>::isNullValue(dictionary.privateKey)) {
        auto privateKeyValue = toJS<IDLInterface<CryptoKey>>(lexicalGlobalObject, globalObject, throwScope, IDLInterface<CryptoKey>::extractValueFromNullable(dictionary.privateKey));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "privateKey"_s), privateKeyValue);
    }
    if (!IDLInterface<CryptoKey>::isNullValue(dictionary.publicKey)) {
        auto publicKeyValue = toJS<IDLInterface<CryptoKey>>(lexicalGlobalObject, globalObject, throwScope, IDLInterface<CryptoKey>::extractValueFromNullable(dictionary.publicKey));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "publicKey"_s), publicKeyValue);
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CRYPTO)
