/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStencilFaceState.h"

#include "JSDOMConvertEnumeration.h"
#include "JSGPUCompareFunction.h"
#include "JSGPUStencilOperation.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUStencilFaceState convertDictionary<GPUStencilFaceState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUStencilFaceState result;
    JSValue compareValue;
    if (isNullOrUndefined)
        compareValue = jsUndefined();
    else {
        compareValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compare"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compareValue.isUndefined()) {
        result.compare = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, compareValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.compare = GPUCompareFunction::Always;
    JSValue depthFailOpValue;
    if (isNullOrUndefined)
        depthFailOpValue = jsUndefined();
    else {
        depthFailOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthFailOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!depthFailOpValue.isUndefined()) {
        result.depthFailOp = convert<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, depthFailOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.depthFailOp = GPUStencilOperation::Keep;
    JSValue failOpValue;
    if (isNullOrUndefined)
        failOpValue = jsUndefined();
    else {
        failOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "failOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!failOpValue.isUndefined()) {
        result.failOp = convert<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, failOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.failOp = GPUStencilOperation::Keep;
    JSValue passOpValue;
    if (isNullOrUndefined)
        passOpValue = jsUndefined();
    else {
        passOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "passOp"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!passOpValue.isUndefined()) {
        result.passOp = convert<IDLEnumeration<GPUStencilOperation>>(lexicalGlobalObject, passOpValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.passOp = GPUStencilOperation::Keep;
    return result;
}

} // namespace WebCore
