/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStorageTextureBindingLayout.h"

#include "JSDOMConvertEnumeration.h"
#include "JSGPUStorageTextureAccess.h"
#include "JSGPUTextureFormat.h"
#include "JSGPUTextureViewDimension.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUStorageTextureBindingLayout convertDictionary<GPUStorageTextureBindingLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUStorageTextureBindingLayout result;
    JSValue accessValue;
    if (isNullOrUndefined)
        accessValue = jsUndefined();
    else {
        accessValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "access"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!accessValue.isUndefined()) {
        result.access = convert<IDLEnumeration<GPUStorageTextureAccess>>(lexicalGlobalObject, accessValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.access = GPUStorageTextureAccess::WriteOnly;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUStorageTextureBindingLayout", "GPUTextureFormat");
        return { };
    }
    JSValue viewDimensionValue;
    if (isNullOrUndefined)
        viewDimensionValue = jsUndefined();
    else {
        viewDimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewDimension"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewDimensionValue.isUndefined()) {
        result.viewDimension = convert<IDLEnumeration<GPUTextureViewDimension>>(lexicalGlobalObject, viewDimensionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.viewDimension = GPUTextureViewDimension::_2d;
    return result;
}

} // namespace WebCore
