/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_CONTROLS_SCRIPT)

#include "JSMediaControlsHost.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioTrack.h"
#include "JSAudioTrackList.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLElement.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>

#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && ENABLE(MODERN_MEDIA_CONTROLS)
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertJSON.h"
#include "JSVoidCallback.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaControlsHost::DeviceType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("airplay"),
        MAKE_STATIC_STRING_IMPL("tvout"),
    };
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::None) == 0, "MediaControlsHost::DeviceType::None is not 0 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::Airplay) == 1, "MediaControlsHost::DeviceType::Airplay is not 1 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::Tvout) == 2, "MediaControlsHost::DeviceType::Tvout is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaControlsHost::DeviceType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaControlsHost::DeviceType> parseEnumerationFromString<MediaControlsHost::DeviceType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaControlsHost::DeviceType> mappings[] = {
        { "airplay", MediaControlsHost::DeviceType::Airplay },
        { "none", MediaControlsHost::DeviceType::None },
        { "tvout", MediaControlsHost::DeviceType::Tvout },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaControlsHost::DeviceType> parseEnumeration<MediaControlsHost::DeviceType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaControlsHost::DeviceType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<MediaControlsHost::DeviceType>()
{
    return "\"none\", \"airplay\", \"tvout\"";
}

#if ENABLE(MODERN_MEDIA_CONTROLS)

String convertEnumerationToString(MediaControlsHost::SourceType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("file"),
        MAKE_STATIC_STRING_IMPL("hls"),
        MAKE_STATIC_STRING_IMPL("media-source"),
        MAKE_STATIC_STRING_IMPL("managed-media-source"),
        MAKE_STATIC_STRING_IMPL("media-stream"),
        MAKE_STATIC_STRING_IMPL("live-stream"),
        MAKE_STATIC_STRING_IMPL("stored-stream"),
    };
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::File) == 0, "MediaControlsHost::SourceType::File is not 0 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::HLS) == 1, "MediaControlsHost::SourceType::HLS is not 1 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::MediaSource) == 2, "MediaControlsHost::SourceType::MediaSource is not 2 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::ManagedMediaSource) == 3, "MediaControlsHost::SourceType::ManagedMediaSource is not 3 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::MediaStream) == 4, "MediaControlsHost::SourceType::MediaStream is not 4 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::LiveStream) == 5, "MediaControlsHost::SourceType::LiveStream is not 5 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::SourceType::StoredStream) == 6, "MediaControlsHost::SourceType::StoredStream is not 6 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaControlsHost::SourceType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaControlsHost::SourceType> parseEnumerationFromString<MediaControlsHost::SourceType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaControlsHost::SourceType> mappings[] = {
        { "file", MediaControlsHost::SourceType::File },
        { "hls", MediaControlsHost::SourceType::HLS },
        { "live-stream", MediaControlsHost::SourceType::LiveStream },
        { "managed-media-source", MediaControlsHost::SourceType::ManagedMediaSource },
        { "media-source", MediaControlsHost::SourceType::MediaSource },
        { "media-stream", MediaControlsHost::SourceType::MediaStream },
        { "stored-stream", MediaControlsHost::SourceType::StoredStream },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaControlsHost::SourceType> parseEnumeration<MediaControlsHost::SourceType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaControlsHost::SourceType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<MediaControlsHost::SourceType>()
{
    return "\"file\", \"hls\", \"media-source\", \"managed-media-source\", \"media-stream\", \"live-stream\", \"stored-stream\"";
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_displayNameForTrack);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_setSelectedTextTrack);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_updateTextTrackContainer);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_enteredFullscreen);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_exitedFullscreen);
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_generateUUID);
#if ENABLE(MODERN_MEDIA_CONTROLS)
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_base64StringForIconNameAndType);
#endif
#if ENABLE(MODERN_MEDIA_CONTROLS)
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_formattedStringForDuration);
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && ENABLE(MODERN_MEDIA_CONTROLS)
static JSC_DECLARE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_showMediaControlsContextMenu);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_layoutTraitsClassName);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_mediaControlsContainerClassName);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_brightness);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaControlsHost_brightness);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_captionMenuOffItem);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_captionMenuAutomaticItem);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_captionDisplayMode);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_textTrackContainer);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_allowsInlineMediaPlayback);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_supportsFullscreen);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_isVideoLayerInline);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_userGestureRequired);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_isInMediaDocument);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_shouldForceControlsDisplay);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_externalDeviceDisplayName);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_externalDeviceType);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_controlsDependOnPageScaleFactor);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaControlsHost_controlsDependOnPageScaleFactor);
#if ENABLE(MODERN_MEDIA_CONTROLS)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_sourceType);
#endif
#if ENABLE(MODERN_MEDIA_CONTROLS)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaControlsHost_shadowRootCSSText);
#endif

class JSMediaControlsHostPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaControlsHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaControlsHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaControlsHostPrototype>(vm)) JSMediaControlsHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaControlsHostPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaControlsHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaControlsHostPrototype, JSMediaControlsHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMediaControlsHostPrototypeTableValues[] =
{
    { "layoutTraitsClassName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_layoutTraitsClassName, 0 } },
    { "mediaControlsContainerClassName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_mediaControlsContainerClassName, 0 } },
    { "brightness"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_brightness, setJSMediaControlsHost_brightness } },
    { "captionMenuOffItem"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_captionMenuOffItem, 0 } },
    { "captionMenuAutomaticItem"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_captionMenuAutomaticItem, 0 } },
    { "captionDisplayMode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_captionDisplayMode, 0 } },
    { "textTrackContainer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_textTrackContainer, 0 } },
    { "allowsInlineMediaPlayback"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_allowsInlineMediaPlayback, 0 } },
    { "supportsFullscreen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_supportsFullscreen, 0 } },
    { "isVideoLayerInline"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_isVideoLayerInline, 0 } },
    { "userGestureRequired"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_userGestureRequired, 0 } },
    { "isInMediaDocument"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_isInMediaDocument, 0 } },
    { "shouldForceControlsDisplay"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_shouldForceControlsDisplay, 0 } },
    { "externalDeviceDisplayName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_externalDeviceDisplayName, 0 } },
    { "externalDeviceType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_externalDeviceType, 0 } },
    { "controlsDependOnPageScaleFactor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_controlsDependOnPageScaleFactor, setJSMediaControlsHost_controlsDependOnPageScaleFactor } },
#if ENABLE(MODERN_MEDIA_CONTROLS)
    { "sourceType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_sourceType, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MODERN_MEDIA_CONTROLS)
    { "shadowRootCSSText"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaControlsHost_shadowRootCSSText, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "sortedTrackListForMenu"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu, 1 } },
    { "displayNameForTrack"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_displayNameForTrack, 1 } },
    { "setSelectedTextTrack"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_setSelectedTextTrack, 1 } },
    { "updateTextTrackContainer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_updateTextTrackContainer, 0 } },
    { "enteredFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_enteredFullscreen, 0 } },
    { "exitedFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_exitedFullscreen, 0 } },
    { "generateUUID"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_generateUUID, 0 } },
#if ENABLE(MODERN_MEDIA_CONTROLS)
    { "base64StringForIconNameAndType"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_base64StringForIconNameAndType, 2 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MODERN_MEDIA_CONTROLS)
    { "formattedStringForDuration"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_formattedStringForDuration, 1 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && ENABLE(MODERN_MEDIA_CONTROLS)
    { "showMediaControlsContextMenu"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaControlsHostPrototypeFunction_showMediaControlsContextMenu, 3 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSMediaControlsHostPrototype::s_info = { "MediaControlsHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaControlsHostPrototype) };

void JSMediaControlsHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaControlsHost::info(), JSMediaControlsHostPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && ENABLE(MODERN_MEDIA_CONTROLS)
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().mediaControlsContextMenusEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "showMediaControlsContextMenu"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaControlsHost::s_info = { "MediaControlsHost"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaControlsHost) };

JSMediaControlsHost::JSMediaControlsHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaControlsHost>&& impl)
    : JSDOMWrapper<MediaControlsHost>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaControlsHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaControlsHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaControlsHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaControlsHostPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaControlsHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaControlsHost>(vm, globalObject);
}

void JSMediaControlsHost::destroy(JSC::JSCell* cell)
{
    JSMediaControlsHost* thisObject = static_cast<JSMediaControlsHost*>(cell);
    thisObject->JSMediaControlsHost::~JSMediaControlsHost();
}

static inline JSValue jsMediaControlsHost_layoutTraitsClassNameGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.layoutTraitsClassName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_layoutTraitsClassName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_layoutTraitsClassNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_mediaControlsContainerClassNameGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.mediaControlsContainerClassName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_mediaControlsContainerClassName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_mediaControlsContainerClassNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_brightnessGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.brightness())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_brightness, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_brightnessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaControlsHost_brightnessSetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBrightness(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaControlsHost_brightness, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::set<setJSMediaControlsHost_brightnessSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaControlsHost_captionMenuOffItemGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.captionMenuOffItem())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_captionMenuOffItem, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_captionMenuOffItemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_captionMenuAutomaticItemGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.captionMenuAutomaticItem())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_captionMenuAutomaticItem, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_captionMenuAutomaticItemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_captionDisplayModeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.captionDisplayMode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_captionDisplayMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_captionDisplayModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_textTrackContainerGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<HTMLElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.textTrackContainer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_textTrackContainer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_textTrackContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_allowsInlineMediaPlaybackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.allowsInlineMediaPlayback())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_allowsInlineMediaPlayback, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_allowsInlineMediaPlaybackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_supportsFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsFullscreen())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_supportsFullscreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_supportsFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_isVideoLayerInlineGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isVideoLayerInline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_isVideoLayerInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_isVideoLayerInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_userGestureRequiredGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.userGestureRequired())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_userGestureRequired, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_userGestureRequiredGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_isInMediaDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isInMediaDocument())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_isInMediaDocument, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_isInMediaDocumentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_shouldForceControlsDisplayGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shouldForceControlsDisplay())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_shouldForceControlsDisplay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_shouldForceControlsDisplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_externalDeviceDisplayNameGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.externalDeviceDisplayName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_externalDeviceDisplayName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_externalDeviceDisplayNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_externalDeviceTypeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaControlsHost::DeviceType>>(lexicalGlobalObject, throwScope, impl.externalDeviceType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_externalDeviceType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_externalDeviceTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaControlsHost_controlsDependOnPageScaleFactorGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.controlsDependOnPageScaleFactor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_controlsDependOnPageScaleFactor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_controlsDependOnPageScaleFactorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaControlsHost_controlsDependOnPageScaleFactorSetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setControlsDependOnPageScaleFactor(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaControlsHost_controlsDependOnPageScaleFactor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::set<setJSMediaControlsHost_controlsDependOnPageScaleFactorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(MODERN_MEDIA_CONTROLS)
static inline JSValue jsMediaControlsHost_sourceTypeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<MediaControlsHost::SourceType>>>(lexicalGlobalObject, throwScope, impl.sourceType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_sourceType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_sourceTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MODERN_MEDIA_CONTROLS)
static inline JSValue jsMediaControlsHost_shadowRootCSSTextGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowRootCSSText())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaControlsHost_shadowRootCSSText, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHost_shadowRootCSSTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto trackList = convert<IDLInterface<TextTrackList>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "trackList", "MediaControlsHost", "sortedTrackListForMenu", "TextTrackList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<TextTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.sortedTrackListForMenu(*trackList))));
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto trackList = convert<IDLInterface<AudioTrackList>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "trackList", "MediaControlsHost", "sortedTrackListForMenu", "AudioTrackList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<AudioTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.sortedTrackListForMenu(*trackList))));
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_sortedTrackListForMenuOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSTextTrackList>())
            RELEASE_AND_RETURN(throwScope, (jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioTrackList>())
            RELEASE_AND_RETURN(throwScope, (jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_sortedTrackListForMenu, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_sortedTrackListForMenuOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "sortedTrackListForMenu");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_displayNameForTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto track = convert<IDLNullable<IDLUnion<IDLInterface<TextTrack>, IDLInterface<AudioTrack>>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.displayNameForTrack(WTFMove(track)))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_displayNameForTrack, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_displayNameForTrackBody>(*lexicalGlobalObject, *callFrame, "displayNameForTrack");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_setSelectedTextTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto track = convert<IDLNullable<IDLInterface<TextTrack>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "MediaControlsHost", "setSelectedTextTrack", "TextTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setSelectedTextTrack(WTFMove(track)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_setSelectedTextTrack, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_setSelectedTextTrackBody>(*lexicalGlobalObject, *callFrame, "setSelectedTextTrack");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_updateTextTrackContainerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.updateTextTrackContainer(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_updateTextTrackContainer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_updateTextTrackContainerBody>(*lexicalGlobalObject, *callFrame, "updateTextTrackContainer");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_enteredFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.enteredFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_enteredFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_enteredFullscreenBody>(*lexicalGlobalObject, *callFrame, "enteredFullscreen");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_exitedFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.exitedFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_exitedFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_exitedFullscreenBody>(*lexicalGlobalObject, *callFrame, "exitedFullscreen");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_generateUUIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.generateUUID())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_generateUUID, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_generateUUIDBody>(*lexicalGlobalObject, *callFrame, "generateUUID");
}

#if ENABLE(MODERN_MEDIA_CONTROLS)
static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_base64StringForIconNameAndTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto iconName = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto iconType = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.base64StringForIconNameAndType(WTFMove(iconName), WTFMove(iconType)))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_base64StringForIconNameAndType, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_base64StringForIconNameAndTypeBody>(*lexicalGlobalObject, *callFrame, "base64StringForIconNameAndType");
}

#endif

#if ENABLE(MODERN_MEDIA_CONTROLS)
static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_formattedStringForDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto durationInSeconds = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.formattedStringForDuration(WTFMove(durationInSeconds)))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_formattedStringForDuration, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_formattedStringForDurationBody>(*lexicalGlobalObject, *callFrame, "formattedStringForDuration");
}

#endif

#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && ENABLE(MODERN_MEDIA_CONTROLS)
static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunction_showMediaControlsContextMenuBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto target = convert<IDLInterface<HTMLElement>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "MediaControlsHost", "showMediaControlsContextMenu", "HTMLElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto options = convert<IDLJSON>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "callback", "MediaControlsHost", "showMediaControlsContextMenu"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.showMediaControlsContextMenu(*target, WTFMove(options), callback.releaseNonNull()))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaControlsHostPrototypeFunction_showMediaControlsContextMenu, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunction_showMediaControlsContextMenuBody>(*lexicalGlobalObject, *callFrame, "showMediaControlsContextMenu");
}

#endif

JSC::GCClient::IsoSubspace* JSMediaControlsHost::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaControlsHost, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaControlsHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaControlsHost = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaControlsHost.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaControlsHost = std::forward<decltype(space)>(space); }
    );
}

void JSMediaControlsHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaControlsHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaControlsHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaControlsHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaControlsHost = static_cast<JSMediaControlsHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaControlsHost->wrapped(), jsMediaControlsHost);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaControlsHost@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17MediaControlsHostE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaControlsHost>&& impl)
{

    if constexpr (std::is_polymorphic_v<MediaControlsHost>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaControlsHost@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17MediaControlsHostE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaControlsHost has subclasses. If MediaControlsHost has subclasses that get passed
        // to toJS() we currently require MediaControlsHost you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<MediaControlsHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaControlsHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaControlsHost* JSMediaControlsHost::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaControlsHost*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_CONTROLS_SCRIPT)
