/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCookieStoreDeleteOptions.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CookieStoreDeleteOptions>> convertDictionary<CookieStoreDeleteOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CookieStoreDeleteOptions result;
    JSValue domainValue;
    if (isNullOrUndefined)
        domainValue = jsUndefined();
    else {
        domainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "domain"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto domainConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(lexicalGlobalObject, domainValue, [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (UNLIKELY(domainConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.domain = domainConversionResult.releaseReturnValue();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "CookieStoreDeleteOptions"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLUSVString>(lexicalGlobalObject, nameValue);
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue pathValue;
    if (isNullOrUndefined)
        pathValue = jsUndefined();
    else {
        pathValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "path"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto pathConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, pathValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { "/"_s }; });
    if (UNLIKELY(pathConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.path = pathConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
