/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeType.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMPlugin.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMMimeTypeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMimeType_type);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMimeType_suffixes);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMimeType_description);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMMimeType_enabledPlugin);

class JSDOMMimeTypePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMimeTypePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMimeTypePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMimeTypePrototype>(vm)) JSDOMMimeTypePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMimeTypePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMimeTypePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMimeTypePrototype, JSDOMMimeTypePrototype::Base);

using JSDOMMimeTypeDOMConstructor = JSDOMConstructorNotConstructable<JSDOMMimeType>;

template<> const ClassInfo JSDOMMimeTypeDOMConstructor::s_info = { "MimeType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeTypeDOMConstructor) };

template<> JSValue JSDOMMimeTypeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMimeTypeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MimeType"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMMimeType::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMimeTypeConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMimeType_type, 0 } },
    { "suffixes"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMimeType_suffixes, 0 } },
    { "description"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMimeType_description, 0 } },
    { "enabledPlugin"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMMimeType_enabledPlugin, 0 } },
};

const ClassInfo JSDOMMimeTypePrototype::s_info = { "MimeType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeTypePrototype) };

void JSDOMMimeTypePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMimeType::info(), JSDOMMimeTypePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMMimeType::s_info = { "MimeType"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeType) };

JSDOMMimeType::JSDOMMimeType(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMimeType>&& impl)
    : JSDOMWrapper<DOMMimeType>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMMimeType>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMMimeType::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMMimeTypePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMMimeTypePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMMimeType::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMimeType>(vm, globalObject);
}

JSValue JSDOMMimeType::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeDOMConstructor, DOMConstructorID::DOMMimeType>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMMimeType::destroy(JSC::JSCell* cell)
{
    JSDOMMimeType* thisObject = static_cast<JSDOMMimeType*>(cell);
    thisObject->JSDOMMimeType::~JSDOMMimeType();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMimeTypeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMimeTypePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMimeType::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMMimeType_typeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMimeType_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeType_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMimeType_suffixesGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.suffixes())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMimeType_suffixes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeType_suffixesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMimeType_descriptionGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.description())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMimeType_description, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeType_descriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMMimeType_enabledPluginGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMPlugin>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.enabledPlugin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMMimeType_enabledPlugin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeType_enabledPluginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDOMMimeType::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMMimeType, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMMimeType.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMMimeType = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMMimeType.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMMimeType = std::forward<decltype(space)>(space); }
    );
}

void JSDOMMimeType::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMimeType*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMMimeTypeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsDOMMimeType = jsCast<JSDOMMimeType*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsDOMMimeType->wrapped().navigator());
    if (!owner)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSDOMMimeTypeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMimeType = static_cast<JSDOMMimeType*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMMimeType->protectedWrapped().ptr(), jsDOMMimeType);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMimeType@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11DOMMimeTypeE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, DOMMimeType>, void>> static inline void verifyVTable(DOMMimeType* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMMimeType@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11DOMMimeTypeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMMimeType has subclasses. If DOMMimeType has subclasses that get passed
        // to toJS() we currently require DOMMimeType you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMimeType>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMMimeType>(impl.ptr());
#endif
    return createWrapper<DOMMimeType>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMimeType& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMMimeType* JSDOMMimeType::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMimeType*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
