/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemDirectoryReader.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemEntriesCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryReaderPrototypeFunction_readEntries);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemDirectoryReaderConstructor);

class JSFileSystemDirectoryReaderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemDirectoryReaderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemDirectoryReaderPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryReaderPrototype>(vm)) JSFileSystemDirectoryReaderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryReaderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemDirectoryReaderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryReaderPrototype, JSFileSystemDirectoryReaderPrototype::Base);

using JSFileSystemDirectoryReaderDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemDirectoryReader>;

template<> const ClassInfo JSFileSystemDirectoryReaderDOMConstructor::s_info = { "FileSystemDirectoryReader"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReaderDOMConstructor) };

template<> JSValue JSFileSystemDirectoryReaderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileSystemDirectoryReaderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemDirectoryReader"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemDirectoryReader::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFileSystemDirectoryReaderPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemDirectoryReaderConstructor, 0 } },
    { "readEntries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryReaderPrototypeFunction_readEntries, 1 } },
};

const ClassInfo JSFileSystemDirectoryReaderPrototype::s_info = { "FileSystemDirectoryReader"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReaderPrototype) };

void JSFileSystemDirectoryReaderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemDirectoryReader::info(), JSFileSystemDirectoryReaderPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemDirectoryReader::s_info = { "FileSystemDirectoryReader"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReader) };

JSFileSystemDirectoryReader::JSFileSystemDirectoryReader(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemDirectoryReader>&& impl)
    : JSDOMWrapper<FileSystemDirectoryReader>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemDirectoryReader>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemDirectoryReader::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemDirectoryReaderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFileSystemDirectoryReaderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemDirectoryReader::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemDirectoryReader>(vm, globalObject);
}

JSValue JSFileSystemDirectoryReader::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemDirectoryReaderDOMConstructor, DOMConstructorID::FileSystemDirectoryReader>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileSystemDirectoryReader::destroy(JSC::JSCell* cell)
{
    JSFileSystemDirectoryReader* thisObject = static_cast<JSFileSystemDirectoryReader*>(cell);
    thisObject->JSFileSystemDirectoryReader::~JSFileSystemDirectoryReader();
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemDirectoryReaderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryReaderPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemDirectoryReader::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryReaderPrototypeFunction_readEntriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryReader>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto successCallbackConversionResult = convert<IDLCallbackFunction<JSFileSystemEntriesCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback"_s, "FileSystemDirectoryReader"_s, "readEntries"_s); });
    if (UNLIKELY(successCallbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "FileSystemDirectoryReader"_s, "readEntries"_s); });
    if (UNLIKELY(errorCallbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.readEntries(*context, successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryReaderPrototypeFunction_readEntries, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryReader>::call<jsFileSystemDirectoryReaderPrototypeFunction_readEntriesBody>(*lexicalGlobalObject, *callFrame, "readEntries");
}

JSC::GCClient::IsoSubspace* JSFileSystemDirectoryReader::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemDirectoryReader, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemDirectoryReader.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemDirectoryReader = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemDirectoryReader.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemDirectoryReader = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemDirectoryReader::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemDirectoryReader*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemDirectoryReaderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemDirectoryReader = jsCast<JSFileSystemDirectoryReader*>(handle.slot()->asCell());
    auto& wrapped = jsFileSystemDirectoryReader->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemDirectoryReaderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemDirectoryReader = static_cast<JSFileSystemDirectoryReader*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemDirectoryReader->protectedWrapped().ptr(), jsFileSystemDirectoryReader);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileSystemDirectoryReader@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25FileSystemDirectoryReaderE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, FileSystemDirectoryReader>, void>> static inline void verifyVTable(FileSystemDirectoryReader* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FileSystemDirectoryReader@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25FileSystemDirectoryReaderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FileSystemDirectoryReader has subclasses. If FileSystemDirectoryReader has subclasses that get passed
        // to toJS() we currently require FileSystemDirectoryReader you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FileSystemDirectoryReader>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FileSystemDirectoryReader>(impl.ptr());
#endif
    return createWrapper<FileSystemDirectoryReader>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FileSystemDirectoryReader& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FileSystemDirectoryReader* JSFileSystemDirectoryReader::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileSystemDirectoryReader*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
