/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUStencilOperation.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUStencilOperation enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("keep"),
        MAKE_STATIC_STRING_IMPL("zero"),
        MAKE_STATIC_STRING_IMPL("replace"),
        MAKE_STATIC_STRING_IMPL("invert"),
        MAKE_STATIC_STRING_IMPL("increment-clamp"),
        MAKE_STATIC_STRING_IMPL("decrement-clamp"),
        MAKE_STATIC_STRING_IMPL("increment-wrap"),
        MAKE_STATIC_STRING_IMPL("decrement-wrap"),
    };
    static_assert(static_cast<size_t>(GPUStencilOperation::Keep) == 0, "GPUStencilOperation::Keep is not 0 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::Zero) == 1, "GPUStencilOperation::Zero is not 1 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::Replace) == 2, "GPUStencilOperation::Replace is not 2 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::Invert) == 3, "GPUStencilOperation::Invert is not 3 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::IncrementClamp) == 4, "GPUStencilOperation::IncrementClamp is not 4 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::DecrementClamp) == 5, "GPUStencilOperation::DecrementClamp is not 5 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::IncrementWrap) == 6, "GPUStencilOperation::IncrementWrap is not 6 as expected");
    static_assert(static_cast<size_t>(GPUStencilOperation::DecrementWrap) == 7, "GPUStencilOperation::DecrementWrap is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUStencilOperation enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUStencilOperation> parseEnumerationFromString<GPUStencilOperation>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUStencilOperation> mappings[] = {
        { "decrement-clamp", GPUStencilOperation::DecrementClamp },
        { "decrement-wrap", GPUStencilOperation::DecrementWrap },
        { "increment-clamp", GPUStencilOperation::IncrementClamp },
        { "increment-wrap", GPUStencilOperation::IncrementWrap },
        { "invert", GPUStencilOperation::Invert },
        { "keep", GPUStencilOperation::Keep },
        { "replace", GPUStencilOperation::Replace },
        { "zero", GPUStencilOperation::Zero },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUStencilOperation> parseEnumeration<GPUStencilOperation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUStencilOperation>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUStencilOperation>()
{
    return "\"keep\", \"zero\", \"replace\", \"invert\", \"increment-clamp\", \"decrement-clamp\", \"increment-wrap\", \"decrement-wrap\""_s;
}

} // namespace WebCore
