/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSNVShaderNoperspectiveInterpolation.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSNVShaderNoperspectiveInterpolationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNVShaderNoperspectiveInterpolationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNVShaderNoperspectiveInterpolationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNVShaderNoperspectiveInterpolationPrototype>(vm)) JSNVShaderNoperspectiveInterpolationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNVShaderNoperspectiveInterpolationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNVShaderNoperspectiveInterpolationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNVShaderNoperspectiveInterpolationPrototype, JSNVShaderNoperspectiveInterpolationPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSNVShaderNoperspectiveInterpolationPrototype::s_info = { "NVShaderNoperspectiveInterpolation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNVShaderNoperspectiveInterpolationPrototype) };

void JSNVShaderNoperspectiveInterpolationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNVShaderNoperspectiveInterpolation::s_info = { "NVShaderNoperspectiveInterpolation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNVShaderNoperspectiveInterpolation) };

JSNVShaderNoperspectiveInterpolation::JSNVShaderNoperspectiveInterpolation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NVShaderNoperspectiveInterpolation>&& impl)
    : JSDOMWrapper<NVShaderNoperspectiveInterpolation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NVShaderNoperspectiveInterpolation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNVShaderNoperspectiveInterpolation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNVShaderNoperspectiveInterpolationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNVShaderNoperspectiveInterpolationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNVShaderNoperspectiveInterpolation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNVShaderNoperspectiveInterpolation>(vm, globalObject);
}

void JSNVShaderNoperspectiveInterpolation::destroy(JSC::JSCell* cell)
{
    JSNVShaderNoperspectiveInterpolation* thisObject = static_cast<JSNVShaderNoperspectiveInterpolation*>(cell);
    thisObject->JSNVShaderNoperspectiveInterpolation::~JSNVShaderNoperspectiveInterpolation();
}

JSC::GCClient::IsoSubspace* JSNVShaderNoperspectiveInterpolation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNVShaderNoperspectiveInterpolation, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNVShaderNoperspectiveInterpolation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNVShaderNoperspectiveInterpolation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNVShaderNoperspectiveInterpolation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNVShaderNoperspectiveInterpolation = std::forward<decltype(space)>(space); }
    );
}

void JSNVShaderNoperspectiveInterpolation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNVShaderNoperspectiveInterpolation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNVShaderNoperspectiveInterpolationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsNVShaderNoperspectiveInterpolation = jsCast<JSNVShaderNoperspectiveInterpolation*>(handle.slot()->asCell());
    auto& owner = jsNVShaderNoperspectiveInterpolation->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsNVShaderNoperspectiveInterpolation"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSNVShaderNoperspectiveInterpolationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNVShaderNoperspectiveInterpolation = static_cast<JSNVShaderNoperspectiveInterpolation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNVShaderNoperspectiveInterpolation->protectedWrapped().ptr(), jsNVShaderNoperspectiveInterpolation);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NVShaderNoperspectiveInterpolation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore34NVShaderNoperspectiveInterpolationE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, NVShaderNoperspectiveInterpolation>, void>> static inline void verifyVTable(NVShaderNoperspectiveInterpolation* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NVShaderNoperspectiveInterpolation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore34NVShaderNoperspectiveInterpolationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NVShaderNoperspectiveInterpolation has subclasses. If NVShaderNoperspectiveInterpolation has subclasses that get passed
        // to toJS() we currently require NVShaderNoperspectiveInterpolation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NVShaderNoperspectiveInterpolation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NVShaderNoperspectiveInterpolation>(impl.ptr());
#endif
    return createWrapper<NVShaderNoperspectiveInterpolation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NVShaderNoperspectiveInterpolation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NVShaderNoperspectiveInterpolation* JSNVShaderNoperspectiveInterpolation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNVShaderNoperspectiveInterpolation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
