/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.util.LinkedList;
import java.util.List;

public class ArrayUtils {
    protected static final byte[] CASE_SENSITIVE = new byte[256];
    protected static final byte[] CASE_INSENSITIVE = new byte[256];
    public static final byte[] SKIP_WHITESPACE = new byte[256];
    public static final byte[] SKIP_NONWHITESPACE = new byte[256];
    protected static final byte[] zeroArr = new byte[0];

    protected ArrayUtils() {
    }

    public static int skip(byte[] skip, byte[] arr, int fIdx) {
        int arrLen = arr.length;
        while (fIdx < arrLen && skip[arr[fIdx] & 0xFF] == 1) {
            ++fIdx;
        }
        return fIdx;
    }

    public static boolean startsWith(byte[] subArr, byte[] arr) {
        boolean bRes = false;
        int lIdx = subArr.length - 1;
        if (lIdx < arr.length && subArr[0] == arr[0]) {
            while (lIdx > 0 && subArr[lIdx] == arr[lIdx]) {
                --lIdx;
            }
            bRes = lIdx == 0;
        }
        return bRes;
    }

    public static boolean startsWithIgnoreCase(byte[] subArr, byte[] arr) {
        boolean bRes = false;
        int lIdx = subArr.length - 1;
        if (lIdx < arr.length && CASE_INSENSITIVE[subArr[0]] == CASE_INSENSITIVE[arr[0]]) {
            while (lIdx > 0 && CASE_INSENSITIVE[subArr[lIdx]] == CASE_INSENSITIVE[arr[lIdx]]) {
                --lIdx;
            }
            bRes = lIdx == 0;
        }
        return bRes;
    }

    public static boolean equalsAt(byte[] subArr, byte[] arr, int fIdx) {
        boolean bRes = false;
        int lIdx = subArr.length - 1;
        int tIdx = fIdx + lIdx;
        if (tIdx < arr.length && subArr[0] == arr[fIdx]) {
            while (lIdx > 0 && subArr[lIdx] == arr[tIdx]) {
                --lIdx;
                --tIdx;
            }
            bRes = lIdx == 0;
        }
        return bRes;
    }

    public static boolean equalsAtIgnoreCase(byte[] subArr, byte[] arr, int fIdx) {
        boolean bRes = false;
        int lIdx = subArr.length - 1;
        int tIdx = fIdx + lIdx;
        if (tIdx < arr.length && CASE_INSENSITIVE[subArr[0] & 0xFF] == CASE_INSENSITIVE[arr[fIdx] & 0xFF]) {
            while (lIdx > 0 && CASE_INSENSITIVE[subArr[lIdx] & 0xFF] == CASE_INSENSITIVE[arr[tIdx] & 0xFF]) {
                --lIdx;
                --tIdx;
            }
            bRes = lIdx == 0;
        }
        return bRes;
    }

    public static int indexOf(byte[] subArr, byte[] arr, int fIdx) {
        int idx;
        block7: {
            int arrLen;
            int subArrLast;
            block6: {
                idx = -1;
                subArrLast = subArr.length - 1;
                arrLen = arr.length;
                if (subArrLast <= 0) break block6;
                for (int lIdx = fIdx + subArrLast; lIdx < arrLen && idx == -1; ++lIdx) {
                    if (subArr[0] == arr[fIdx]) {
                        int csIdx = subArrLast;
                        int caIdx = lIdx;
                        while (csIdx > 0 && subArr[csIdx] == arr[caIdx]) {
                            --csIdx;
                            --caIdx;
                        }
                        if (csIdx == 0) {
                            idx = fIdx;
                        }
                    }
                    ++fIdx;
                }
                break block7;
            }
            if (subArrLast != 0) break block7;
            while (fIdx < arrLen && idx == -1) {
                if (subArr[0] == arr[fIdx]) {
                    idx = fIdx;
                }
                ++fIdx;
            }
        }
        return idx;
    }

    public static int indexOfIgnoreCase(byte[] subArr, byte[] arr, int fIdx) {
        int idx;
        block7: {
            int arrLen;
            int subArrLast;
            block6: {
                idx = -1;
                subArrLast = subArr.length - 1;
                arrLen = arr.length;
                if (subArrLast <= 0) break block6;
                for (int lIdx = fIdx + subArrLast; lIdx < arrLen && idx == -1; ++lIdx) {
                    if (CASE_INSENSITIVE[subArr[0]] == CASE_INSENSITIVE[arr[fIdx]]) {
                        int csIdx = subArrLast;
                        int caIdx = lIdx;
                        while (csIdx > 0 && CASE_INSENSITIVE[subArr[csIdx]] == CASE_INSENSITIVE[arr[caIdx]]) {
                            --csIdx;
                            --caIdx;
                        }
                        if (csIdx == 0) {
                            idx = fIdx;
                        }
                    }
                    ++fIdx;
                }
                break block7;
            }
            if (subArrLast != 0) break block7;
            while (fIdx < arrLen && idx == -1) {
                if (CASE_INSENSITIVE[subArr[0]] == CASE_INSENSITIVE[arr[fIdx]]) {
                    idx = fIdx;
                }
                ++fIdx;
            }
        }
        return idx;
    }

    public static List<byte[]> split(byte[] arr, byte[] subArr, int fIdx, int tIdx) {
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int subArrLen = subArr.length;
        int subArrLast = subArrLen - 1;
        if (arr.length < tIdx) {
            tIdx = arr.length;
        }
        if (fIdx > tIdx) {
            throw new IllegalArgumentException("Reverse interval!");
        }
        int lIdx = fIdx + subArrLast;
        int pIdx = fIdx;
        if (subArrLast > 0) {
            byte[] tmpArr;
            while (lIdx < tIdx) {
                if (subArr[0] == arr[fIdx]) {
                    int csIdx = subArrLast;
                    int caIdx = lIdx;
                    while (csIdx > 0 && subArr[csIdx] == arr[caIdx]) {
                        --csIdx;
                        --caIdx;
                    }
                    if (csIdx == 0) {
                        tmpArr = new byte[fIdx - pIdx];
                        System.arraycopy(arr, pIdx, tmpArr, 0, tmpArr.length);
                        list.add(tmpArr);
                        lIdx += subArrLen;
                        pIdx = fIdx += subArrLen;
                        continue;
                    }
                    ++fIdx;
                    ++lIdx;
                    continue;
                }
                ++fIdx;
                ++lIdx;
            }
            if (pIdx < tIdx) {
                tmpArr = new byte[tIdx - pIdx];
                System.arraycopy(arr, pIdx, tmpArr, 0, tmpArr.length);
                list.add(tmpArr);
            }
        } else {
            byte[] tmpArr;
            while (fIdx < tIdx) {
                if (subArr[0] == arr[fIdx]) {
                    tmpArr = new byte[fIdx - pIdx];
                    System.arraycopy(arr, pIdx, tmpArr, 0, tmpArr.length);
                    list.add(tmpArr);
                    pIdx = ++fIdx;
                    continue;
                }
                ++fIdx;
            }
            if (pIdx < tIdx) {
                tmpArr = new byte[tIdx - pIdx];
                System.arraycopy(arr, pIdx, tmpArr, 0, tmpArr.length);
                list.add(tmpArr);
            }
        }
        if (pIdx == fIdx) {
            list.add(zeroArr);
        }
        return list;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ArrayUtils.CASE_SENSITIVE[i] = (byte)i;
            ArrayUtils.CASE_INSENSITIVE[i] = (byte)Character.toLowerCase(i);
            ArrayUtils.SKIP_WHITESPACE[i] = 0;
            ArrayUtils.SKIP_NONWHITESPACE[i] = 1;
        }
        ArrayUtils.SKIP_WHITESPACE[32] = 1;
        ArrayUtils.SKIP_WHITESPACE[9] = 1;
        ArrayUtils.SKIP_WHITESPACE[13] = 1;
        ArrayUtils.SKIP_WHITESPACE[10] = 1;
        ArrayUtils.SKIP_NONWHITESPACE[32] = 0;
        ArrayUtils.SKIP_NONWHITESPACE[9] = 0;
        ArrayUtils.SKIP_NONWHITESPACE[13] = 0;
        ArrayUtils.SKIP_NONWHITESPACE[10] = 0;
    }
}

