/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public final class IPAddressParser {
    private static final String IP_ADDRESS_REG_EXP = "([0-9a-fA-F]{0,4}:){0,6}(([0-9a-fA-F]{0,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3}))";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("([0-9a-fA-F]{0,4}:){0,6}(([0-9a-fA-F]{0,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\\.){3}[0-9]{1,3}))");

    public static InetAddress getAddress(String ipAddress) {
        boolean isValid = ipAddress == null ? false : IP_ADDRESS_PATTERN.matcher(ipAddress).matches();
        InetAddress inetAddress = null;
        if (isValid) {
            try {
                inetAddress = InetAddress.getByName(ipAddress);
            }
            catch (UnknownHostException e) {
                isValid = false;
            }
        }
        return isValid ? inetAddress : null;
    }

    protected IPAddressParser() {
    }
}

