/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;

public class PreemptiveBasicAuthConfigurer
extends HttpClientConfigurer {
    public static final String SYS_PROP_HTTP_CLIENT_CONFIG = "solr.httpclient.config";
    public static final String SYS_PROP_BASIC_AUTH_CREDENTIALS = "basicauth";
    private static SolrParams defaultParams;

    public static void setDefaultSolrParams(SolrParams params) {
        defaultParams = params;
    }

    @Override
    public void configure(DefaultHttpClient httpClient, SolrParams config) {
        config = SolrParams.wrapDefaults(config, defaultParams);
        String basicAuthUser = config.get("httpBasicAuthUser");
        String basicAuthPass = config.get("httpBasicAuthPassword");
        if (basicAuthUser == null || basicAuthPass == null) {
            throw new IllegalArgumentException("username & password must be specified with " + this.getClass().getName());
        }
        super.configure(httpClient, config);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth((AuthScheme)new BasicScheme()), 0);
    }

    static {
        String credentials = System.getProperty(SYS_PROP_BASIC_AUTH_CREDENTIALS);
        String configFile = System.getProperty(SYS_PROP_HTTP_CLIENT_CONFIG);
        if (credentials != null && configFile != null) {
            throw new RuntimeException("Basic authentication credentials passed via a configuration file as well as java system property. Please choose one mechanism!");
        }
        if (credentials != null) {
            List<String> ss = StrUtils.splitSmart(credentials, ':');
            if (ss.size() != 2) {
                throw new RuntimeException("Please provide 'basicauth' in the 'user:password' format");
            }
            Properties defaultProps = new Properties();
            defaultProps.setProperty("httpBasicAuthUser", ss.get(0));
            defaultProps.setProperty("httpBasicAuthPassword", ss.get(1));
            defaultParams = new MapSolrParams(new HashMap<Object, Object>(defaultProps));
        }
        if (configFile != null) {
            try {
                Properties defaultProps = new Properties();
                defaultProps.load(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                defaultParams = new MapSolrParams(new HashMap<Object, Object>(defaultProps));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read the Http client config file", e);
            }
        }
    }
}

