/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.LoadInstruction;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.StoreInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;

public abstract class SPARCAtomicLoadStoreInstruction
extends SPARCInstruction
implements LoadInstruction,
StoreInstruction {
    protected final SPARCRegisterIndirectAddress addr;
    protected final SPARCRegister rd;
    protected final Register[] regs = new Register[1];
    protected final String description;

    public SPARCAtomicLoadStoreInstruction(String name, SPARCRegisterIndirectAddress addr, SPARCRegister rd) {
        super(name);
        this.addr = addr;
        this.rd = rd;
        this.regs[0] = rd;
        this.description = this.initDescription();
    }

    private String initDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.addr.toString());
        buf.append(comma);
        buf.append(this.rd.toString());
        return buf.toString();
    }

    @Override
    public Address getLoadSource() {
        return this.addr;
    }

    @Override
    public Address getStoreDestination() {
        return this.addr;
    }

    @Override
    public Register[] getLoadDestinations() {
        return this.regs;
    }

    @Override
    public Register[] getStoreSources() {
        return this.regs;
    }

    @Override
    public boolean isLoad() {
        return true;
    }

    @Override
    public boolean isStore() {
        return true;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        return this.description;
    }
}

