/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ByteToCharISO8859_1;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.JISAutoDetect;

public class ByteToCharJISAutoDetect
extends ByteToCharConverter {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;
    private static final byte[] maskTable1 = JISAutoDetect.getByteMask1();
    private static final byte[] maskTable2 = JISAutoDetect.getByteMask2();
    private static final int SS2 = 142;
    private static final int SS3 = 143;
    private String SJISName = CharacterEncoding.getSJISName();
    private String EUCJPName = CharacterEncoding.getEUCJPName();
    private String convName = null;
    private ByteToCharConverter detectedConv = null;
    private ByteToCharConverter defaultConv = new ByteToCharISO8859_1();

    public ByteToCharJISAutoDetect() {
        this.defaultConv.subChars = this.subChars;
        this.defaultConv.subMode = this.subMode;
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        this.badInputLength = 0;
        if (this.detectedConv != null) {
            return this.detectedConv.flush(output, outStart, outEnd);
        }
        return this.defaultConv.flush(output, outStart, outEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int num = 0;
        this.charOff = outOff;
        this.byteOff = inOff;
        try {
            if (this.detectedConv == null) {
                int euckana = 0;
                int ss2count = 0;
                byte firstmask = 0;
                byte secondmask = 0;
                boolean nonAsciiFound = false;
                for (int cnt = inOff; cnt < inEnd; ++cnt) {
                    firstmask = 0;
                    secondmask = 0;
                    int byte1 = input[cnt] & 0xFF;
                    if (byte1 == 27) {
                        this.convName = "ISO2022JP";
                        break;
                    }
                    if (!nonAsciiFound && byte1 < 128) {
                        if (this.charOff >= outEnd) {
                            throw new ConversionBufferFullException();
                        }
                        output[this.charOff++] = (char)byte1;
                        ++this.byteOff;
                        ++num;
                        continue;
                    }
                    nonAsciiFound = true;
                    firstmask = maskTable1[byte1];
                    if (byte1 == 142) {
                        ++ss2count;
                    }
                    if (firstmask == 0) continue;
                    if (cnt + 1 < inEnd) {
                        int byte2;
                        int mask;
                        if ((mask = firstmask & (secondmask = maskTable2[byte2 = input[++cnt] & 0xFF])) == 1) {
                            this.convName = this.EUCJPName;
                            break;
                        }
                        if (mask == 2 || mask == 4 || JISAutoDetect.canBeSJIS1B(firstmask) && secondmask == 0) {
                            this.convName = this.SJISName;
                            break;
                        }
                        if (byte1 == 143 && JISAutoDetect.canBeEUCJP(secondmask)) {
                            if (cnt + 1 < inEnd) {
                                int nextbyte = input[cnt + 1] & 0xFF;
                                if (!JISAutoDetect.canBeEUCJP(maskTable2[nextbyte])) {
                                    this.convName = this.SJISName;
                                }
                            } else {
                                this.convName = this.SJISName;
                            }
                        }
                        if (!JISAutoDetect.canBeEUCKana(firstmask, secondmask)) continue;
                        ++euckana;
                        continue;
                    }
                    if ((firstmask & 4) == 0) continue;
                    this.convName = this.SJISName;
                    break;
                }
                if (nonAsciiFound && this.convName == null) {
                    this.convName = euckana > 1 || ss2count > 1 ? this.EUCJPName : this.SJISName;
                }
                if (this.convName != null) {
                    try {
                        this.detectedConv = ByteToCharConverter.getConverter((String)this.convName);
                        this.detectedConv.subChars = this.subChars;
                        this.detectedConv.subMode = this.subMode;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.detectedConv = null;
                        this.convName = null;
                    }
                }
            }
        }
        catch (ConversionBufferFullException bufferFullException) {
            throw bufferFullException;
        }
        catch (Exception e) {
            this.detectedConv = this.defaultConv;
        }
        if (this.byteOff == inEnd) {
            return num;
        }
        if (this.detectedConv != null) {
            try {
                num += this.detectedConv.convert(input, inOff + num, inEnd, output, outOff + num, outEnd);
            }
            finally {
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
            }
        }
        try {
            num += this.defaultConv.convert(input, inOff + num, inEnd, output, outOff + num, outEnd);
        }
        finally {
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
        }
        return num;
    }

    public void reset() {
        if (this.detectedConv != null) {
            this.detectedConv.reset();
            this.detectedConv = null;
            this.convName = null;
        } else {
            this.defaultConv.reset();
        }
        this.byteOff = 0;
        this.charOff = 0;
    }

    public String getCharacterEncoding() {
        return "JISAutoDetect";
    }

    public String toString() {
        String s = this.getCharacterEncoding();
        s = this.detectedConv != null ? s + "[" + this.detectedConv.getCharacterEncoding() + "]" : s + "[unknown]";
        return s;
    }
}

