/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.ISCII91;

public class CharToByteISCII91
extends CharToByteConverter {
    private static final byte NO_CHAR = -1;
    private static final byte[] directMapTable = ISCII91.getEncoderMappingTable();
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';

    public boolean canConvert(char ch) {
        return ch >= '\u0900' && ch <= '\u097f' || ch == '\u200d' || ch == '\u200c' || ch >= '\u0000' && ch <= '\u007f';
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inStart, int inEnd, byte[] output, int outStart, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        this.charOff = inStart;
        this.byteOff = outStart;
        while (true) {
            block22: {
                if (this.charOff >= inEnd) {
                    return this.byteOff - outStart;
                }
                int inputChar = input[this.charOff];
                int index = Integer.MIN_VALUE;
                boolean isSurrogatePair = false;
                if (inputChar >= 0 && inputChar <= 127) {
                    if (this.byteOff >= outEnd) {
                        throw new ConversionBufferFullException();
                    }
                    output[this.byteOff++] = (byte)inputChar;
                } else {
                    if (inputChar == 8204) {
                        inputChar = 2381;
                    } else if (inputChar == 8205) {
                        inputChar = 2364;
                    }
                    if (inputChar >= 2304 && inputChar <= 2431) {
                        index = (inputChar - 2304) * 2;
                    } else if (inputChar >= 55296 && inputChar <= 56319) {
                        char nextChar;
                        if (this.charOff < inEnd - 1 && (nextChar = input[this.charOff]) >= '\udc00' && nextChar <= '\udfff') {
                            ++this.charOff;
                            isSurrogatePair = true;
                        }
                        if (!isSurrogatePair) {
                            this.badInputLength = 1;
                            throw new MalformedInputException();
                        }
                    } else if (inputChar >= 56320 && inputChar <= 57343) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    if (index == Integer.MIN_VALUE || directMapTable[index] == -1) {
                        if (this.subMode) {
                            if (this.byteOff + this.subBytes.length >= outEnd) {
                                throw new ConversionBufferFullException();
                            }
                            System.arraycopy(this.subBytes, 0, output, this.byteOff, this.subBytes.length);
                            this.byteOff += this.subBytes.length;
                            break block22;
                        } else {
                            this.badInputLength = isSurrogatePair ? 2 : 1;
                            throw new UnknownCharacterException();
                        }
                    }
                    if (this.byteOff >= outEnd) {
                        throw new ConversionBufferFullException();
                    }
                    output[this.byteOff++] = directMapTable[index++];
                    if (directMapTable[index] != -1) {
                        if (this.byteOff >= outEnd) {
                            throw new ConversionBufferFullException();
                        }
                        output[this.byteOff++] = directMapTable[index];
                    }
                }
            }
            ++this.charOff;
        }
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException, ConversionBufferFullException {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public String getCharacterEncoding() {
        return "ISCII91";
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

