/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class CharToByteISO2022
extends CharToByteConverter {
    private final byte ISO_ESC = (byte)27;
    private final byte ISO_SI = (byte)15;
    private final byte ISO_SO = (byte)14;
    private final byte ISO_SS2_7 = (byte)78;
    private final byte ISO_SS3_7 = (byte)79;
    private final byte SS2 = (byte)-114;
    private final byte P2 = (byte)-94;
    private final byte P3 = (byte)-93;
    private final byte MSB = (byte)-128;
    protected final byte maximumDesignatorLength = (byte)4;
    protected String SODesignator;
    protected String SS2Designator = null;
    protected String SS3Designator = null;
    protected CharToByteConverter codeConverter;
    private boolean shiftout = false;
    private boolean SODesDefined = false;
    private boolean SS2DesDefined = false;
    private boolean SS3DesDefined = false;
    private boolean newshiftout = false;
    private boolean newSODesDefined = false;
    private boolean newSS2DesDefined = false;
    private boolean newSS3DesDefined = false;

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        this.reset();
        return 0;
    }

    public void reset() {
        this.shiftout = false;
        this.SODesDefined = false;
        this.SS2DesDefined = false;
        this.SS3DesDefined = false;
        this.charOff = 0;
        this.byteOff = 0;
    }

    public boolean canConvert(char ch) {
        if (ch < '\u0080') {
            return true;
        }
        return this.codeConverter.canConvert(ch);
    }

    private int unicodeToNative(char unicode, byte[] ebyte) {
        int converted;
        int index = 0;
        byte[] convByte = new byte[this.codeConverter.getMaxBytesPerChar()];
        char[] convChar = new char[]{unicode};
        try {
            converted = this.codeConverter.convert(convChar, 0, 1, convByte, 0, this.codeConverter.getMaxBytesPerChar());
        }
        catch (Exception e) {
            return -1;
        }
        if (converted == 2) {
            if (!this.SODesDefined) {
                this.newSODesDefined = true;
                ebyte[0] = 27;
                byte[] tmpByte = this.SODesignator.getBytes();
                System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                index = tmpByte.length + 1;
            }
            if (!this.shiftout) {
                this.newshiftout = true;
                ebyte[index++] = 14;
            }
            ebyte[index++] = (byte)(convByte[0] & 0x7F);
            ebyte[index++] = (byte)(convByte[1] & 0x7F);
        } else {
            byte[] tmpByte;
            if (convByte[0] == -114 && convByte[1] == -94) {
                if (!this.SS2DesDefined) {
                    this.newSS2DesDefined = true;
                    ebyte[0] = 27;
                    tmpByte = this.SS2Designator.getBytes();
                    System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                    index = tmpByte.length + 1;
                }
                ebyte[index++] = 27;
                ebyte[index++] = 78;
                ebyte[index++] = (byte)(convByte[2] & 0x7F);
                ebyte[index++] = (byte)(convByte[3] & 0x7F);
            }
            if (convByte[0] == -114 && convByte[1] == 163) {
                if (!this.SS3DesDefined) {
                    this.newSS3DesDefined = true;
                    ebyte[0] = 27;
                    tmpByte = this.SS3Designator.getBytes();
                    System.arraycopy(tmpByte, 0, ebyte, 1, tmpByte.length);
                    index = tmpByte.length + 1;
                }
                ebyte[index++] = 27;
                ebyte[index++] = 79;
                ebyte[index++] = (byte)(convByte[2] & 0x7F);
                ebyte[index++] = (byte)(convByte[3] & 0x7F);
            }
        }
        return index;
    }

    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        byte[] tmpbuf = new byte[this.getMaxBytesPerChar()];
        this.byteOff = outOff;
        this.newshiftout = this.shiftout;
        this.newSODesDefined = this.SODesDefined;
        this.newSS2DesDefined = this.SS2DesDefined;
        this.newSS3DesDefined = this.SS3DesDefined;
        this.charOff = inOff;
        while (this.charOff < inEnd) {
            int outputSize;
            byte[] outputByte = tmpbuf;
            if (input[this.charOff] < '\u0080') {
                if (this.shiftout) {
                    this.newshiftout = false;
                    outputSize = 2;
                    outputByte[0] = 15;
                    outputByte[1] = (byte)(input[this.charOff] & 0x7F);
                } else {
                    outputSize = 1;
                    outputByte[0] = (byte)(input[this.charOff] & 0x7F);
                }
                if (input[this.charOff] == '\n') {
                    this.newSODesDefined = false;
                    this.newSS2DesDefined = false;
                    this.newSS3DesDefined = false;
                }
            } else {
                outputSize = this.unicodeToNative(input[this.charOff], outputByte);
            }
            if (outputSize == -1) {
                if (this.subMode) {
                    if (!this.newSODesDefined) {
                        this.newSODesDefined = !this.newSODesDefined;
                        outputByte[0] = 14;
                        outputByte[1] = 63;
                        outputSize = 2;
                    } else {
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                    }
                } else {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
            }
            if (outEnd - this.byteOff < outputSize) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.shiftout = this.newshiftout;
            this.SODesDefined = this.newSODesDefined;
            this.SS2DesDefined = this.newSS2DesDefined;
            this.SS3DesDefined = this.newSS3DesDefined;
            ++this.charOff;
        }
        return this.byteOff - outOff;
    }
}

