/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    public AccessControlContext delegatedContext(AccessControlContext authenticatedACC, Subject delegatedSubject, boolean removeCallerContext) throws SecurityException {
        if (System.getSecurityManager() != null && authenticatedACC == null) {
            throw new SecurityException("Illegal AccessControlContext: null");
        }
        Collection<Principal> ps = SubjectDelegator.getSubjectPrincipals(delegatedSubject);
        final ArrayList<SubjectDelegationPermission> permissions = new ArrayList<SubjectDelegationPermission>(ps.size());
        for (Principal p : ps) {
            String pname = p.getClass().getName() + "." + p.getName();
            permissions.add(new SubjectDelegationPermission(pname));
        }
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Permission sdp : permissions) {
                    AccessController.checkPermission(sdp);
                }
                return null;
            }
        };
        AccessController.doPrivileged(action, authenticatedACC);
        return this.getDelegatedAcc(delegatedSubject, removeCallerContext);
    }

    private AccessControlContext getDelegatedAcc(Subject delegatedSubject, boolean removeCallerContext) {
        if (removeCallerContext) {
            return JMXSubjectDomainCombiner.getDomainCombinerContext(delegatedSubject);
        }
        return JMXSubjectDomainCombiner.getContext(delegatedSubject);
    }

    public static synchronized boolean checkRemoveCallerContext(Subject subject) {
        try {
            for (Principal p : SubjectDelegator.getSubjectPrincipals(subject)) {
                String pname = p.getClass().getName() + "." + p.getName();
                SubjectDelegationPermission sdp = new SubjectDelegationPermission(pname);
                AccessController.checkPermission(sdp);
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    private static Collection<Principal> getSubjectPrincipals(Subject subject) {
        if (subject.isReadOnly()) {
            return subject.getPrincipals();
        }
        List<Principal> principals = Arrays.asList(subject.getPrincipals().toArray(new Principal[0]));
        return Collections.unmodifiableList(principals);
    }
}

