/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.sasl.DefaultCallbackHandler;
import com.sun.jndi.ldap.sasl.SaslInputStream;
import com.sun.jndi.ldap.sasl.SaslOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public final class LdapSasl {
    private static final String SASL_CALLBACK = "java.naming.security.sasl.callback";
    private static final String SASL_AUTHZ_ID = "java.naming.security.sasl.authorizationId";
    private static final String SASL_REALM = "java.naming.security.sasl.realm";
    private static final int LDAP_SUCCESS = 0;
    private static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    private static final byte[] NO_BYTES = new byte[0];

    private LdapSasl() {
    }

    public static LdapResult saslBind(LdapClient clnt, Connection conn, String server, String dn, Object pw, String authMech, Hashtable<?, ?> env, Control[] bindCtls) throws IOException, NamingException {
        CallbackHandler cbh;
        SaslClient saslClnt = null;
        boolean cleanupHandler = false;
        CallbackHandler callbackHandler = cbh = env != null ? (CallbackHandler)env.get(SASL_CALLBACK) : null;
        if (cbh == null) {
            cbh = new DefaultCallbackHandler(dn, pw, (String)env.get(SASL_REALM));
            cleanupHandler = true;
        }
        String authzId = env != null ? (String)env.get(SASL_AUTHZ_ID) : null;
        String[] mechs = LdapSasl.getSaslMechanismNames(authMech);
        try {
            saslClnt = Sasl.createSaslClient(mechs, authzId, "ldap", server, env, cbh);
            if (saslClnt == null) {
                throw new AuthenticationNotSupportedException(authMech);
            }
            String mechName = saslClnt.getMechanismName();
            byte[] response = saslClnt.hasInitialResponse() ? saslClnt.evaluateChallenge(NO_BYTES) : null;
            LdapResult res = clnt.ldapBind(null, response, bindCtls, mechName, true);
            while (!(saslClnt.isComplete() || res.status != 14 && res.status != 0)) {
                response = saslClnt.evaluateChallenge(res.serverCreds != null ? res.serverCreds : NO_BYTES);
                if (res.status == 0) {
                    if (response == null) break;
                    throw new AuthenticationException("SASL client generated response after success");
                }
                res = clnt.ldapBind(null, response, bindCtls, mechName, true);
            }
            if (res.status == 0) {
                if (!saslClnt.isComplete()) {
                    throw new AuthenticationException("SASL authentication not complete despite server claims");
                }
                String qop = (String)saslClnt.getNegotiatedProperty("javax.security.sasl.qop");
                if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                    SaslInputStream newIn = new SaslInputStream(saslClnt, conn.inStream);
                    SaslOutputStream newOut = new SaslOutputStream(saslClnt, conn.outStream);
                    conn.replaceStreams(newIn, newOut);
                } else {
                    saslClnt.dispose();
                }
            }
            LdapResult ldapResult = res;
            return ldapResult;
        }
        catch (SaslException e) {
            AuthenticationException ne = new AuthenticationException(authMech);
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            if (cleanupHandler) {
                ((DefaultCallbackHandler)cbh).clearPassword();
            }
        }
    }

    private static String[] getSaslMechanismNames(String str) {
        StringTokenizer parser = new StringTokenizer(str);
        Vector<String> mechs = new Vector<String>(10);
        while (parser.hasMoreTokens()) {
            mechs.addElement(parser.nextToken());
        }
        String[] mechNames = new String[mechs.size()];
        for (int i = 0; i < mechs.size(); ++i) {
            mechNames[i] = (String)mechs.elementAt(i);
        }
        return mechNames;
    }
}

