/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.script.Invocable;
import javax.script.ScriptException;
import sun.reflect.misc.ReflectUtil;

public class InterfaceImplementor {
    private Invocable engine;

    public InterfaceImplementor(Invocable engine) {
        this.engine = engine;
    }

    public <T> T getInterface(Object thiz, Class<T> iface) throws ScriptException {
        if (iface == null || !iface.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        if (!this.isImplemented(thiz, iface)) {
            return null;
        }
        if (System.getSecurityManager() != null && !Modifier.isPublic(iface.getModifiers())) {
            throw new SecurityException("attempt to implement non-public interface");
        }
        ReflectUtil.checkPackageAccess(iface.getName());
        AccessControlContext accCtxt = AccessController.getContext();
        return iface.cast(Proxy.newProxyInstance(InterfaceImplementor.getLoaderForProxy(iface), new Class[]{iface}, new InterfaceImplementorInvocationHandler(thiz, accCtxt)));
    }

    protected boolean isImplemented(Object thiz, Class<?> iface) {
        return true;
    }

    protected Object convertResult(Method method, Object res) throws ScriptException {
        return res;
    }

    protected Object[] convertArguments(Method method, Object[] args) throws ScriptException {
        return args;
    }

    private static ClassLoader getLoaderForProxy(Class<?> iface) {
        ClassLoader loader = iface.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private final class InterfaceImplementorInvocationHandler
    implements InvocationHandler {
        private Object thiz;
        private AccessControlContext accCtxt;

        public InterfaceImplementorInvocationHandler(Object thiz, AccessControlContext accCtxt) {
            this.thiz = thiz;
            this.accCtxt = accCtxt;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            args = InterfaceImplementor.this.convertArguments(method, args);
            final Method m = method;
            final Object[] a = args;
            Object result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (InterfaceImplementorInvocationHandler.this.thiz == null) {
                        return InterfaceImplementor.this.engine.invokeFunction(m.getName(), a);
                    }
                    return InterfaceImplementor.this.engine.invokeMethod(InterfaceImplementorInvocationHandler.this.thiz, m.getName(), a);
                }
            }, this.accCtxt);
            return InterfaceImplementor.this.convertResult(method, result);
        }
    }
}

