/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType defaultSelection;
    private DestinationType destination;
    private DialogType dialog;
    private String fileName;
    private int fromPage;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multipleDocumentHandling;
    private int[][] pageRanges;
    private int prFirst;
    private int prLast;
    private String printer;
    private SidesType sides;
    private int toPage;

    public JobAttributes() {
        this.setCopiesToDefault();
        this.setDefaultSelection(DefaultSelectionType.ALL);
        this.setDestination(DestinationType.PRINTER);
        this.setDialog(DialogType.NATIVE);
        this.setMaxPage(Integer.MAX_VALUE);
        this.setMinPage(1);
        this.setMultipleDocumentHandlingToDefault();
        this.setSidesToDefault();
    }

    public JobAttributes(JobAttributes obj) {
        this.set(obj);
    }

    public JobAttributes(int copies, DefaultSelectionType defaultSelection, DestinationType destination, DialogType dialog, String fileName, int maxPage, int minPage, MultipleDocumentHandlingType multipleDocumentHandling, int[][] pageRanges, String printer, SidesType sides) {
        this.setCopies(copies);
        this.setDefaultSelection(defaultSelection);
        this.setDestination(destination);
        this.setDialog(dialog);
        this.setFileName(fileName);
        this.setMaxPage(maxPage);
        this.setMinPage(minPage);
        this.setMultipleDocumentHandling(multipleDocumentHandling);
        this.setPageRanges(pageRanges);
        this.setPrinter(printer);
        this.setSides(sides);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void set(JobAttributes obj) {
        this.copies = obj.copies;
        this.defaultSelection = obj.defaultSelection;
        this.destination = obj.destination;
        this.dialog = obj.dialog;
        this.fileName = obj.fileName;
        this.fromPage = obj.fromPage;
        this.maxPage = obj.maxPage;
        this.minPage = obj.minPage;
        this.multipleDocumentHandling = obj.multipleDocumentHandling;
        this.pageRanges = obj.pageRanges;
        this.prFirst = obj.prFirst;
        this.prLast = obj.prLast;
        this.printer = obj.printer;
        this.sides = obj.sides;
        this.toPage = obj.toPage;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException("Invalid value for attribute copies");
        }
        this.copies = copies;
    }

    public void setCopiesToDefault() {
        this.setCopies(1);
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(DefaultSelectionType defaultSelection) {
        if (defaultSelection == null) {
            throw new IllegalArgumentException("Invalid value for attribute defaultSelection");
        }
        this.defaultSelection = defaultSelection;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Invalid value for attribute destination");
        }
        this.destination = destination;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException("Invalid value for attribute dialog");
        }
        this.dialog = dialog;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.toPage != 0) {
            return this.getMinPage();
        }
        if (this.pageRanges != null) {
            return this.prFirst;
        }
        return this.getMinPage();
    }

    public void setFromPage(int fromPage) {
        if (fromPage <= 0 || this.toPage != 0 && fromPage > this.toPage || fromPage < this.minPage || fromPage > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute fromPage");
        }
        this.fromPage = fromPage;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int maxPage) {
        if (maxPage <= 0 || maxPage < this.minPage) {
            throw new IllegalArgumentException("Invalid value for attribute maxPage");
        }
        this.maxPage = maxPage;
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int minPage) {
        if (minPage <= 0 || minPage > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute minPage");
        }
        this.minPage = minPage;
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multipleDocumentHandling;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandling) {
        if (multipleDocumentHandling == null) {
            throw new IllegalArgumentException("Invalid value for attribute multipleDocumentHandling");
        }
        this.multipleDocumentHandling = multipleDocumentHandling;
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.setMultipleDocumentHandling(MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
    }

    public int[][] getPageRanges() {
        if (this.pageRanges != null) {
            int[][] copy = new int[this.pageRanges.length][2];
            for (int i = 0; i < this.pageRanges.length; ++i) {
                copy[i][0] = this.pageRanges[i][0];
                copy[i][1] = this.pageRanges[i][1];
            }
            return copy;
        }
        if (this.fromPage != 0 || this.toPage != 0) {
            int fromPage = this.getFromPage();
            int toPage = this.getToPage();
            return new int[][]{{fromPage, toPage}};
        }
        int minPage = this.getMinPage();
        return new int[][]{{minPage, minPage}};
    }

    public void setPageRanges(int[][] pageRanges) {
        String xcp = "Invalid value for attribute pageRanges";
        int first = 0;
        int last = 0;
        if (pageRanges == null) {
            throw new IllegalArgumentException(xcp);
        }
        for (int i = 0; i < pageRanges.length; ++i) {
            if (pageRanges[i] == null || pageRanges[i].length != 2 || pageRanges[i][0] <= last || pageRanges[i][1] < pageRanges[i][0]) {
                throw new IllegalArgumentException(xcp);
            }
            last = pageRanges[i][1];
            if (first != 0) continue;
            first = pageRanges[i][0];
        }
        if (first < this.minPage || last > this.maxPage) {
            throw new IllegalArgumentException(xcp);
        }
        int[][] copy = new int[pageRanges.length][2];
        for (int i = 0; i < pageRanges.length; ++i) {
            copy[i][0] = pageRanges[i][0];
            copy[i][1] = pageRanges[i][1];
        }
        this.pageRanges = copy;
        this.prFirst = first;
        this.prLast = last;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sides) {
        if (sides == null) {
            throw new IllegalArgumentException("Invalid value for attribute sides");
        }
        this.sides = sides;
    }

    public void setSidesToDefault() {
        this.setSides(SidesType.ONE_SIDED);
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.prLast;
        }
        return this.getMinPage();
    }

    public void setToPage(int toPage) {
        if (toPage <= 0 || this.fromPage != 0 && toPage < this.fromPage || toPage < this.minPage || toPage > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute toPage");
        }
        this.toPage = toPage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobAttributes)) {
            return false;
        }
        JobAttributes rhs = (JobAttributes)obj;
        if (this.fileName == null ? rhs.fileName != null : !this.fileName.equals(rhs.fileName)) {
            return false;
        }
        if (this.pageRanges == null) {
            if (rhs.pageRanges != null) {
                return false;
            }
        } else {
            if (rhs.pageRanges == null || this.pageRanges.length != rhs.pageRanges.length) {
                return false;
            }
            for (int i = 0; i < this.pageRanges.length; ++i) {
                if (this.pageRanges[i][0] == rhs.pageRanges[i][0] && this.pageRanges[i][1] == rhs.pageRanges[i][1]) continue;
                return false;
            }
        }
        if (this.printer == null ? rhs.printer != null : !this.printer.equals(rhs.printer)) {
            return false;
        }
        return this.copies == rhs.copies && this.defaultSelection == rhs.defaultSelection && this.destination == rhs.destination && this.dialog == rhs.dialog && this.fromPage == rhs.fromPage && this.maxPage == rhs.maxPage && this.minPage == rhs.minPage && this.multipleDocumentHandling == rhs.multipleDocumentHandling && this.prFirst == rhs.prFirst && this.prLast == rhs.prLast && this.sides == rhs.sides && this.toPage == rhs.toPage;
    }

    public int hashCode() {
        int rest = (this.copies + this.fromPage + this.maxPage + this.minPage + this.prFirst + this.prLast + this.toPage) * 31 << 21;
        if (this.pageRanges != null) {
            int sum = 0;
            for (int i = 0; i < this.pageRanges.length; ++i) {
                sum += this.pageRanges[i][0] + this.pageRanges[i][1];
            }
            rest ^= sum * 31 << 11;
        }
        if (this.fileName != null) {
            rest ^= this.fileName.hashCode();
        }
        if (this.printer != null) {
            rest ^= this.printer.hashCode();
        }
        return this.defaultSelection.hashCode() << 6 ^ this.destination.hashCode() << 5 ^ this.dialog.hashCode() << 3 ^ this.multipleDocumentHandling.hashCode() << 2 ^ this.sides.hashCode() ^ rest;
    }

    public String toString() {
        int[][] pageRanges = this.getPageRanges();
        String prStr = "[";
        boolean first = true;
        for (int i = 0; i < pageRanges.length; ++i) {
            if (first) {
                first = false;
            } else {
                prStr = prStr + ",";
            }
            prStr = prStr + pageRanges[i][0] + ":" + pageRanges[i][1];
        }
        prStr = prStr + "]";
        return "copies=" + this.getCopies() + ",defaultSelection=" + this.getDefaultSelection() + ",destination=" + this.getDestination() + ",dialog=" + this.getDialog() + ",fileName=" + this.getFileName() + ",fromPage=" + this.getFromPage() + ",maxPage=" + this.getMaxPage() + ",minPage=" + this.getMinPage() + ",multiple-document-handling=" + this.getMultipleDocumentHandling() + ",page-ranges=" + prStr + ",printer=" + this.getPrinter() + ",sides=" + this.getSides() + ",toPage=" + this.getToPage();
    }

    public static final class SidesType
    extends AttributeValue {
        private static final int I_ONE_SIDED = 0;
        private static final int I_TWO_SIDED_LONG_EDGE = 1;
        private static final int I_TWO_SIDED_SHORT_EDGE = 2;
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int type) {
            super(type, NAMES);
        }
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final int I_SEPARATE_DOCUMENTS_COLLATED_COPIES = 0;
        private static final int I_SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = 1;
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int type) {
            super(type, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final int I_COMMON = 0;
        private static final int I_NATIVE = 1;
        private static final int I_NONE = 2;
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int type) {
            super(type, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final int I_FILE = 0;
        private static final int I_PRINTER = 1;
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int type) {
            super(type, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final int I_ALL = 0;
        private static final int I_RANGE = 1;
        private static final int I_SELECTION = 2;
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int type) {
            super(type, NAMES);
        }
    }
}

