/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.SerializationTester;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer
implements Serializable {
    private static final long serialVersionUID = 8996673345831063337L;
    protected DragSource dragSource;
    protected Component component;
    protected transient DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList<InputEvent> events = new ArrayList(1);

    protected DragGestureRecognizer(DragSource ds, Component c, int sa, DragGestureListener dgl) {
        if (ds == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        this.dragSource = ds;
        this.component = c;
        this.sourceActions = sa & 0x40000003;
        try {
            if (dgl != null) {
                this.addDragGestureListener(dgl);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    protected DragGestureRecognizer(DragSource ds, Component c, int sa) {
        this(ds, c, sa, null);
    }

    protected DragGestureRecognizer(DragSource ds, Component c) {
        this(ds, c, 0);
    }

    protected DragGestureRecognizer(DragSource ds) {
        this(ds, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public synchronized Component getComponent() {
        return this.component;
    }

    public synchronized void setComponent(Component c) {
        if (this.component != null && this.dragGestureListener != null) {
            this.unregisterListeners();
        }
        this.component = c;
        if (this.component != null && this.dragGestureListener != null) {
            this.registerListeners();
        }
    }

    public synchronized int getSourceActions() {
        return this.sourceActions;
    }

    public synchronized void setSourceActions(int actions2) {
        this.sourceActions = actions2 & 0x40000003;
    }

    public InputEvent getTriggerEvent() {
        return this.events.isEmpty() ? null : this.events.get(0);
    }

    public void resetRecognizer() {
        this.events.clear();
    }

    public synchronized void addDragGestureListener(DragGestureListener dgl) throws TooManyListenersException {
        if (this.dragGestureListener != null) {
            throw new TooManyListenersException();
        }
        this.dragGestureListener = dgl;
        if (this.component != null) {
            this.registerListeners();
        }
    }

    public synchronized void removeDragGestureListener(DragGestureListener dgl) {
        if (this.dragGestureListener == null || !this.dragGestureListener.equals(dgl)) {
            throw new IllegalArgumentException();
        }
        this.dragGestureListener = null;
        if (this.component != null) {
            this.unregisterListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireDragGestureRecognized(int dragAction, Point p) {
        try {
            if (this.dragGestureListener != null) {
                this.dragGestureListener.dragGestureRecognized(new DragGestureEvent(this, dragAction, p, this.events));
            }
        }
        finally {
            this.events.clear();
        }
    }

    protected synchronized void appendEvent(InputEvent awtie) {
        this.events.add(awtie);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(SerializationTester.test(this.dragGestureListener) ? this.dragGestureListener : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.dragGestureListener = (DragGestureListener)s.readObject();
    }
}

