/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextJustifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.BidiUtils;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.ExtendedTextLabel;
import sun.font.FontResolver;
import sun.font.GraphicComponent;
import sun.font.LayoutPathImpl;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;
import sun.text.CodePointIterator;

final class TextLine {
    private TextLineComponent[] fComponents;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private float[] locs;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private LayoutPathImpl lp;
    private boolean isSimple;
    private Rectangle pixelBounds;
    private FontRenderContext frc;
    private TextLineMetrics fMetrics = null;
    private static Function fgPosAdvF = new Function(){

        @Override
        float computeFunction(TextLine line, int componentIndex, int indexInArray) {
            TextLineComponent tlc = line.fComponents[componentIndex];
            int vi = line.getComponentVisualIndex(componentIndex);
            return line.locs[vi * 2] + tlc.getCharX(indexInArray) + tlc.getCharAdvance(indexInArray);
        }
    };
    private static Function fgAdvanceF = new Function(){

        @Override
        float computeFunction(TextLine line, int componentIndex, int indexInArray) {
            TextLineComponent tlc = line.fComponents[componentIndex];
            return tlc.getCharAdvance(indexInArray);
        }
    };
    private static Function fgXPositionF = new Function(){

        @Override
        float computeFunction(TextLine line, int componentIndex, int indexInArray) {
            int vi = line.getComponentVisualIndex(componentIndex);
            TextLineComponent tlc = line.fComponents[componentIndex];
            return line.locs[vi * 2] + tlc.getCharX(indexInArray);
        }
    };
    private static Function fgYPositionF = new Function(){

        @Override
        float computeFunction(TextLine line, int componentIndex, int indexInArray) {
            TextLineComponent tlc = line.fComponents[componentIndex];
            float charPos = tlc.getCharY(indexInArray);
            return charPos + line.getComponentShift(componentIndex);
        }
    };

    public TextLine(FontRenderContext frc, TextLineComponent[] components, float[] baselineOffsets, char[] chars, int charsStart, int charsLimit, int[] charLogicalOrder, byte[] charLevels, boolean isDirectionLTR) {
        int[] componentVisualOrder = TextLine.computeComponentOrder(components, charLogicalOrder);
        this.frc = frc;
        this.fComponents = components;
        this.fBaselineOffsets = baselineOffsets;
        this.fComponentVisualOrder = componentVisualOrder;
        this.fChars = chars;
        this.fCharsStart = charsStart;
        this.fCharsLimit = charsLimit;
        this.fCharLogicalOrder = charLogicalOrder;
        this.fCharLevels = charLevels;
        this.fIsDirectionLTR = isDirectionLTR;
        this.checkCtorArgs();
        this.init();
    }

    private void checkCtorArgs() {
        int checkCharCount = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            checkCharCount += this.fComponents[i].getNumCharacters();
        }
        if (checkCharCount != this.characterCount()) {
            throw new IllegalArgumentException("Invalid TextLine!  char count is different from sum of char counts of components.");
        }
    }

    private void init() {
        TextLineComponent tlc;
        float ascent = 0.0f;
        float descent = 0.0f;
        float leading = 0.0f;
        float advance = 0.0f;
        float maxGraphicHeight = 0.0f;
        float maxGraphicHeightWithLeading = 0.0f;
        boolean fitTopAndBottomGraphics = false;
        this.isSimple = true;
        for (int i = 0; i < this.fComponents.length; ++i) {
            tlc = this.fComponents[i];
            this.isSimple &= tlc.isSimple();
            CoreMetrics cm = tlc.getCoreMetrics();
            byte baseline = (byte)cm.baselineIndex;
            if (baseline >= 0) {
                float baselineOffset = this.fBaselineOffsets[baseline];
                ascent = Math.max(ascent, -baselineOffset + cm.ascent);
                float gd = baselineOffset + cm.descent;
                descent = Math.max(descent, gd);
                leading = Math.max(leading, gd + cm.leading);
                continue;
            }
            fitTopAndBottomGraphics = true;
            float graphicHeight = cm.ascent + cm.descent;
            float graphicHeightWithLeading = graphicHeight + cm.leading;
            maxGraphicHeight = Math.max(maxGraphicHeight, graphicHeight);
            maxGraphicHeightWithLeading = Math.max(maxGraphicHeightWithLeading, graphicHeightWithLeading);
        }
        if (fitTopAndBottomGraphics) {
            if (maxGraphicHeight > ascent + descent) {
                descent = maxGraphicHeight - ascent;
            }
            if (maxGraphicHeightWithLeading > ascent + leading) {
                leading = maxGraphicHeightWithLeading - ascent;
            }
        }
        leading -= descent;
        if (fitTopAndBottomGraphics) {
            this.fBaselineOffsets = new float[]{this.fBaselineOffsets[0], this.fBaselineOffsets[1], this.fBaselineOffsets[2], descent, -ascent};
        }
        float x = 0.0f;
        float y = 0.0f;
        CoreMetrics pcm = null;
        boolean needPath = false;
        this.locs = new float[this.fComponents.length * 2 + 2];
        int i = 0;
        int n = 0;
        while (i < this.fComponents.length) {
            tlc = this.fComponents[this.getComponentLogicalIndex(i)];
            CoreMetrics cm = tlc.getCoreMetrics();
            if (!(pcm == null || pcm.italicAngle == 0.0f && cm.italicAngle == 0.0f || pcm.italicAngle == cm.italicAngle && pcm.baselineIndex == cm.baselineIndex && pcm.ssOffset == cm.ssOffset)) {
                float pb = pcm.effectiveBaselineOffset(this.fBaselineOffsets);
                float pa = pb - pcm.ascent;
                float pd = pb + pcm.descent;
                float cb = cm.effectiveBaselineOffset(this.fBaselineOffsets);
                float ca = cb - cm.ascent;
                float cd = cb + cm.descent;
                float a = Math.max(pa, ca);
                float d = Math.min(pd, cd);
                float pax = pcm.italicAngle * (pb - a);
                float pdx = pcm.italicAngle * (pb - d);
                float cax = cm.italicAngle * (cb - a);
                float cdx = cm.italicAngle * (cb - d);
                float dax = pax - cax;
                float ddx = pdx - cdx;
                float dx = Math.max(dax, ddx);
                x += dx;
                y = cb;
            } else {
                y = cm.effectiveBaselineOffset(this.fBaselineOffsets);
            }
            this.locs[n] = x;
            this.locs[n + 1] = y;
            x += tlc.getAdvance();
            pcm = cm;
            needPath |= tlc.getBaselineTransform() != null;
            ++i;
            n += 2;
        }
        if (pcm.italicAngle != 0.0f) {
            float pb = pcm.effectiveBaselineOffset(this.fBaselineOffsets);
            float pa = pb - pcm.ascent;
            float pd = pb + pcm.descent;
            float d = pcm.italicAngle > 0.0f ? pb + pcm.ascent : (pb += pcm.ssOffset) - pcm.descent;
            x += (d *= pcm.italicAngle);
        }
        this.locs[this.locs.length - 2] = x;
        advance = x;
        this.fMetrics = new TextLineMetrics(ascent, descent, leading, advance);
        if (needPath) {
            AffineTransform at;
            this.isSimple = false;
            Point2D.Double pt = new Point2D.Double();
            double tx = 0.0;
            double ty = 0.0;
            LayoutPathImpl.SegmentPathBuilder builder = new LayoutPathImpl.SegmentPathBuilder();
            builder.moveTo(this.locs[0], 0.0);
            int i2 = 0;
            int n2 = 0;
            while (i2 < this.fComponents.length) {
                tlc = this.fComponents[this.getComponentLogicalIndex(i2)];
                AffineTransform at2 = tlc.getBaselineTransform();
                if (at2 != null) {
                    if ((at2.getType() & 1) != 0) {
                        double dx = at2.getTranslateX();
                        double dy = at2.getTranslateY();
                        builder.moveTo(tx += dx, ty += dy);
                    }
                }
                pt.x = this.locs[n2 + 2] - this.locs[n2];
                pt.y = 0.0;
                if (at2 != null) {
                    at2.deltaTransform(pt, pt);
                }
                builder.lineTo(tx += pt.x, ty += pt.y);
                ++i2;
                n2 += 2;
            }
            this.lp = builder.complete();
            if (this.lp == null && (at = (tlc = this.fComponents[this.getComponentLogicalIndex(0)]).getBaselineTransform()) != null) {
                this.lp = new LayoutPathImpl.EmptyPath(at);
            }
        }
    }

    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        boolean canCache;
        Rectangle result = null;
        if (frc != null && frc.equals(this.frc)) {
            frc = null;
        }
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        float rx = x - (float)ix;
        float ry = y - (float)iy;
        boolean bl = canCache = frc == null && rx == 0.0f && ry == 0.0f;
        if (canCache && this.pixelBounds != null) {
            result = new Rectangle(this.pixelBounds);
            result.x += ix;
            result.y += iy;
            return result;
        }
        if (this.isSimple) {
            int i = 0;
            int n = 0;
            while (i < this.fComponents.length) {
                TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
                Rectangle pb = tlc.getPixelBounds(frc, this.locs[n] + rx, this.locs[n + 1] + ry);
                if (!pb.isEmpty()) {
                    if (result == null) {
                        result = pb;
                    } else {
                        result.add(pb);
                    }
                }
                ++i;
                n += 2;
            }
            if (result == null) {
                result = new Rectangle(0, 0, 0, 0);
            }
        } else {
            int MARGIN = 3;
            Rectangle2D r2d = this.getVisualBounds();
            if (this.lp != null) {
                r2d = this.lp.mapShape(r2d).getBounds();
            }
            Rectangle bounds = r2d.getBounds();
            BufferedImage im = new BufferedImage(bounds.width + 6, bounds.height + 6, 2);
            Graphics2D g2d = im.createGraphics();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, im.getWidth(), im.getHeight());
            g2d.setColor(Color.BLACK);
            this.draw(g2d, rx + 3.0f - (float)bounds.x, ry + 3.0f - (float)bounds.y);
            result = TextLine.computePixelBounds(im);
            result.x -= 3 - bounds.x;
            result.y -= 3 - bounds.y;
        }
        if (canCache) {
            this.pixelBounds = new Rectangle(result);
        }
        result.x += ix;
        result.y += iy;
        return result;
    }

    static Rectangle computePixelBounds(BufferedImage im) {
        int v;
        int i;
        int w = im.getWidth();
        int h = im.getHeight();
        int l = -1;
        int t = -1;
        int r = w;
        int b = h;
        int[] buf = new int[w];
        block0: while (++t < h) {
            im.getRGB(0, t, buf.length, 1, buf, 0, w);
            for (i = 0; i < buf.length; ++i) {
                if (buf[i] != -1) break block0;
            }
        }
        buf = new int[w];
        block2: while (--b > t) {
            im.getRGB(0, b, buf.length, 1, buf, 0, w);
            for (i = 0; i < buf.length; ++i) {
                if (buf[i] != -1) break block2;
            }
        }
        ++b;
        block4: while (++l < r) {
            for (int i2 = t; i2 < b; ++i2) {
                v = im.getRGB(l, i2);
                if (v != -1) break block4;
            }
        }
        block6: while (--r > l) {
            for (int i3 = t; i3 < b; ++i3) {
                v = im.getRGB(r, i3);
                if (v != -1) break block6;
            }
        }
        return new Rectangle(l, t, ++r - l, b - t);
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public TextLineMetrics getMetrics() {
        return this.fMetrics;
    }

    public int visualToLogical(int visualIndex) {
        if (this.fCharLogicalOrder == null) {
            return visualIndex;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = BidiUtils.createInverseMap(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[visualIndex];
    }

    public int logicalToVisual(int logicalIndex) {
        return this.fCharLogicalOrder == null ? logicalIndex : this.fCharLogicalOrder[logicalIndex];
    }

    public byte getCharLevel(int logicalIndex) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[logicalIndex];
    }

    public boolean isCharLTR(int logicalIndex) {
        return (this.getCharLevel(logicalIndex) & 1) == 0;
    }

    public int getCharType(int logicalIndex) {
        return Character.getType(this.fChars[logicalIndex + this.fCharsStart]);
    }

    public boolean isCharSpace(int logicalIndex) {
        return Character.isSpaceChar(this.fChars[logicalIndex + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int logicalIndex) {
        return Character.isWhitespace(this.fChars[logicalIndex + this.fCharsStart]);
    }

    public float getCharAngle(int logicalIndex) {
        return this.getCoreMetricsAt((int)logicalIndex).italicAngle;
    }

    public CoreMetrics getCoreMetricsAt(int logicalIndex) {
        if (logicalIndex < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (logicalIndex > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int currentTlc = 0;
        int tlcStart = 0;
        int tlcLimit = 0;
        while ((tlcLimit += this.fComponents[currentTlc].getNumCharacters()) <= logicalIndex) {
            tlcStart = tlcLimit;
            if (++currentTlc < this.fComponents.length) continue;
        }
        return this.fComponents[currentTlc].getCoreMetrics();
    }

    public float getCharAscent(int logicalIndex) {
        return this.getCoreMetricsAt((int)logicalIndex).ascent;
    }

    public float getCharDescent(int logicalIndex) {
        return this.getCoreMetricsAt((int)logicalIndex).descent;
    }

    public float getCharShift(int logicalIndex) {
        return this.getCoreMetricsAt((int)logicalIndex).ssOffset;
    }

    private float applyFunctionAtIndex(int logicalIndex, Function f) {
        if (logicalIndex < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int tlcStart = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int tlcLimit = tlcStart + this.fComponents[i].getNumCharacters();
            if (tlcLimit > logicalIndex) {
                return f.computeFunction(this, i, logicalIndex - tlcStart);
            }
            tlcStart = tlcLimit;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharAdvance(int logicalIndex) {
        return this.applyFunctionAtIndex(logicalIndex, fgAdvanceF);
    }

    public float getCharXPosition(int logicalIndex) {
        return this.applyFunctionAtIndex(logicalIndex, fgXPositionF);
    }

    public float getCharYPosition(int logicalIndex) {
        return this.applyFunctionAtIndex(logicalIndex, fgYPositionF);
    }

    public float getCharLinePosition(int logicalIndex) {
        return this.getCharXPosition(logicalIndex);
    }

    public float getCharLinePosition(int logicalIndex, boolean leading) {
        Function f = this.isCharLTR(logicalIndex) == leading ? fgXPositionF : fgPosAdvF;
        return this.applyFunctionAtIndex(logicalIndex, f);
    }

    public boolean caretAtOffsetIsValid(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset.");
        }
        int tlcStart = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int tlcLimit = tlcStart + this.fComponents[i].getNumCharacters();
            if (tlcLimit > offset) {
                return this.fComponents[i].caretAtOffsetIsValid(offset - tlcStart);
            }
            tlcStart = tlcLimit;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private int getComponentLogicalIndex(int vi) {
        if (this.fComponentVisualOrder == null) {
            return vi;
        }
        return this.fComponentVisualOrder[vi];
    }

    private int getComponentVisualIndex(int li) {
        if (this.fComponentVisualOrder == null) {
            return li;
        }
        for (int i = 0; i < this.fComponentVisualOrder.length; ++i) {
            if (this.fComponentVisualOrder[i] != li) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("bad component index: " + li);
    }

    public Rectangle2D getCharBounds(int logicalIndex) {
        if (logicalIndex < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int tlcStart = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int tlcLimit = tlcStart + this.fComponents[i].getNumCharacters();
            if (tlcLimit > logicalIndex) {
                TextLineComponent tlc = this.fComponents[i];
                int indexInTlc = logicalIndex - tlcStart;
                Rectangle2D chBounds = tlc.getCharVisualBounds(indexInTlc);
                int vi = this.getComponentVisualIndex(i);
                chBounds.setRect(chBounds.getX() + (double)this.locs[vi * 2], chBounds.getY() + (double)this.locs[vi * 2 + 1], chBounds.getWidth(), chBounds.getHeight());
                return chBounds;
            }
            tlcStart = tlcLimit;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private float getComponentShift(int index) {
        CoreMetrics cm = this.fComponents[index].getCoreMetrics();
        return cm.effectiveBaselineOffset(this.fBaselineOffsets);
    }

    public void draw(Graphics2D g2, float x, float y) {
        if (this.lp == null) {
            int i = 0;
            int n = 0;
            while (i < this.fComponents.length) {
                TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
                tlc.draw(g2, this.locs[n] + x, this.locs[n + 1] + y);
                ++i;
                n += 2;
            }
        } else {
            AffineTransform oldTx = g2.getTransform();
            Point2D.Float pt = new Point2D.Float();
            int i = 0;
            int n = 0;
            while (i < this.fComponents.length) {
                TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
                this.lp.pathToPoint(this.locs[n], this.locs[n + 1], false, pt);
                pt.x += x;
                pt.y += y;
                AffineTransform at = tlc.getBaselineTransform();
                if (at != null) {
                    g2.translate((double)pt.x - at.getTranslateX(), (double)pt.y - at.getTranslateY());
                    g2.transform(at);
                    tlc.draw(g2, 0.0f, 0.0f);
                    g2.setTransform(oldTx);
                } else {
                    tlc.draw(g2, pt.x, pt.y);
                }
                ++i;
                n += 2;
            }
        }
    }

    public Rectangle2D getVisualBounds() {
        Rectangle2D result = null;
        int i = 0;
        int n = 0;
        while (i < this.fComponents.length) {
            TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
            Rectangle2D r = tlc.getVisualBounds();
            Point2D.Float pt = new Point2D.Float(this.locs[n], this.locs[n + 1]);
            if (this.lp == null) {
                r.setRect(r.getMinX() + (double)pt.x, r.getMinY() + (double)pt.y, r.getWidth(), r.getHeight());
            } else {
                this.lp.pathToPoint(pt, false, pt);
                AffineTransform at = tlc.getBaselineTransform();
                if (at != null) {
                    AffineTransform tx = AffineTransform.getTranslateInstance((double)pt.x - at.getTranslateX(), (double)pt.y - at.getTranslateY());
                    tx.concatenate(at);
                    r = tx.createTransformedShape(r).getBounds2D();
                } else {
                    r.setRect(r.getMinX() + (double)pt.x, r.getMinY() + (double)pt.y, r.getWidth(), r.getHeight());
                }
            }
            if (result == null) {
                result = r;
            } else {
                result.add(r);
            }
            ++i;
            n += 2;
        }
        if (result == null) {
            result = new Rectangle2D.Float(Float.MAX_VALUE, Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        }
        return result;
    }

    public Rectangle2D getItalicBounds() {
        float left = Float.MAX_VALUE;
        float right = -3.4028235E38f;
        float top = Float.MAX_VALUE;
        float bottom = -3.4028235E38f;
        int i = 0;
        int n = 0;
        while (i < this.fComponents.length) {
            TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
            Rectangle2D tlcBounds = tlc.getItalicBounds();
            float x = this.locs[n];
            float y = this.locs[n + 1];
            left = Math.min(left, x + (float)tlcBounds.getX());
            right = Math.max(right, x + (float)tlcBounds.getMaxX());
            top = Math.min(top, y + (float)tlcBounds.getY());
            bottom = Math.max(bottom, y + (float)tlcBounds.getMaxY());
            ++i;
            n += 2;
        }
        return new Rectangle2D.Float(left, top, right - left, bottom - top);
    }

    public Shape getOutline(AffineTransform tx) {
        GeneralPath dstShape = new GeneralPath(1);
        int i = 0;
        int n = 0;
        while (i < this.fComponents.length) {
            TextLineComponent tlc = this.fComponents[this.getComponentLogicalIndex(i)];
            dstShape.append(tlc.getOutline(this.locs[n], this.locs[n + 1]), false);
            ++i;
            n += 2;
        }
        if (tx != null) {
            dstShape.transform(tx);
        }
        return dstShape;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.fComponents.length; ++i) {
            buf.append(this.fComponents[i]);
        }
        return buf.toString();
    }

    public static TextLine fastCreateTextLine(FontRenderContext frc, char[] chars, Font font, CoreMetrics lm, Map attributes) {
        int bidiflags;
        boolean isDirectionLTR = true;
        byte[] levels = null;
        int[] charsLtoV = null;
        Bidi bidi = null;
        int characterCount = chars.length;
        boolean requiresBidi = false;
        byte[] embs = null;
        AttributeValues values = null;
        if (attributes != null) {
            values = AttributeValues.fromMap(attributes);
            if (values.getRunDirection() >= 0) {
                isDirectionLTR = values.getRunDirection() == 0;
                boolean bl = requiresBidi = !isDirectionLTR;
            }
            if (values.getBidiEmbedding() != 0) {
                requiresBidi = true;
                byte level = (byte)values.getBidiEmbedding();
                embs = new byte[characterCount];
                for (int i = 0; i < embs.length; ++i) {
                    embs[i] = level;
                }
            }
        }
        if (!requiresBidi) {
            requiresBidi = Bidi.requiresBidi(chars, 0, chars.length);
        }
        if (requiresBidi && !(bidi = new Bidi(chars, 0, embs, 0, chars.length, bidiflags = values == null ? -2 : values.getRunDirection())).isLeftToRight()) {
            levels = BidiUtils.getLevels(bidi);
            int[] charsVtoL = BidiUtils.createVisualToLogicalMap(levels);
            charsLtoV = BidiUtils.createInverseMap(charsVtoL);
            isDirectionLTR = bidi.baseIsLeftToRight();
        }
        Decoration decorator = Decoration.getDecoration(values);
        int layoutFlags = 0;
        TextLabelFactory factory = new TextLabelFactory(frc, chars, bidi, layoutFlags);
        TextLineComponent[] components = new TextLineComponent[1];
        components = TextLine.createComponentsOnRun(0, chars.length, chars, charsLtoV, levels, factory, font, lm, frc, decorator, components, 0);
        int numComponents = components.length;
        while (components[numComponents - 1] == null) {
            --numComponents;
        }
        if (numComponents != components.length) {
            TextLineComponent[] temp = new TextLineComponent[numComponents];
            System.arraycopy(components, 0, temp, 0, numComponents);
            components = temp;
        }
        return new TextLine(frc, components, lm.baselineOffsets, chars, 0, chars.length, charsLtoV, levels, isDirectionLTR);
    }

    private static TextLineComponent[] expandArray(TextLineComponent[] orig) {
        TextLineComponent[] newComponents = new TextLineComponent[orig.length + 8];
        System.arraycopy(orig, 0, newComponents, 0, orig.length);
        return newComponents;
    }

    public static TextLineComponent[] createComponentsOnRun(int runStart, int runLimit, char[] chars, int[] charsLtoV, byte[] levels, TextLabelFactory factory, Font font, CoreMetrics cm, FontRenderContext frc, Decoration decorator, TextLineComponent[] components, int numComponents) {
        int pos = runStart;
        do {
            int lmCount;
            int chunkLimit = TextLine.firstVisualChunk(charsLtoV, levels, pos, runLimit);
            do {
                int startPos = pos;
                if (cm == null) {
                    LineMetrics lineMetrics = font.getLineMetrics(chars, startPos, chunkLimit, frc);
                    cm = CoreMetrics.get(lineMetrics);
                    lmCount = lineMetrics.getNumChars();
                } else {
                    lmCount = chunkLimit - startPos;
                }
                ExtendedTextLabel nextComponent = factory.createExtended(font, cm, decorator, startPos, startPos + lmCount);
                if (++numComponents >= components.length) {
                    components = TextLine.expandArray(components);
                }
                components[numComponents - 1] = nextComponent;
            } while ((pos += lmCount) < chunkLimit);
        } while (pos < runLimit);
        return components;
    }

    public static TextLineComponent[] getComponents(StyledParagraph styledParagraph, char[] chars, int textStart, int textLimit, int[] charsLtoV, byte[] levels, TextLabelFactory factory) {
        TextLineComponent[] components;
        FontRenderContext frc = factory.getFontRenderContext();
        int numComponents = 0;
        TextLineComponent[] tempComponents = new TextLineComponent[1];
        int pos = textStart;
        do {
            int runLimit = Math.min(styledParagraph.getRunLimit(pos), textLimit);
            Decoration decorator = styledParagraph.getDecorationAt(pos);
            Object graphicOrFont = styledParagraph.getFontOrGraphicAt(pos);
            if (graphicOrFont instanceof GraphicAttribute) {
                AffineTransform baseRot = null;
                GraphicAttribute graphicAttribute = (GraphicAttribute)graphicOrFont;
                do {
                    int chunkLimit = TextLine.firstVisualChunk(charsLtoV, levels, pos, runLimit);
                    GraphicComponent nextGraphic = new GraphicComponent(graphicAttribute, decorator, charsLtoV, levels, pos, chunkLimit, baseRot);
                    pos = chunkLimit;
                    if (++numComponents >= tempComponents.length) {
                        tempComponents = TextLine.expandArray(tempComponents);
                    }
                    tempComponents[numComponents - 1] = nextGraphic;
                } while (pos < runLimit);
                continue;
            }
            Font font = (Font)graphicOrFont;
            tempComponents = TextLine.createComponentsOnRun(pos, runLimit, chars, charsLtoV, levels, factory, font, null, frc, decorator, tempComponents, numComponents);
            pos = runLimit;
            numComponents = tempComponents.length;
            while (tempComponents[numComponents - 1] == null) {
                --numComponents;
            }
        } while (pos < textLimit);
        if (tempComponents.length == numComponents) {
            components = tempComponents;
        } else {
            components = new TextLineComponent[numComponents];
            System.arraycopy(tempComponents, 0, components, 0, numComponents);
        }
        return components;
    }

    public static TextLine createLineFromText(char[] chars, StyledParagraph styledParagraph, TextLabelFactory factory, boolean isDirectionLTR, float[] baselineOffsets) {
        factory.setLineContext(0, chars.length);
        Bidi lineBidi = factory.getLineBidi();
        int[] charsLtoV = null;
        byte[] levels = null;
        if (lineBidi != null) {
            levels = BidiUtils.getLevels(lineBidi);
            int[] charsVtoL = BidiUtils.createVisualToLogicalMap(levels);
            charsLtoV = BidiUtils.createInverseMap(charsVtoL);
        }
        TextLineComponent[] components = TextLine.getComponents(styledParagraph, chars, 0, chars.length, charsLtoV, levels, factory);
        return new TextLine(factory.getFontRenderContext(), components, baselineOffsets, chars, 0, chars.length, charsLtoV, levels, isDirectionLTR);
    }

    private static int[] computeComponentOrder(TextLineComponent[] components, int[] charsLtoV) {
        int[] componentOrder = null;
        if (charsLtoV != null && components.length > 1) {
            componentOrder = new int[components.length];
            int gStart = 0;
            for (int i = 0; i < components.length; ++i) {
                componentOrder[i] = charsLtoV[gStart];
                gStart += components[i].getNumCharacters();
            }
            componentOrder = BidiUtils.createContiguousOrder(componentOrder);
            componentOrder = BidiUtils.createInverseMap(componentOrder);
        }
        return componentOrder;
    }

    public static TextLine standardCreateTextLine(FontRenderContext frc, AttributedCharacterIterator text, char[] chars, float[] baselineOffsets) {
        StyledParagraph styledParagraph = new StyledParagraph(text, chars);
        Bidi bidi = new Bidi(text);
        if (bidi.isLeftToRight()) {
            bidi = null;
        }
        int layoutFlags = 0;
        TextLabelFactory factory = new TextLabelFactory(frc, chars, bidi, layoutFlags);
        boolean isDirectionLTR = true;
        if (bidi != null) {
            isDirectionLTR = bidi.baseIsLeftToRight();
        }
        return TextLine.createLineFromText(chars, styledParagraph, factory, isDirectionLTR, baselineOffsets);
    }

    static boolean advanceToFirstFont(AttributedCharacterIterator aci) {
        char ch = aci.first();
        while (true) {
            if (ch == '\uffff') break;
            if (aci.getAttribute(TextAttribute.CHAR_REPLACEMENT) == null) {
                return true;
            }
            ch = aci.setIndex(aci.getRunLimit());
        }
        return false;
    }

    static float[] getNormalizedOffsets(float[] baselineOffsets, byte baseline) {
        if (baselineOffsets[baseline] != 0.0f) {
            float base = baselineOffsets[baseline];
            float[] temp = new float[baselineOffsets.length];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = baselineOffsets[i] - base;
            }
            baselineOffsets = temp;
        }
        return baselineOffsets;
    }

    static Font getFontAtCurrentPos(AttributedCharacterIterator aci) {
        Object value = aci.getAttribute(TextAttribute.FONT);
        if (value != null) {
            return (Font)value;
        }
        if (aci.getAttribute(TextAttribute.FAMILY) != null) {
            return Font.getFont(aci.getAttributes());
        }
        int ch = CodePointIterator.create(aci).next();
        if (ch != -1) {
            FontResolver resolver = FontResolver.getInstance();
            return resolver.getFont(resolver.getFontIndex(ch), aci.getAttributes());
        }
        return null;
    }

    private static int firstVisualChunk(int[] order, byte[] direction, int start, int limit) {
        if (order != null && direction != null) {
            byte dir = direction[start];
            while (++start < limit && direction[start] == dir) {
            }
            return start;
        }
        return limit;
    }

    public TextLine getJustifiedLine(float justificationWidth, float justifyRatio, int justStart, int justLimit) {
        boolean wantRejustify;
        TextLineComponent[] newComponents = new TextLineComponent[this.fComponents.length];
        System.arraycopy(this.fComponents, 0, newComponents, 0, this.fComponents.length);
        float leftHang = 0.0f;
        float adv = 0.0f;
        float justifyDelta = 0.0f;
        boolean rejustify = false;
        block0: do {
            int infoStart;
            adv = TextLine.getAdvanceBetween(newComponents, 0, this.characterCount());
            float justifyAdvance = TextLine.getAdvanceBetween(newComponents, justStart, justLimit);
            justifyDelta = (justificationWidth - justifyAdvance) * justifyRatio;
            int[] infoPositions = new int[newComponents.length];
            int infoCount = 0;
            for (int visIndex = 0; visIndex < newComponents.length; ++visIndex) {
                int logIndex = this.getComponentLogicalIndex(visIndex);
                infoPositions[logIndex] = infoCount;
                infoCount += newComponents[logIndex].getNumJustificationInfos();
            }
            GlyphJustificationInfo[] infos = new GlyphJustificationInfo[infoCount];
            int compStart = 0;
            for (int i = 0; i < newComponents.length; ++i) {
                TextLineComponent comp = newComponents[i];
                int compLength = comp.getNumCharacters();
                int compLimit = compStart + compLength;
                if (compLimit <= justStart) continue;
                int rangeMin = Math.max(0, justStart - compStart);
                int rangeMax = Math.min(compLength, justLimit - compStart);
                comp.getJustificationInfos(infos, infoPositions[i], rangeMin, rangeMax);
                if (compLimit >= justLimit) break;
            }
            int infoLimit = infoCount;
            for (infoStart = 0; infoStart < infoLimit && infos[infoStart] == null; ++infoStart) {
            }
            while (infoLimit > infoStart && infos[infoLimit - 1] == null) {
                --infoLimit;
            }
            TextJustifier justifier = new TextJustifier(infos, infoStart, infoLimit);
            float[] deltas = justifier.justify(justifyDelta);
            boolean canRejustify = !rejustify;
            wantRejustify = false;
            boolean[] flags = new boolean[1];
            compStart = 0;
            for (int i = 0; i < newComponents.length; ++i) {
                TextLineComponent comp = newComponents[i];
                int compLength = comp.getNumCharacters();
                int compLimit = compStart + compLength;
                if (compLimit <= justStart) continue;
                int rangeMin = Math.max(0, justStart - compStart);
                int rangeMax = Math.min(compLength, justLimit - compStart);
                newComponents[i] = comp.applyJustificationDeltas(deltas, infoPositions[i] * 2, flags);
                wantRejustify |= flags[0];
                if (compLimit >= justLimit) continue block0;
            }
        } while (rejustify = wantRejustify && !rejustify);
        return new TextLine(this.frc, newComponents, this.fBaselineOffsets, this.fChars, this.fCharsStart, this.fCharsLimit, this.fCharLogicalOrder, this.fCharLevels, this.fIsDirectionLTR);
    }

    public static float getAdvanceBetween(TextLineComponent[] components, int start, int limit) {
        float advance = 0.0f;
        int tlcStart = 0;
        for (int i = 0; i < components.length; ++i) {
            TextLineComponent comp = components[i];
            int tlcLength = comp.getNumCharacters();
            int tlcLimit = tlcStart + tlcLength;
            if (tlcLimit > start) {
                int measureStart = Math.max(0, start - tlcStart);
                int measureLimit = Math.min(tlcLength, limit - tlcStart);
                advance += comp.getAdvanceBetween(measureStart, measureLimit);
                if (tlcLimit >= limit) break;
            }
            tlcStart = tlcLimit;
        }
        return advance;
    }

    LayoutPathImpl getLayoutPath() {
        return this.lp;
    }

    private static abstract class Function {
        private Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float ascent, float descent, float leading, float advance) {
            this.ascent = ascent;
            this.descent = descent;
            this.leading = leading;
            this.advance = advance;
        }
    }
}

