/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    public ConcurrentLinkedQueue() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedQueue(Collection<? extends E> c) {
        Node<Object> h = null;
        Node<Object> t = null;
        for (E e : c) {
            ConcurrentLinkedQueue.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = new Node<Object>(null);
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> h, Node<E> p) {
        if (h != p && this.casHead(h, p)) {
            h.lazySetNext(h);
        }
    }

    final Node<E> succ(Node<E> p) {
        Node next = p.next;
        return p == next ? this.head : next;
    }

    @Override
    public boolean offer(E e) {
        Node t;
        ConcurrentLinkedQueue.checkNotNull(e);
        Node<E> newNode = new Node<E>(e);
        Node p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!p.casNext(null, newNode)) continue;
                if (p != t) {
                    this.casTail(t, newNode);
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public E poll() {
        block0: while (true) {
            Node<Object> h;
            Node<Object> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null && p.casItem(item, null)) {
                    if (p != h) {
                        q = p.next;
                        this.updateHead(h, q != null ? q : p);
                    }
                    return item;
                }
                q = p.next;
                if (q == null) {
                    this.updateHead(h, p);
                    return null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return item;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    Node<E> first() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                boolean hasItem;
                boolean bl = hasItem = p.item != null;
                if (hasItem || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return hasItem ? p : null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int count = 0;
        Node<E> p = this.first();
        while (p != null && (p.item == null || ++count != Integer.MAX_VALUE)) {
            p = this.succ(p);
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item)) {
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> pred = null;
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                Node<E> next = this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                return true;
            }
            pred = p;
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node<E> beginningOfTheEnd = null;
        Node<E> last = null;
        for (E e : c) {
            ConcurrentLinkedQueue.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            last.lazySetNext(newNode);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        Node p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!p.casNext(null, beginningOfTheEnd)) continue;
                if (!this.casTail(t, last)) {
                    t = this.tail;
                    if (last.next == null) {
                        this.casTail(t, last);
                    }
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public Object[] toArray() {
        ArrayList al = new ArrayList();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                al.add(item);
            }
            p = this.succ(p);
        }
        return al.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int k = 0;
        Node<E> p = this.first();
        while (p != null && k < a.length) {
            Object item = p.item;
            if (item != null) {
                a[k++] = item;
            }
            p = this.succ(p);
        }
        if (p == null) {
            if (k < a.length) {
                a[k] = null;
            }
            return a;
        }
        ArrayList al = new ArrayList();
        Node<E> q = this.first();
        while (q != null) {
            Object item = q.item;
            if (item != null) {
                al.add(item);
            }
            q = this.succ(q);
        }
        return al.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                s.writeObject(item);
            }
            p = this.succ(p);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = new Node<Object>(null);
        }
        this.head = h;
        this.tail = t;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentLinkedQueue> k = ConcurrentLinkedQueue.class;
            headOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("tail"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node pred;
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            if (this.nextNode == null) {
                p = ConcurrentLinkedQueue.this.first();
                pred = null;
            } else {
                pred = this.nextNode;
                p = ConcurrentLinkedQueue.this.succ(this.nextNode);
            }
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.item;
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                Node next = ConcurrentLinkedQueue.this.succ(p);
                if (pred != null && next != null) {
                    pred.casNext(p, next);
                }
                p = next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long itemOffset;
        private static final long nextOffset;

        Node(E item) {
            UNSAFE.putObject((Object)this, itemOffset, item);
        }

        boolean casItem(E cmp, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        void lazySetNext(Node<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = Unsafe.getUnsafe();
                Class<Node> k = Node.class;
                itemOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

