/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.remote.util.ClassLogger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private List<ListenerInfo> listenerList = new CopyOnWriteArrayList<ListenerInfo>();
    private final Executor executor;
    private final MBeanNotificationInfo[] notifInfo;
    private static final Executor defaultExecutor = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    private static final MBeanNotificationInfo[] NO_NOTIFICATION_INFO = new MBeanNotificationInfo[0];
    private static final ClassLogger logger = new ClassLogger("javax.management", "NotificationBroadcasterSupport");

    public NotificationBroadcasterSupport() {
        this((Executor)null, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(Executor executor) {
        this(executor, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(MBeanNotificationInfo ... info) {
        this((Executor)null, info);
    }

    public NotificationBroadcasterSupport(Executor executor, MBeanNotificationInfo ... info) {
        this.executor = executor != null ? executor : defaultExecutor;
        this.notifInfo = info == null ? NO_NOTIFICATION_INFO : (MBeanNotificationInfo[])info.clone();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        this.listenerList.add(new ListenerInfo(listener, filter, handback));
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        WildcardListenerInfo wildcard = new WildcardListenerInfo(listener);
        boolean removed = this.listenerList.removeAll(Collections.singleton(wildcard));
        if (!removed) {
            throw new ListenerNotFoundException("Listener not registered");
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ListenerInfo li = new ListenerInfo(listener, filter, handback);
        boolean removed = this.listenerList.remove(li);
        if (!removed) {
            throw new ListenerNotFoundException("Listener not registered (with this filter and handback)");
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfo.length == 0) {
            return this.notifInfo;
        }
        return (MBeanNotificationInfo[])this.notifInfo.clone();
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        for (ListenerInfo li : this.listenerList) {
            boolean enabled;
            try {
                enabled = li.filter == null || li.filter.isNotificationEnabled(notification);
            }
            catch (Exception e) {
                if (!logger.debugOn()) continue;
                logger.debug("sendNotification", e);
                continue;
            }
            if (!enabled) continue;
            this.executor.execute(new SendNotifJob(notification, li));
        }
    }

    protected void handleNotification(NotificationListener listener, Notification notif, Object handback) {
        listener.handleNotification(notif, handback);
    }

    private class SendNotifJob
    implements Runnable {
        private final Notification notif;
        private final ListenerInfo listenerInfo;

        public SendNotifJob(Notification notif, ListenerInfo listenerInfo) {
            this.notif = notif;
            this.listenerInfo = listenerInfo;
        }

        @Override
        public void run() {
            block2: {
                try {
                    NotificationBroadcasterSupport.this.handleNotification(this.listenerInfo.listener, this.notif, this.listenerInfo.handback);
                }
                catch (Exception e) {
                    if (!logger.debugOn()) break block2;
                    logger.debug("SendNotifJob-run", e);
                }
            }
        }
    }

    private static class WildcardListenerInfo
    extends ListenerInfo {
        WildcardListenerInfo(NotificationListener listener) {
            super(listener, null, null);
        }

        @Override
        public boolean equals(Object o) {
            assert (!(o instanceof WildcardListenerInfo));
            return o.equals(this);
        }
    }

    private static class ListenerInfo {
        NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        ListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ListenerInfo)) {
                return false;
            }
            ListenerInfo li = (ListenerInfo)o;
            if (li instanceof WildcardListenerInfo) {
                return li.listener == this.listener;
            }
            return li.listener == this.listener && li.filter == this.filter && li.handback == this.handback;
        }
    }
}

