/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.List;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class NotificationFilterSupport
implements NotificationFilter {
    private static final long serialVersionUID = 6579080007561786969L;
    private List<String> enabledTypes = new Vector<String>();

    @Override
    public synchronized boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        if (type == null) {
            return false;
        }
        try {
            for (String prefix : this.enabledTypes) {
                if (!type.startsWith(prefix)) continue;
                return true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    public synchronized void enableType(String prefix) throws IllegalArgumentException {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        if (!this.enabledTypes.contains(prefix)) {
            this.enabledTypes.add(prefix);
        }
    }

    public synchronized void disableType(String prefix) {
        this.enabledTypes.remove(prefix);
    }

    public synchronized void disableAllTypes() {
        this.enabledTypes.clear();
    }

    public synchronized Vector<String> getEnabledTypes() {
        return (Vector)this.enabledTypes;
    }
}

