/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

class MimeType
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2785720609362367683L;
    private String[] myPieces;
    private transient String myStringValue = null;
    private transient ParameterMapEntrySet myEntrySet = null;
    private transient ParameterMap myParameterMap = null;
    private static final int TOKEN_LEXEME = 0;
    private static final int QUOTED_STRING_LEXEME = 1;
    private static final int TSPECIAL_LEXEME = 2;
    private static final int EOF_LEXEME = 3;
    private static final int ILLEGAL_LEXEME = 4;

    public MimeType(String s) {
        this.parse(s);
    }

    public String getMimeType() {
        return this.getStringValue();
    }

    public String getMediaType() {
        return this.myPieces[0];
    }

    public String getMediaSubtype() {
        return this.myPieces[1];
    }

    public Map getParameterMap() {
        if (this.myParameterMap == null) {
            this.myParameterMap = new ParameterMap();
        }
        return this.myParameterMap;
    }

    public String toString() {
        return this.getStringValue();
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof MimeType && this.getStringValue().equals(((MimeType)obj).getStringValue());
    }

    private String getStringValue() {
        if (this.myStringValue == null) {
            StringBuffer result = new StringBuffer();
            result.append(this.myPieces[0]);
            result.append('/');
            result.append(this.myPieces[1]);
            int n = this.myPieces.length;
            for (int i = 2; i < n; i += 2) {
                result.append(';');
                result.append(' ');
                result.append(this.myPieces[i]);
                result.append('=');
                result.append(MimeType.addQuotes(this.myPieces[i + 1]));
            }
            this.myStringValue = result.toString();
        }
        return this.myStringValue;
    }

    private static String toUnicodeLowerCase(String s) {
        int n = s.length();
        char[] result = new char[n];
        for (int i = 0; i < n; ++i) {
            result[i] = Character.toLowerCase(s.charAt(i));
        }
        return new String(result);
    }

    private static String removeBackslashes(String s) {
        int n = s.length();
        char[] result = new char[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                c = s.charAt(++i);
            }
            result[j++] = c;
        }
        return new String(result, 0, j);
    }

    private static String addQuotes(String s) {
        int n = s.length();
        StringBuffer result = new StringBuffer(n + 2);
        result.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                result.append('\\');
            }
            result.append(c);
        }
        result.append('\"');
        return result.toString();
    }

    private void parse(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        LexicalAnalyzer theLexer = new LexicalAnalyzer(s);
        Vector<String> thePieces = new Vector<String>();
        boolean mediaTypeIsText = false;
        boolean parameterNameIsCharset = false;
        if (theLexer.getLexemeType() != 0) {
            throw new IllegalArgumentException();
        }
        String mt = MimeType.toUnicodeLowerCase(theLexer.getLexeme());
        thePieces.add(mt);
        theLexer.nextLexeme();
        mediaTypeIsText = mt.equals("text");
        if (theLexer.getLexemeType() != 2 || theLexer.getLexemeFirstCharacter() != '/') {
            throw new IllegalArgumentException();
        }
        theLexer.nextLexeme();
        if (theLexer.getLexemeType() == 0) {
            thePieces.add(MimeType.toUnicodeLowerCase(theLexer.getLexeme()));
            theLexer.nextLexeme();
        } else {
            throw new IllegalArgumentException();
        }
        while (theLexer.getLexemeType() == 2 && theLexer.getLexemeFirstCharacter() == ';') {
            String pv;
            theLexer.nextLexeme();
            if (theLexer.getLexemeType() != 0) {
                throw new IllegalArgumentException();
            }
            String pn = MimeType.toUnicodeLowerCase(theLexer.getLexeme());
            thePieces.add(pn);
            theLexer.nextLexeme();
            parameterNameIsCharset = pn.equals("charset");
            if (theLexer.getLexemeType() != 2 || theLexer.getLexemeFirstCharacter() != '=') {
                throw new IllegalArgumentException();
            }
            theLexer.nextLexeme();
            if (theLexer.getLexemeType() == 0) {
                pv = theLexer.getLexeme();
                thePieces.add(mediaTypeIsText && parameterNameIsCharset ? MimeType.toUnicodeLowerCase(pv) : pv);
                theLexer.nextLexeme();
                continue;
            }
            if (theLexer.getLexemeType() == 1) {
                pv = MimeType.removeBackslashes(theLexer.getLexeme());
                thePieces.add(mediaTypeIsText && parameterNameIsCharset ? MimeType.toUnicodeLowerCase(pv) : pv);
                theLexer.nextLexeme();
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (theLexer.getLexemeType() != 3) {
            throw new IllegalArgumentException();
        }
        int n = thePieces.size();
        this.myPieces = thePieces.toArray(new String[n]);
        for (int i = 4; i < n; i += 2) {
            int j;
            for (j = 2; j < i && this.myPieces[j].compareTo(this.myPieces[i]) <= 0; j += 2) {
            }
            while (j < i) {
                String temp = this.myPieces[j];
                this.myPieces[j] = this.myPieces[i];
                this.myPieces[i] = temp;
                temp = this.myPieces[j + 1];
                this.myPieces[j + 1] = this.myPieces[i + 1];
                this.myPieces[i + 1] = temp;
                j += 2;
            }
        }
    }

    private static class LexicalAnalyzer {
        protected String mySource;
        protected int mySourceLength;
        protected int myCurrentIndex;
        protected int myLexemeType;
        protected int myLexemeBeginIndex;
        protected int myLexemeEndIndex;

        public LexicalAnalyzer(String theSource) {
            this.mySource = theSource;
            this.mySourceLength = theSource.length();
            this.myCurrentIndex = 0;
            this.nextLexeme();
        }

        public int getLexemeType() {
            return this.myLexemeType;
        }

        public String getLexeme() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? null : this.mySource.substring(this.myLexemeBeginIndex, this.myLexemeEndIndex);
        }

        public char getLexemeFirstCharacter() {
            return this.myLexemeBeginIndex >= this.mySourceLength ? (char)'\u0000' : this.mySource.charAt(this.myLexemeBeginIndex);
        }

        public void nextLexeme() {
            int state = 0;
            int commentLevel = 0;
            while (state >= 0) {
                switch (state) {
                    case 0: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 3;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            state = -1;
                            break;
                        }
                        if (Character.isWhitespace(c = this.mySource.charAt(this.myCurrentIndex++))) {
                            state = 0;
                            break;
                        }
                        if (c == '\"') {
                            this.myLexemeType = 1;
                            this.myLexemeBeginIndex = this.myCurrentIndex;
                            state = 1;
                            break;
                        }
                        if (c == '(') {
                            ++commentLevel;
                            state = 3;
                            break;
                        }
                        if (c == '/' || c == ';' || c == '=' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '?') {
                            this.myLexemeType = 2;
                            this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            state = -1;
                            break;
                        }
                        this.myLexemeType = 0;
                        this.myLexemeBeginIndex = this.myCurrentIndex - 1;
                        state = 5;
                        break;
                    }
                    case 1: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            state = -1;
                            break;
                        }
                        if ((c = this.mySource.charAt(this.myCurrentIndex++)) == '\"') {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            state = -1;
                            break;
                        }
                        if (c == '\\') {
                            state = 2;
                            break;
                        }
                        state = 1;
                        break;
                    }
                    case 2: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            state = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        state = 1;
                        break;
                    }
                    case 3: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            state = -1;
                            break;
                        }
                        if ((c = this.mySource.charAt(this.myCurrentIndex++)) == '(') {
                            ++commentLevel;
                            state = 3;
                            break;
                        }
                        if (c == ')') {
                            state = --commentLevel == 0 ? 0 : 3;
                            break;
                        }
                        if (c == '\\') {
                            state = 4;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    case 4: {
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeType = 4;
                            this.myLexemeBeginIndex = this.mySourceLength;
                            this.myLexemeEndIndex = this.mySourceLength;
                            state = -1;
                            break;
                        }
                        ++this.myCurrentIndex;
                        state = 3;
                        break;
                    }
                    case 5: {
                        char c;
                        if (this.myCurrentIndex >= this.mySourceLength) {
                            this.myLexemeEndIndex = this.myCurrentIndex;
                            state = -1;
                            break;
                        }
                        if (Character.isWhitespace(c = this.mySource.charAt(this.myCurrentIndex++))) {
                            this.myLexemeEndIndex = this.myCurrentIndex - 1;
                            state = -1;
                            break;
                        }
                        if (c == '\"' || c == '(' || c == '/' || c == ';' || c == '=' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '?') {
                            this.myLexemeEndIndex = --this.myCurrentIndex;
                            state = -1;
                            break;
                        }
                        state = 5;
                    }
                }
            }
        }
    }

    private class ParameterMap
    extends AbstractMap {
        private ParameterMap() {
        }

        @Override
        public Set entrySet() {
            if (MimeType.this.myEntrySet == null) {
                MimeType.this.myEntrySet = new ParameterMapEntrySet();
            }
            return MimeType.this.myEntrySet;
        }
    }

    private class ParameterMapEntrySet
    extends AbstractSet {
        private ParameterMapEntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new ParameterMapEntrySetIterator();
        }

        @Override
        public int size() {
            return (MimeType.this.myPieces.length - 2) / 2;
        }
    }

    private class ParameterMapEntrySetIterator
    implements Iterator {
        private int myIndex = 2;

        private ParameterMapEntrySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < MimeType.this.myPieces.length;
        }

        public Object next() {
            if (this.hasNext()) {
                ParameterMapEntry result = new ParameterMapEntry(this.myIndex);
                this.myIndex += 2;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ParameterMapEntry
    implements Map.Entry {
        private int myIndex;

        public ParameterMapEntry(int theIndex) {
            this.myIndex = theIndex;
        }

        public Object getKey() {
            return MimeType.this.myPieces[this.myIndex];
        }

        public Object getValue() {
            return MimeType.this.myPieces[this.myIndex + 1];
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o instanceof Map.Entry && this.getKey().equals(((Map.Entry)o).getKey()) && this.getValue().equals(((Map.Entry)o).getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }
    }
}

