/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletPropsErrorDialog;
import sun.applet.AppletSecurity;
import sun.applet.Main;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

class AppletProps
extends Frame {
    TextField proxyHost;
    TextField proxyPort;
    Choice accessMode;
    private static AppletMessageHandler amh = new AppletMessageHandler("appletprops");

    AppletProps() {
        this.setTitle(amh.getMessage("title"));
        Panel p = new Panel();
        p.setLayout(new GridLayout(0, 2));
        p.add(new Label(amh.getMessage("label.http.server", "Http proxy server:")));
        this.proxyHost = new TextField();
        p.add(this.proxyHost);
        p.add(new Label(amh.getMessage("label.http.proxy")));
        this.proxyPort = new TextField();
        p.add(this.proxyPort);
        p.add(new Label(amh.getMessage("label.class")));
        this.accessMode = new Choice();
        p.add(this.accessMode);
        this.accessMode.addItem(amh.getMessage("choice.class.item.restricted"));
        this.accessMode.addItem(amh.getMessage("choice.class.item.unrestricted"));
        this.add("Center", p);
        p = new Panel();
        p.add(new Button(amh.getMessage("button.apply")));
        p.add(new Button(amh.getMessage("button.reset")));
        p.add(new Button(amh.getMessage("button.cancel")));
        this.add("South", p);
        this.move(200, 150);
        this.pack();
        this.reset();
    }

    void reset() {
        AppletSecurity security = (AppletSecurity)System.getSecurityManager();
        if (security != null) {
            security.reset();
        }
        String proxyhost = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        String proxyport = AccessController.doPrivileged(new GetPropertyAction("http.proxyPort"));
        Boolean tmp = AccessController.doPrivileged(new GetBooleanAction("package.restrict.access.sun"));
        boolean packageRestrict = tmp;
        if (packageRestrict) {
            this.accessMode.select(amh.getMessage("choice.class.item.restricted"));
        } else {
            this.accessMode.select(amh.getMessage("choice.class.item.unrestricted"));
        }
        if (proxyhost != null) {
            this.proxyHost.setText(proxyhost);
            this.proxyPort.setText(proxyport);
        } else {
            this.proxyHost.setText("");
            this.proxyPort.setText("");
        }
    }

    void apply() {
        String proxyHostValue = this.proxyHost.getText().trim();
        String proxyPortValue = this.proxyPort.getText().trim();
        final Properties props = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        if (proxyHostValue.length() != 0) {
            int proxyPortNumber = 0;
            try {
                proxyPortNumber = Integer.parseInt(proxyPortValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (proxyPortNumber <= 0) {
                this.proxyPort.selectAll();
                this.proxyPort.requestFocus();
                new AppletPropsErrorDialog((Frame)this, amh.getMessage("title.invalidproxy"), amh.getMessage("label.invalidproxy"), amh.getMessage("button.ok")).show();
                return;
            }
            props.put("http.proxyHost", proxyHostValue);
            props.put("http.proxyPort", proxyPortValue);
        } else {
            props.put("http.proxyHost", "");
        }
        if (amh.getMessage("choice.class.item.restricted").equals(this.accessMode.getSelectedItem())) {
            props.put("package.restrict.access.sun", "true");
        } else {
            props.put("package.restrict.access.sun", "false");
        }
        try {
            this.reset();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File dotAV = Main.theUserPropertiesFile;
                    FileOutputStream out = new FileOutputStream(dotAV);
                    Properties avProps = new Properties();
                    for (int i = 0; i < Main.avDefaultUserProps.length; ++i) {
                        String avKey = Main.avDefaultUserProps[i][0];
                        avProps.setProperty(avKey, props.getProperty(avKey));
                    }
                    avProps.store(out, amh.getMessage("prop.store"));
                    out.close();
                    return null;
                }
            });
            this.hide();
        }
        catch (PrivilegedActionException e) {
            System.out.println(amh.getMessage("apply.exception", e.getException()));
            e.printStackTrace();
            this.reset();
        }
    }

    @Override
    public boolean action(Event evt, Object obj) {
        if (amh.getMessage("button.apply").equals(obj)) {
            this.apply();
            return true;
        }
        if (amh.getMessage("button.reset").equals(obj)) {
            this.reset();
            return true;
        }
        if (amh.getMessage("button.cancel").equals(obj)) {
            this.reset();
            this.hide();
            return true;
        }
        return false;
    }
}

