/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import sun.awt.AWTAutoShutdown;
import sun.awt.EventQueueItem;
import sun.awt.SunToolkit;

class PostEventQueue {
    private EventQueueItem queueHead = null;
    private EventQueueItem queueTail = null;
    private final EventQueue eventQueue;
    private volatile boolean isFlushing = false;

    PostEventQueue(EventQueue eq) {
        this.eventQueue = eq;
    }

    public synchronized boolean noEvents() {
        return this.queueHead == null && !this.isFlushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EventQueueItem tempQueue;
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            tempQueue = this.queueHead;
            this.queueTail = null;
            this.queueHead = null;
            this.isFlushing = tempQueue != null;
        }
        try {
            while (tempQueue != null) {
                this.eventQueue.postEvent(tempQueue.event);
                tempQueue = tempQueue.next;
            }
        }
        finally {
            this.isFlushing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(AWTEvent event) {
        EventQueueItem item = new EventQueueItem(event);
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            if (this.queueHead == null) {
                this.queueHead = this.queueTail = item;
            } else {
                this.queueTail.next = item;
                this.queueTail = item;
            }
        }
        SunToolkit.wakeupEventQueue(this.eventQueue, event.getSource() == AWTAutoShutdown.getInstance());
    }
}

